<?php

if ( ! class_exists( 'ST_Item_List' ) ) {

	class ST_Item_List extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'data-modal-title' => __( 'List Item', ST_PBL ),

			);

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		/**
		 * DEFINE setting options of shortcode
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
			array(
						'name'    => __( 'Heading', ST_PBL ),
						'id'      => 'heading',
						'type'    => 'text_field',
						'class'   => 'jsn-input-xxlarge-fluid',
						'role'    => 'title',
						'std'     => __( ST_Pb_Utils_Placeholder::add_placeholder( 'List Item %s', 'index' ), ST_PBL ),
			),
			array(
						'name'    => __( 'Body', ST_PBL ),
						'id'      => 'body',
						'role'    => 'content',
						'type'    => 'tiny_mce',
						//'container_class' => 'tiny_mce',
						'std'     => ST_Pb_Helper_Type::lorem_text(),
			),
			array(
						'name'      => __( 'Icon', ST_PBL ),
						'id'        => 'icon',
						'type'      => 'icons',
						'std'       => 'fa fa-star-o',
						'role'      => 'title_prepend',
						'title_prepend_type' => 'icon',
			),
			)
			);
		}

		/**
		 * DEFINE shortcode content
		 *
		 * @param type $atts
		 * @param type $content
		 */
		public function element_shortcode_full( $atts = null, $content = null ) 
		{
			// add params coming from parent to defaults
			$this->config['params']['show_icon'] = '';
			$this->config['params']['icon_position'] = '';
			$this->config['params']['icon_size'] = '';
			$this->config['params']['icon_color'] = '';
			$this->config['params']['icon_style'] = '';
			$this->config['params']['icon_bg'] = '';
			$this->config['params']['show_heading'] = '';

			$atts = shortcode_atts( $this->config['params'], $atts );
			extract( $atts );
			
			ST_Pb_Helper_Functions::heading_icon( $heading, $icon, true );
			
			//echo '<pre>'.print_r($atts, TRUE).'</pre>';
			$style = '';
			
			
			$atts['icon_icon'] = $icon;
			$icon = ST_Pb_Helper_Premade::icon('icon', $atts);
			
			$output = '<li>';
			
			if($show_icon == 'yes') 
			{
				$output .= '<div class="cbb-list-icon">'.$icon.'</div>';
				
				$padding = $icon_size;
				if($icon_style == 'circle' OR $icon_style == 'square')
					$padding += $icon_size * 1.2;
					
				$padding += 10;
				
				if(is_rtl())
				{
					if($icon_position == 'right') $style .= 'padding-left: '.$padding.'px';
					if($icon_position == 'left') $style .= 'padding-right: '.$padding.'px';
				}
				else
				{
					if($icon_position == 'right') $style .= 'padding-right: '.$padding.'px';
					if($icon_position == 'left') $style .= 'padding-left: '.$padding.'px';
				}
			}
			
			
			$output .= '<div style="'.$style.'" class="cbb-list-content-wrap">';
			
			if($heading && $show_heading == 'yes') $output .= '<h4>'.$heading.'</h4>';
			
			if($content) 
			{
				$output .= chiedolabs_shortcode_autop( $content );
				//$output .= '<p>'.$content.'</p>';
			}
			
			$output .= '</div></li>';
			
			
			return $output;
		}

	}

}
