<?php


if ( ! class_exists( 'ST_List' ) ) :

/**
 * Create List of items element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_List extends ST_Pb_Shortcode_Parent {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']        = strtolower( __CLASS__ );
		$this->config['name']             = __( 'List', ST_PBL );
		$this->config['cat']              = __( 'Content', ST_PBL );
		$this->config['icon']             = 'cbi-List';
		$this->config['has_subshortcode'] = 'ST_Item_' . str_replace( 'ST_', '', __CLASS__ );
		$this->config['description']      = __( 'Creates bullet point list', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'admin_assets' => array(
				'st-pb-joomlashine-iconselector-js',
			),
			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
				// Shortcode style
				'list_frontend.css',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'action' => array(
				array(
					'id'      => 'btn_convert',
					'type'    => 'button_group',
					'bound'   => 0,
					'actions' => array(
						array(
							'std'         => __( 'Tab', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'list_to_tab',
						),
						array(
							'std'         => __( 'Accordion', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'list_to_accordion',
						),
						array(
							'std'         => __( 'Carousel', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'list_to_carousel',
						),
					)
				),
			),
			'content' => array(
				array(
					'id'            => 'list_items',
					'type'          => 'group',
					'shortcode'     => ucfirst( __CLASS__ ),
					'sub_item_type' => $this->config['has_subshortcode'],
					'sub_items'     => array(
						array( 'std' => '' ),
						array( 'std' => '' ),
					),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'       => __( 'Show Icon', ST_PBL ),
					'id'         => 'show_icon',
					'type'       => 'radio',
					'std'        => 'yes',
					'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'has_depend' => '1',
				),
				array(
					'name'       => __( 'Layout', ST_PBL ),
					'id'         => 'icon_position',
					'type'       => 'select',
					'class'      => 'input-sm',
					'std'        => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_icon_position() ),
					'options'    => ST_Pb_Helper_Type::get_icon_position(),
					'dependency' => array( 'show_icon', '=', 'yes' )
				),

				array(
					'name'    => __( 'Size of icon (px)', ST_PBL ),
					'id'           => 'icon_size',
					'type'         => 'text_append',
					'type_input'   => 'number',
					'class'        => 'input-mini',
					'std'          => '32',
					'append'       => 'px',
					'validate'     => 'number',
				),
				
				array(
					'name'    => __( 'Icon color', ST_PBL ),
					'id'       => 'icon_color',
					'type'     => 'color_picker',
					'std'      => '#000000',
				),		
				
				array(
					'name'    => __( 'Icon Style', ST_PBL ),
					'id'      => 'icon_style',
					'type'    => 'select',
					'std'     => 'simple',
					'options' => array(
						"simple"=>"Simple",
						"circle"=>"Circle Background",
						"square"=>"Square Background",
					),
					'has_depend' => '1',
				),	
				
				array(
					'name'    => __( 'Icon background color', ST_PBL ),
					'id'       => 'icon_bg',
					'type'     => 'color_picker',
					'std'      => '#fff',
					'tooltip' => __( 'Background color for icon.', ST_PBL ),
					'dependency' => array( 'icon_style', '!=', 'simple' )
				),



				array(
					'name'       => __( 'Show Heading', ST_PBL ),
					'id'         => 'show_heading',
					'type'       => 'radio',
					'std'        => 'yes',
					'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
				),
				
				array(
					'name'    => __( 'Text color', ST_PBL ),
					'id'       => 'text_color',
					'type'     => 'color_picker',
					'std'      => '',
				),

				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		$arr_params = ( shortcode_atts( $this->config['params'], $atts ) );
		extract($arr_params);
		
		$id = 'cbb-list-'.rand(1,999);
		$style = '';

		$params_to_send = array(
			'show_icon',
			'icon_position',
			'icon_size',
			'icon_color',
			'icon_style',
			'icon_bg',
			'show_heading',
		);
		
		$params_string = ST_Pb_Helper_Functions::make_shortcode_params($params_to_send, $arr_params);
		
		$content = str_replace('[st_item_list', '[st_item_list '.$params_string, $content);
		
		//echo '<pre>'.print_r($content, TRUE).'</pre>';
		if($text_color)
		{
			$style .= 'color: '.$text_color;
		}

		
		$items = do_shortcode($content);
		
		$output = '<div class="cbb-list-instance">';
			
			$output .= '<ul style="'.$style.'" id="'.$id.'" class="cbb-list cbb-list-layout-'.$icon_position.'">';
			
				$output .= $items;
				
			$output .= '</ul>';
		
		$output .= '</div>';
			
		
		

			
		
		$html_elements = $output;

		return $this->element_wrapper( $html_elements, $arr_params );
	}
}

endif;
