<?php

if ( ! class_exists( 'ST_Logo' ) ) :

/**
 * Create Image element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Logo extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Logo', ST_PBL );
		$this->config['cat']         = __( 'Media', ST_PBL );
		$this->config['icon']        = 'cbi-Image';
		$this->config['description'] = __( 'Embed your main logo', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(

		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(

			'styling' => array(
				array(
							'type' => 'preview',
				),

				array(
							'name'    => __( 'Alignment', ST_PBL ),
							'id'      => 'image_alignment',
							'class'   => 'input-sm',
							'type'    => 'radio_button_group',
							'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_text_align() ),
							'options' => ST_Pb_Helper_Type::get_text_align(),
				),
				array(
							'name'            => __( 'Margin', ST_PBL ),
							'container_class' => 'combo-group',
							'id'              => 'image_margin',
							'type'            => 'margin',
							'extended_ids'    => array( 'image_margin_top', 'image_margin_right', 'image_margin_bottom', 'image_margin_left' ),
								'image_margin_top'    => array( 'std' => '' ),
								'image_margin_bottom' => array( 'std' => '' ),
								'tooltip'             => __( 'External spacing with other elements', ST_PBL )
				),				
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),

			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params     = shortcode_atts( $this->config['params'], $atts );
		extract( $arr_params );
		$html_elemments = '';

		if ( isset( $arr_params['image_margin_top'] ) )
			$arr_params['div_margin_top']    = $arr_params['image_margin_top'];
		if ( isset( $arr_params['image_margin_bottom'] ) )
			$arr_params['div_margin_bottom'] = $arr_params['image_margin_bottom'];
		if ( isset( $arr_params['image_margin_right'] ) )
			$arr_params['div_margin_right']  = $arr_params['image_margin_right'];
		if ( isset( $arr_params['image_margin_left'] ) )
			$arr_params['div_margin_left']   = $arr_params['image_margin_left'];	
			

		if ( strtolower( $image_alignment ) != 'inherit' ) {
			if ( strtolower( $image_alignment ) == 'left' )
			$cls_alignment = 'pull-left';
			if ( strtolower( $image_alignment ) == 'right' )
			$cls_alignment = 'pull-right';
			if ( strtolower( $image_alignment ) == 'center' )
			$cls_alignment = 'text-center';
		}
		
		global $cbt_options;
		
		if(! isset($cbt_options['logo']) OR ! isset($cbt_options['logo']['url']) OR ! $cbt_options['logo']['url'])
			$img = 'no logo defined';
		else
			$img = '<img src="'.$cbt_options['logo']['url'].'" />';
		
		
		$html_elemments = '<a class="logo '.$cls_alignment.'" style="display: block;" href="'.get_bloginfo( 'url' ).'/" title="'.get_bloginfo( 'name' ).'" rel="homepage">
							'.$img.'
						</a>';

		return $this->element_wrapper( $html_elemments, $arr_params );
	}
}

endif;
