<?php



/**
 * @todo : Define information of Buil-in Shortcodes of ProStyler Builder
 */

add_action( 'st_pb_addon', 'st_pb_builtin_sc_init' );

function st_pb_builtin_sc_init() {

	/**
	 * Main class to init Shortcodes
	 * for ProStyler Builder
	 *
	 * @package  ProStyler Builder Shortcodes
	 * @since    1.0.0
	 */
	class ST_Pb_Builtin_Shortcode extends ST_Pb_Addon {

		public function __construct() {

			// Addon information
			$this->set_provider(
			array(
					'name'             => __( 'Standard Elements', ST_PBL ),
					'file'             => __FILE__,
					'shortcode_dir'    => dirname( __FILE__ ),
					'js_shortcode_dir' => 'assets/js/shortcodes',
			)
			);

			//$this->custom_assets();
			// call parent construct
			parent::__construct();

			add_filter( 'plugin_action_links', array( &$this, 'plugin_action_links' ), 10, 2 );
		}

		/**
		 * Regiter & enqueue custom assets
		 */
		public function custom_assets() {
			// register custom assets
			$this->set_assets_register(
			array(
					'st-frontend-free-css' => array(
						'src' => plugins_url( 'assets/css/main.css', dirname( __FILE__ ) ),
						'ver' => '1.0.0',
			),
					'st-frontend-free-js'  => array(
						'src' => plugins_url( 'assets/js/main.js', dirname( __FILE__ ) ),
						'ver' => '1.0.0',
			)
			)
			);
			// enqueue assets for WP Admin pages
			$this->set_assets_enqueue_admin( array( 'st-frontend-free-css' ) );
			// enqueue assets for WR Modal setting iframe
			$this->set_assets_enqueue_modal( array( 'st-frontend-free-js' ) );
			// enqueue assets for WP Frontend
			$this->set_assets_enqueue_frontend( array( 'st-frontend-free-css', 'st-frontend-free-js' ) );
		}

		/**
		 * Remove deactivate link
		 *
		 * @staticvar type $this_plugin
		 *
		 * @param type $links
		 * @param type $file
		 *
		 * @return type
		 */
		public function plugin_action_links( $links, $file ) {
			static $this_plugin;

			if ( ! $this_plugin ) {
				$this_plugin = plugin_basename( __FILE__ );
			}
			if ( $file == $this_plugin ) {
				unset ( $links['deactivate'] );
			}

			return $links;
		}

	}

	$this_ = new ST_Pb_Builtin_Shortcode();
}