<?php
if (!class_exists('ST_Navigation')):

/**
 * Create element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
	class ST_Navigation extends ST_Pb_Shortcode_Element {
		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * Configure shortcode.
		 *
		 * @return  void
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower(__CLASS__);
			$this->config['name'] = __('Navigation', ST_PBL);
			$this->config['cat'] = __('Interactive Elements', ST_PBL);
			$this->config['icon'] = 'cbi-Navigation';
			$this->config['description'] = __('Create and assign navigation menu', ST_PBL);

			// Define exception for this shortcode
			$this->config['exception'] = array(
				'admin_assets' => array(
					// Shortcode initialization
					'navigation.js',
				),
				'frontend_assets' => array(
					// Shortcode style
					'navigation_frontend.css',
					//'navigation_frontend.js',
				),
			);

			// Use Ajax to speed up element settings modal loading speed
			$this->config['edit_using_ajax'] = true;
		}

		/**
		 * Define shortcode settings.
		 *
		 * @return  void
		 */
		public function element_items() {

			$menus = CBB_Init::menu_locations_select('', 'array');

			$this->items['content'] = array(

				array(
					'name' => __('Select navigation menu theme location', ST_PBL),
					'id' => 'menu_location',
					'type' => 'select',
					'std' => '',
					'options' => $menus,
					'tooltip' => __('Either choose from these locations or make your own and assign menu to it.', ST_PBL),
					'after_field' => '<p>After this, you will have to assign a menu or create a new menu for the location above by going to <a onclick="return true;" target="_blank" href="' . admin_url('nav-menus.php') . '">Appearance > Menus</a> (open in new window)</p>',
					'has_depend' => 1,
				),

				array(
					'name' => __('New menu location name', ST_PBL),
					'id' => 'cbb-new-menu-name',
					'type' => 'text_field',
					'std' => '',
					'dependency' => array('menu_location', '=', 'cbb-new-menu'),
					'after_field' => '<br /><p><button id="cbb-new-menu-btn" class="button-primary">Create location</button></p>',
				),

			);

			if ( class_exists( 'WooCommerce' ) )
			{
				$this->items['content'] = array_merge(
					$this->items['content'],
					array(
						array(
						'name' => __('WooCommerce Cart', ST_PBL),
						'id' => 'woo_cart',
						'type' => 'radio',
						'std' => 'no',
						'options' => array('yes' => __('Show', ST_PBL), 'no' => __('Hide', ST_PBL)),
						)
					)
				);
			}

			$this->items['styling'] = array(

				array(
					'type' => 'preview',
				),

				array(
					'name' => __('Style', ST_PBL),
					'id' => 'style',
					'type' => 'select',
					'std' => 'left',
					'options' => array(
						"left" => "Left menu items",
						"justified" => "Justified menu items",
						"right" => "Right menu items",
						"vertical" => "Vertical menu",
					),
					'has_depend' => '1',
				),

				array(
					'name' => __('Size', ST_PBL),
					'id' => 'size',
					'type' => 'select',
					'std' => 'container',
					'options' => array(
						"full" => "Full width background",
						"fluid" => "Fluid (stretch to sides)",
						"container" => "Container Width",
					),
					'dependency' => array('style', '!=', 'vertical'),
				),

				array(
					'name' => __('Background color', ST_PBL),
					'id' => 'bg_color',
					'type' => 'color_picker',
					'std' => '#00304c',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.navbar-default', 'background-color', array('opacity_from' => 'bg_opacity')),
						array('.navbar-default .nav > li .dropdown-menu', 'background-color', array('opacity_from' => 'bg_dropdown_opacity')),
						array('.navbar-default .nav > li > .dropdown-menu > li > .divider', 'background-color'),
					),
				),

				array(
					'name' => __('Background opacity', ST_PBL),
					'id' => 'bg_opacity',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_min' => '0',
					'std_max' => '100',
					'std' => '100',
					'css' => array(''),
				),

				array(
					'name' => __('Rounded corners', ST_PBL),
					'id' => 'border_radius',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_max' => '20',
					'std' => '0',
					'append' => 'px',
					'validate' => 'number',
					'css' => array(
						array('.navbar-default', 'border-radius'),
						array('.navbar-toggle', 'border-radius'),
						array('.dropdown-menu', 'border-radius'),
						array('.nav > li:first-child > a.cbt-nav-link', 'border-top-left-radius'),
						array('.nav > li:first-child > a.cbt-nav-link', 'border-top-right-radius'),
						array('.nav > li:last-child > a.cbt-nav-link', 'border-bottom-left-radius'),
						array('.nav > li:last-child > a.cbt-nav-link', 'border-bottom-right-radius'),
					),
				),

				array(
					'type' => 'skip_to_next_section',
				),

				array(
					'name' => __('Font', ST_PBL),
					'id' => 'font',
					'type' => 'radio',
					'std' => 'inherit',
					'options' => array('inherit' => __('Inherit', ST_PBL), 'custom' => __('Custom', ST_PBL)),
					'has_depend' => '1',
					//'class'      => 'input-sm',
				),
				array(
					'name' => __('Font size', ST_PBL),
					'id' => 'normal_font_size',
					'type' => 'text_append',
					'type_input' => 'number',
					'class' => 'input-mini',
					'std' => '16.5',
					'append' => 'px',
					'validate' => 'number',
					'dependency' => array('font', '=', 'inherit'),
				),

				array(
					'name' => __('Font Face', ST_PBL),
					'id' => 'font_family',
					'type' => array(
						array(
							'id' => 'font_face_type',
							'type' => 'jsn_select_font_type',
							'class' => 'input-sm',
							'std' => 'standard fonts',
							'options' => ST_Pb_Helper_Type::get_fonts(),
							'parent_class' => 'combo-item',
						),
						array(
							'id' => 'font_face_value',
							'type' => 'jsn_select_font_value',
							'class' => 'input-sm',
							'std' => 'Verdana',
							'options' => '',
							'parent_class' => 'combo-item',
						),
					),
					'dependency' => array('font', '=', 'custom'),
					'container_class' => 'combo-group',
				),
				array(
					'name' => __('Font Attributes', ST_PBL),
					'type' => array(
						array(
							'id' => 'font_size_value_',
							'type' => 'text_append',
							'type_input' => 'number',
							'class' => 'input-mini',
							'std' => '16.5',
							'append' => 'px',
							'validate' => 'number',
							'parent_class' => 'combo-item input-append-inline',
						),
						array(
							'id' => 'font_style',
							'type' => 'select',
							'class' => 'input-sm wr-mini-input',
							'std' => 'bold',
							'options' => ST_Pb_Helper_Type::get_font_styles(),
							'parent_class' => 'combo-item',
						),
					),
					'dependency' => array('font', '=', 'custom'),
					'container_class' => 'combo-group',
				),

				array(
					'name' => __('Stick navigation to the top when scrolling up?', ST_PBL),
					'id' => 'sticky',
					'type' => 'radio',
					'std' => 'no',
					'options' => array('yes' => __('Yes', ST_PBL), 'no' => __('No', ST_PBL)),
					'has_depend' => 1,
				),

				array(
					'name' => __('Sticky spacing from top', ST_PBL),
					'id' => 'sticky_topspacing',
					'type' => 'text_append',
					'type_input' => 'number',
					'class' => 'input-mini',
					'std' => '0',
					'append' => 'px',
					'validate' => 'number',
					'dependency' => array('sticky', '=', 'yes'),
					'tooltip' => __('Useful when you have multiple sticky navigations to stack them', ST_PBL),
				),

				array(
					'name' => __('Menu item', ST_PBL),
					'type' => 'group_open',
				),

				array(
					'name' => __('Text color', ST_PBL),
					'id' => 'text_color',
					'type' => 'color_picker',
					'std' => '#fff',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.navbar-default .navbar-brand', 'color'),
						array('.navbar-default .navbar-text', 'color'),
						array('.navbar-default .nav > li > a', 'color'),
						array('.navbar-default a#festi-cart.festi-cart.festi-cart-customize', 'color'),
						array('.navbar-default .nav > li .dropdown-menu > li > a', 'color'),
						array('.navbar-default .navbar-toggle .icon-bar', 'background-color'),
						array('.navbar-default .st-woo-cart-mobile a.cart-contents', 'color'),
						array('.navbar-default .navbar-link', 'color'),
					),
				),

				array(
					'name' => __('Selected Item Text color', ST_PBL),
					'id' => 'text_active_color',
					'type' => 'color_picker',
					'std' => '#00304c',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.navbar-default .nav > li > a:hover', 'color'),
						array('.navbar-default .nav > li > a:focus', 'color'),

						array('.navbar-default .nav > li .dropdown-menu > li > a:hover', 'color'),
						array('.navbar-default .nav > li .dropdown-menu > li > a:focus', 'color'),

						array('.navbar-default .nav > .active > a', 'color'),
						array('.navbar-default .nav > .active > a:hover,', 'color'),
						array('.navbar-default .nav > .active > a:focus', 'color'),

						array('.navbar-default .nav > .open > a', 'color'),
						array('.navbar-default .nav > .open > a:hover', 'color'),
						array('.navbar-default .nav > .open > a:focus', 'color'),

						array('.navbar-default .navbar-link:hover', 'color'),
					),
				),

				array(
					'name' => __('Selected Item background color', ST_PBL),
					'id' => 'bg_active_color',
					'type' => 'color_picker',
					'std' => '#FF8A00',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.navbar-default .nav > li > a:hover', 'background-color'),
						array('.navbar-default .nav > li > a:focus', 'background-color'),

						array('.navbar-default .nav > li .dropdown-menu > li > a:hover', 'background-color'),
						array('.navbar-default .nav > li .dropdown-menu > li > a:focus', 'background-color'),

						array('.navbar-default .nav > .active > a', 'background-color'),
						array('.navbar-default .nav > .active > a:hover,', 'background-color'),
						array('.navbar-default .nav > .active > a:focus', 'background-color'),

						array('.navbar-default .nav > .open > a', 'background-color'),
						array('.navbar-default .nav > .open > a:hover', 'background-color'),
						array('.navbar-default .nav > .open > a:focus', 'background-color'),

						array('.navbar-default .navbar-toggle:hover', 'background-color'),
						array('.navbar-default .navbar-toggle:focus', 'background-color'),
					),
				),

				array(
					'name' => __('Item height', ST_PBL),
					'id' => 'item_height',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_max' => '100',
					'std' => '15',
					'append' => 'px',
					'validate' => 'number',
					'css' => array(
						array('.navbar-default .nav > li > a', 'padding-top', '%value%'),
						array('.navbar-default .nav > li > a', 'padding-bottom', '%value%'),
					),
				),

				array(
					'type' => 'group_close',
				),

				array(
					'name' => __('Dropdown menu', ST_PBL),
					'type' => 'group_open',
				),

				array(
					'name' => __('Text color', ST_PBL),
					'id' => 'dropdown_text_color',
					'type' => 'color_picker',
					'std' => '#00304c',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.navbar-default .nav > li .dropdown-menu > li > a', 'color'),
					),
				),

				array(
					'name' => __('Background color', ST_PBL),
					'id' => 'bg_dropdown_color',
					'type' => 'color_picker',
					'std' => '#f9f9f9',
					'tooltip' => __('', ST_PBL),
					'css' => array(
						array('.navbar-default .nav > li .dropdown-menu', 'background-color', array('opacity_from' => 'bg_dropdown_opacity')),
					),
				),

				array(
					'name' => __('Background opacity', ST_PBL),
					'id' => 'bg_dropdown_opacity',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_min' => '0',
					'std_max' => '100',
					'std' => '100',
					'css' => array(''),
				),

				array(
					'name' => __('Rounded corners', ST_PBL),
					'id' => 'dropdown_border_radius',
					'type' => 'slider',
					'class' => 'st-slider',
					'std_max' => '20',
					'std' => '0',
					'append' => 'px',
					'validate' => 'number',
					'css' => array(
						array('.dropdown-menu', 'border-radius'),
					),
				),

				// array(
				// 	'name' => __( 'Item height', ST_PBL ),
				// 	'id'           => 'dropdown_item_height',
				// 	'type'     => 'slider',
				// 	'class'        => 'st-slider',
				// 	'std_max'      => '50',
				// 	'std'          => '8',
				// 	'append'       => 'px',
				// 	'validate'     => 'number',
				// 	'css' => array(
				// 		array('.navbar .dropdown .dropdown-menu li a', 'padding-top', '%value% !important'),
				// 		array('.navbar .dropdown .dropdown-menu li a', 'padding-bottom', '%value% !important'),
				// 	),
				// ),

				array(
					'type' => 'group_close',
				),

				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			);
		}

		/**
		 * Generate HTML code from shortcode content.
		 *
		 * @param   array   $atts     Shortcode attributes.
		 * @param   string  $content  Current content.
		 *
		 * @return  string
		 */
		public function element_shortcode_full($atts = null, $content = null) {
			static $nav_i;
			$nav_i++;

			// do not remove, used in element_wrapper
			$arr_params = (shortcode_atts($this->config['params'], $atts));

			//echo '<pre>'.print_r($arr_params, TRUE).'</pre>';

			$script = $output = $title = $alias = $el_class = '';
			extract($atts);

			$html_element = '';


			$nav_style = array();
			$exclude_params = array('tag', 'text', 'preview');
			$stylesheet = $font_style = '';

			if ($arr_params['font'] == 'inherit') {
				unset($arr_params['font']);
				unset($arr_params['font_face_type']);
				unset($arr_params['font_face_value']);
				unset($arr_params['font_size_value_']);
				unset($arr_params['font_style']);
				//unset( $arr_params['color'] );

				if ($arr_params['normal_font_size']) {
					$arr_params['font_size_value_'] = $arr_params['normal_font_size'];
				}

			}

			if (isset($arr_params['font']) && $arr_params['font'] == 'custom') {
				unset($arr_params['font']);
				if (isset($arr_params['font_style']) && strtolower($arr_params['font_style']) == 'bold') {
					$arr_params['font_weight'] = '700';
					unset($arr_params['font_style']);
				}
				if (isset($arr_params['font_style']) && strtolower($arr_params['font_style']) == 'normal') {
					$arr_params['font_weight'] = 'normal';
					unset($arr_params['font_style']);
				}
			}

			if (isset($arr_params['font_size_value_']) && $arr_params['font_size_value_'] == '') {
				unset($arr_params['font_size_value_']);
			}

			//echo '<pre>'.print_r($arr_params, TRUE).'</pre>';

			foreach ($arr_params as $key => $value) {
				if ($value != '') {
					if ($key == 'font_face_type') {
						if ($value == __('Standard fonts', ST_PBL) || $value == 'standard fonts') {
							$font_style = 'font-family:' . $arr_params['font_face_value'];
						} elseif ($value == __('Google fonts', ST_PBL) || $value == 'google fonts') {
						$script = ST_Pb_Helper_Functions::add_google_font_link_tag($arr_params['font_face_value']);
						$font_style = 'font-family:' . $arr_params['font_face_value'];
					}
				} elseif ($key != 'font_face_value') {
					$key = ST_Pb_Helper_Functions::remove_tag($key);
					if (!in_array($key, $exclude_params)) {
						switch ($key) {
						case 'font_size_value_':
							$nav_style[$key] = 'font-size:' . $value . 'px';
							break;

						case 'font_style':
							$nav_style[$key] = 'font-style:' . $value;
							break;

						case 'font_weight':
							$nav_style[$key] = 'font-weight:' . $value;
							break;
						}
					}
				}
			}
		}

		//echo '<pre>'.print_r($style, TRUE).'</pre>';

		// Finalize style
		$nav_style = implode(';', $nav_style) . ';' . $font_style;

		if ($nav_style == ';') {
			$nav_style = '';
		}

		if ($sticky == 'yes') {
			if (!$sticky_topspacing OR !is_numeric($sticky_topspacing)) {
				$sticky_topspacing = 0;
			}

			$script .= "<script type='text/javascript'>
			(function ($){
				$( document ).ready(function(){

					var sticky_topspacing = $sticky_topspacing;
					if($('body').hasClass('admin-bar')) sticky_topspacing += 32;

					$('#{$elm_id}-nav').sticky({topSpacing:sticky_topspacing});
					$('#{$elm_id}-nav').sticky({
						topSpacing:sticky_topspacing

						" . (($size != 'container') ? ", getWidthFrom:'#full-wrapper'" : "") . "
					});

					$('#{$elm_id}-nav').on('sticky-end', function() {
						$(this).removeClass('stop-sticky');
						$(window).trigger('resize');
					});

				});
			} )( jQuery );
			</script>";
		}

		$nav_class = 'cbb-full-width';
		$container_class = 'row';

		if ($style == 'vertical') {
			$nav_class = 'cbb-nav-vertical';
			$wp_nav_menu_class = 'nav';
		} else {
			if ($size == 'container') {
				$nav_class = 'cbb-nav-size-container';
			} elseif ($size == 'full') {
				$container_class = 'container';
			}

			$wp_nav_menu_class = 'nav navbar-nav';
			if ($style == 'justified') {
				$wp_nav_menu_class = 'nav nav-pills nav-justified';
			} elseif ($style == 'right') {
				$wp_nav_menu_class = 'nav navbar-nav navbar-right';
				if ($size == 'container') {
					$container_class = '';
				}

			}
		}

		// set flag for woocommerce header cart - reset at the end
		cbt_woocommerce::$pb_nav = true;
		// hide if woocommerce not active
		if(! isset($arr_params['woo_cart'])) $arr_params['woo_cart'] = 'no';
		// disable header cart - reset at the end
		if($arr_params['woo_cart'] != 'yes')
		{
			cbt_woocommerce::$show_header_cart = false;
		}

		$menu_args = array(
			'container' => false, // remove nav container
			'container_class' => 'menu clearfix', // class of container (should you choose to use it)
			'menu' => '', // nav name
			'menu_class' => $wp_nav_menu_class, // adding custom nav class
			'theme_location' => $menu_location, // where it's located in the theme
			'before' => '', // before the menu
			'after' => '', // after the menu
			'link_before' => '', // before each link
			'link_after' => '', // after each link
			'depth' => 12,
			'echo' => false, // limit the depth of the nav
		);

		if (class_exists('wp_bootstrap_navwalker')) {
			$menu_args['fallback_cb'] = 'wp_bootstrap_navwalker::fallback_no_echo';
			$menu_args['walker'] = new wp_bootstrap_navwalker();
		}

		//echo '<pre>'.print_r($menu_args, TRUE).'</pre>';

		$output = '

<div class="cbb-nav" id="' . $elm_id . '" style="' . $nav_style . '">
<nav id="' . $elm_id . '-nav" class="' . $nav_class . ' navbar navbar-default">
  <div class="' . $container_class . '">
    <!-- Brand and toggle get grouped for better mobile display -->
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#' . $elm_id . '-nav-collapse">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>

      '.apply_filters( 'st_woo_cart_mobile', '' ).'
    </div>

    <!-- Collect the nav links, forms, and other content for toggling -->
    <div class="collapse navbar-collapse ' . $elm_id . '-nav-collapse" id="' . $elm_id . '-nav-collapse">
		<a href="#" class="navbar-toggle" data-target="#' . $elm_id . '-nav-collapse"><i class="fa fa-times-circle-o"></i></a>
	' .
		wp_nav_menu($menu_args)
			. '

    </div><!-- /.navbar-collapse -->
  </div><!-- /.container-fluid -->
</nav>
</div>
';

		$html_element = $output;

		// reset to default
		cbt_woocommerce::$pb_nav = false;
		cbt_woocommerce::$show_header_cart = true;

		return $this->element_wrapper($script . $html_element, $arr_params);
	}

}

endif;
