<?php
// ------------------------------------------------------
//  YUNUS NOTICE: This element is excluded from wp autop, check stencilor/init.php
// ------------------------------------------------------

if ( ! class_exists( 'ST_Newsletter' ) ) :

/**
 * Create Text element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Newsletter extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Newsletter code', ST_PBL );
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-CodeHtml';
		$this->config['description'] = __( 'Paste HTML or Javscript code', ST_PBL );



		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	function element_items() {
		$this->items = array(
			'content' => array(

				array(
					'name' => __( 'HTML / JavaScript code', ST_PBL ),
					'tooltip' => __( 'Paste in the code from your newsletter service provider e.g mailchimp, awber, getresponse etc', ST_PBL ),
					'id'   => 'html',
					'type' => 'text_Area',
					'role' => 'content',
					'std'  => '',
					'rows' => 15,
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params = shortcode_atts( $this->config['params'], $atts );
		extract( $arr_params );

		
		$html = $content;

		return $this->element_wrapper( $html, $arr_params );
	}
}

endif;
