<?php


if ( ! class_exists( 'ST_Nexforms' ) 
	&& is_plugin_active( 'nex-forms/main.php' ) ) :

/**
 * Create element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Nexforms extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'NEX-Form', ST_PBL );
		$this->config['cat']         = __( 'Wordpress Plugins', ST_PBL );
		$this->config['icon']        = 'cbi-Text';
		$this->config['description'] = __( 'Embed Forms from NEX-Forms plugin', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'NEX-Form', ST_PBL ),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		global $wpdb;
		
		$data	= $wpdb->prepare('SELECT * FROM '. $wpdb->prefix . 'wap_nex_forms WHERE is_template<>1 AND is_form<>"preview" AND is_form<>"draft" ORDER BY Id DESC ');
		$data	= $wpdb->get_results($data);
		
		$items = array();
		if ( $data ) {
			foreach ( $data as $item ) {
				$items[$item->Id] = $item->title;
			}
		} else {
			$items[0] = __( 'No Forms found', ST_PBL );
		}	
		
		$this->items = array(
			'content' => array(

				array(
					'name'    => __( 'Form', ST_PBL ),
					'id'      => 'id',
					'type'    => 'select',
					'std'     => '',
					'options' => $items,
				),	
				
				
				array(
					'name'    => __( 'Display', ST_PBL ),
					'id'      => 'open_trigger',
					'type'    => 'select',
					'std'     => '',
					'options' => array(
						'normal' => 'Normal',
						'popup' => 'Popup',
					),
				),	
				
				array(
					'name'    => __( 'Popup/Modal Trigger', ST_PBL ),
					'id'      => 'button_type',
					'type'    => 'select',
					'std'     => '',
					'options' => array(
						'button' => 'Button',
						'link' => 'Link',
					),
				),	
				

				array(
					'name'    => __( 'Button Color (bootstrap)', ST_PBL ),
					'id'      => 'button_color',
					'type'    => 'select',
					'std'     => '',
					'options' => array(
						'btn-primary' => 'Dark Blue',
						'btn-info' => 'Light Blue',
						'btn-warning' => 'Orange',
						'btn-success' => 'Green',
						'btn-danger' => 'Red',
						'btn-default' => 'Gray/White',
					),
				),	
				
				array(
					'name'    => __( 'Button/Link Text', ST_PBL ),
					'id'      => 'button_text',
					'type'    => 'text_field',
					'std'     => '',
				),

				
			),
			
			'styling' => array(	
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),				
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		if ( isset( $_GET['st_shortcode_preview'] ) )
		{
			return '<center>['.$this->config['name'].' element is not shown in the preview]</center>';
		}
		
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		
		extract( shortcode_atts( array(
		    'id' => '',
		    'open_trigger' => '',
		    'button_type' => '',
		    'button_color' => '',
		    'button_text' => '',
		    
		), $atts ) );
		
		$shortcode = '[NEXForms id="'.$id.'"';
		$shortcode .= ' open_trigger="'.$open_trigger.'"';
		$shortcode .= ' type="'.$button_type.'"';
		$shortcode .= ' text="'.$button_text.'"';
		$shortcode .= ' button_color="'.$button_color.'"';
		$shortcode .= ']';
		
		//$html_element = $shortcode;
		//echo '<pre>'.print_r($shortcode, TRUE).'</pre>';die();

		$html_element = do_shortcode($shortcode);

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
