<?php
/**
 * @version	$Id$
 * @package	ProStyler Builder
 */

if ( ! class_exists( 'ST_Page_Embed' ) ) :

/**
 * Create Page embed element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Page_Embed extends ST_Pb_Shortcode_Element {

	public $page_css;

	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Page Embed', 				ST_PBL );
		$this->config['cat']         = __( 'Extra', 		ST_PBL );
		$this->config['icon']        = 'cbi-PageEmbed';
		$this->config['description'] = __( 'Embed another page as element', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'Page Embed', ST_PBL ),
			'admin_assets' => array(
				// Shortcode initialization
				'page-embed.js',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		$this->items['content'] = array(

			array(
				'name'    => __( 'Select Page', ST_PBL ),
				'id'      => 'page',
				'type'    => 'select',
				'std'     => '',
				'role'=>'title',
				'options' => ST_Pb_Helper_Functions::pages_array(),
			),	
		
		);

			
		$this->items['styling'] = array(
			array(
				'type' => 'preview',
				'size' => 'full',
			),
			
			ST_Pb_Helper_Type::get_apprearing_animations(),
			ST_Pb_Helper_Type::get_animation_speeds(),				
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		$html_element = '';
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) );
		extract( $arr_params );
		
		$content = '';
		if(isset($page) && trim($page))
		{				
			$content = $this->get_page_content( $page );
			$content = $content['content'];
		}
		
		//echo '<pre>'.print_r($data['shortcode'], TRUE).'</pre>';die();
		
		// disable row count so shortcodes dont mess up the row numbering
		global $st_no_row_count;
		$st_no_row_count = true;
		
		$html_element = cbt_text_shortcodes_process(do_shortcode($content));
		
		// reactivate row count	
		$st_no_row_count = false;

		
		return $this->element_wrapper( $html_element, $arr_params );
	}
	




	function get_page_content($id)
	{
		$page = get_page_by_path($id,OBJECT,'page');
		
		if(! $page OR !isset($page->ID)) return false;

		// Get what tab (Classic - Pagebuilder) is active when Save content of this post
		$st_page_active_tab = get_post_meta( $page->ID, '_wr_page_active_tab', true );
		$st_deactivate_pb = get_post_meta( $page->ID, '_wr_deactivate_pb', true );

		$content = $page->post_content;
		$content = ST_Pb_Helper_Shortcode::get_builder_tab_content(
			$content, 
			$page, 
			$st_page_active_tab,
			$st_deactivate_pb
		);

		// if not deactivate pagebuilder on this post/page then add its css etc
		if ( empty( $st_deactivate_pb ) ) 
		{

			$custom_css_data = ST_Pb_Helper_Functions::custom_css_data( isset ( $page->ID ) ? $page->ID : NULL );
			extract( $custom_css_data );

			if($css_custom)
			{
				$css_custom = html_entity_decode( stripslashes( $css_custom ) );

				$this->page_css = $css_custom;
			}
		}

		if(! trim($content)) return false;


		return array(
			'content' => $content,
			'page_object' => $page,
		);
	}


	/**
	 * Used by CSS Helper to generate css for wp head
	 * @param  array $atts    element params
	 * @param  string $content element content
	 * @return void          
	 */
	public function css_helper_hook_echo_extra_css( $atts = null, $content = null )
	{
		$html_element = '';
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) );
		extract( $arr_params );
		
		$content = '';
		if(isset($arr_params['page']) && trim( $arr_params['page'] ))
		{				
			$result = $this->get_page_content( $arr_params['page'], false );
			$content = $result['content'];
			echo $this->page_css;

			ST_Pb_Utils_Css::$cached_embedded_pages[ $result['page_object']->ID ] = $result['page_object']->post_modified;
		}
		
		do_shortcode($content);
	}

}

endif;
