<?php
/**
 * @version	$Id$
 * @package	ProStyler Builder
 */

if ( ! class_exists( 'ST_Popup' ) ) :

/**
 * Create Popup element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Popup extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Popup', 				ST_PBL );
		$this->config['cat']         = __( 'Interactive Elements', 		ST_PBL );
		$this->config['icon']        = 'cbi-Popup';
		$this->config['description'] = __( 'Display popup dialog', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'admin_assets' => array(
				// Shortcode initialization
				'st-popover.js',
				'st-colorpicker.js',
				'st-linktype.js',
				'st-font-color.js'
			),
			
			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',

		// Shortcode style and script initialization
				'popup_frontend.css',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items['content'] = array(

				array(
					'name'     => __( 'Heading', ST_PBL ),
					'id'       => 'heading',
					'type'     => 'text_field',
					'std'      => 'Popup Dialog',
					'tooltip' => __( 'Title shown at the top of the dialog.', ST_PBL ),
				),
			
				array(
					'name'  => __( 'Popup Content', ST_PBL ),
					'id'    => 'popup_content',
						'type'  => 'tiny_mce',
					'role'  => 'content',
					'rows'  => '12',
					'std'   => ST_Pb_Helper_Type::lorem_text(12),
				),
				
				array(
					'name'    => __( 'Open when', ST_PBL ),
					'id'      => 'open_action',
					'type'    => 'select',
					'class'   => 'input-sm',
					'std'     => 'auto',
					'options' => array(
						'auto' => __( 'Automatically', ST_PBL ),
						'button' => __( 'A Button is clicked', ST_PBL ),
						'leaving' => __( 'Intents to leave the site', ST_PBL ),
					),
					'has_depend' => 1
				),
				
				array(
					'name'     => __( 'Open automatically after', ST_PBL ),
					'id'       => 'delay',
					'type'         => 'text_append',
					'type_input'   => 'number',
					'class'        => 'input-mini',
					'std'          => '1',
					'append'       => 'seconds',
					'validate'     => 'number',
					'dependency'  => array( 'open_action', '=', 'auto' ),
				),
			);
			
			$this->items['content'] = array_merge(
				$this->items['content'], 
				ST_Pb_Helper_Type::get_button_type('popup_button', __( 'If set to open with button, configure button here', ST_PBL ), array('open_in', 'link_type'))
			);
			
			$this->items['styling'] = array(
				array(
					'type' => 'preview',
				),
				
				array(
					'name'    => __( 'Animation effect', ST_PBL ),
					'id'      => 'animation_effect',
					'type'    => 'select',
					'class'   => 'input-sm',
					'std'     => '1',
					'options' => array(
						'1' => __( 'Fade in &amp; Scale', ST_PBL ),
						'2' => __( 'Slide in (right)', ST_PBL ),
						'3' => __( 'Slide in (bottom)', ST_PBL ),
						'4' => __( 'Newspaper', ST_PBL ),
						'5' => __( 'Fall', ST_PBL ),
						'6' => __( 'Side Fall', ST_PBL ),
						'7' => __( 'Sticky Up', ST_PBL ),
						'8' => __( '3D Flip (horizontal)', ST_PBL ),
						'9' => __( '3D Flip (vertical)', ST_PBL ),
						'10' => __( '3D Sign', ST_PBL ),
						'11' => __( 'Super Scaled', ST_PBL ),
						//'12' => __( 'Just Me', ST_PBL ),
						'13' => __( '3D Slit', ST_PBL ),
						'14' => __( '3D Rotate Bottom', ST_PBL ),
						'15' => __( '3D Rotate In Left', ST_PBL ),
					),
				),

				array(
					'name'    => __( 'Elements', ST_PBL ),
					'id'      => 'elements',
					'type'    => 'items_list',
					'std'     => 'title__#__content__#__button',
					'options' => array(
						'title'   => __( 'Heading', ST_PBL ),
						'content' => __( 'Content', ST_PBL ),
						'button'  => __( 'Close Button', ST_PBL )
					),
					'options_type'    => 'checkbox',
					'popover_items'   => array( 'title', 'button' ),
					'tooltip'         => __( 'Elements to display on promotion box', ST_PBL ),
					'style'           => array( 'height' => '200px' ),
					'container_class' => 'unsortable content-elements',
				),
				// Popup settings for Title
				array(
					'name'              => __( 'Font', ST_PBL ),
					'id'                => 'title_font',
					'type'              => 'select',
					'std'               => 'inherit',
					'options'           => array( 'inherit' => __( 'Inherit', ST_PBL ), 'custom' => __( 'Custom', ST_PBL ) ),
					'has_depend'        => '1',
					'class'             => 'input-medium',
					'tooltip'           => __( 'Select Font Type', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'title',
				),
				
				array(
					'name'    => __( 'Text color', ST_PBL ),
					'id'       => 'title_color',
					'type'     => 'color_picker',
					'in_popover' => true,
					'std'      => '#fff',
					'tooltip' => __( 'Color of heading text.', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'title',
				),
				
/*
				array(
					'name'    => __( 'Background color', ST_PBL ),
					'id'       => 'title_bg',
					'type'     => 'color_picker',
					'in_popover' => true,
					'std'      => '',
					'tooltip' => __( 'Color of heading background.', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'title',
				),
*/
			
				array(
					'name' => __( 'Font Face', ST_PBL ),
					'id'   => 'title_font_family',
					'type' => array(
						array(
							'id'           => 'title_font_face_type',
							'type'         => 'jsn_select_font_type',
							'class'        => 'input-medium input-sm',
							'std'          => 'standard fonts',
							'options'      => ST_Pb_Helper_Type::get_fonts(),
							'parent_class' => 'combo-item',
						),
						array(
							'id'           => 'title_font_face_value',
							'type'         => 'jsn_select_font_value',
							'class'        => 'input-medium input-sm',
							'std'          => 'Verdana',
							'options'      => '',
							'parent_class' => 'combo-item',
						),
					),
					'dependency'        => array( 'title_font', '=', 'custom' ),
					'tooltip'           => __( 'Select Font Face', ST_PBL ),
					'container_class'   => 'combo-group hidden',
					'data_wrap_related' => 'title',
				),

				
				array(
					'name'    => __( 'Button Type', ST_PBL ),
					'id'      => 'button_type',
					'type'    => 'select',
					'class'   => 'input-sm',
					'std'     => 'default',
					'options' => array(
						'default' => __( 'Bottom center button', ST_PBL ),
						'cross' => __( 'Top right cross', ST_PBL ),
					),
					'has_depend'        => '1',
					'container_class'   => 'hidden',
					'data_wrap_related' => 'button',
				),
				
				array(
					'name'     => __( 'Text', ST_PBL ),
					'id'       => 'btn_text',
					'type'     => 'text_field',
					'std'      => 'Close me',
					'container_class'   => 'hidden',
					'data_wrap_related' => 'button',
					'dependency'        => array( 'button_type', '=', 'default' ),
				),
				
				array(
					'name'    => __( 'Color', ST_PBL ),
					'id'       => 'btn_cross_color',
					'type'     => 'color_picker',
					'in_popover' => true,
					'std'      => '#fff',
					'tooltip' => __( 'Button color.', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'button',
					'dependency'        => array( 'button_type', '=', 'cross' ),
				),
				
				array(
					'name'    => __( 'Background color', ST_PBL ),
					'id'       => 'bg_color',
					'type'     => 'color_picker',
					'std'      => '#ff8a00',
					'tooltip' => __( 'Color of popup content background.', ST_PBL ),
				),
				
				array(
					'name'    => __( 'Overlay color', ST_PBL ),
					'id'       => 'overlay_color',
					'type'     => 'color_picker',
					'std'      => '#00304c',
					'tooltip' => __( 'Backdrop background color.', ST_PBL ),
				),
			
				//ST_Pb_Helper_Type::get_apprearing_animations(),
				//ST_Pb_Helper_Type::get_animation_speeds(),				
			);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		$html_element = $other_scripts = '';
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) );
		extract( $arr_params );
		
		
		// make id to be used everywhere
		$id = 'st_popup_modal_'.rand(0000,9999);
		
		$elements = explode( '__#__', $elements );
		
		// ------------------------------------------------------
		//  title / heading 
		// ------------------------------------------------------
		$title = '';
		if ( in_array( 'title', $elements ) && $heading ) 
		{
			$style_title = array();
			if ( $title_font == 'custom' ) 
			{
				if ( $title_font_face_type == 'google fonts' ) 
				{
					$other_scripts .= ST_Pb_Helper_Functions::add_google_font_link_tag( $title_font_face_value );
					$style_title[] = 'font-family:' . $title_font_face_value;
				} elseif ( $title_font_face_value ) 
				{
					$style_title[] = 'font-family:' . $title_font_face_value;
				}
				if ( intval( $title_font_size ) > 0 ) 
				{
					$style_title[] = 'font-size:' . intval( $title_font_size ) . 'px';
				}
				switch ( $title_font_style ) 
				{
					case 'bold':
						$style_title[] = 'font-weight:700';
						break;
					case 'italic':
						$style_title[] = 'font-style:italic';
						break;
					case 'normal':
						$style_title[] = 'font-weight:normal';
						break;
				}
				if ( strpos( $title_font_color, '#' ) !== false ) 
				{
					$style_title[] = 'color:' . $title_font_color;
				}
			}
			
			if($title_color) $style_title[] = 'color:' . $title_color;
			//if($title_bg) $style_title[] = 'background-color:' . $title_bg;

			if ( count( $style_title ) ) 
			{
				$style_title = 'style="' . implode( ';', $style_title ) . '"';
			} else
				$style_title = '';
				
			$title = "<h3 {$style_title} class=\"cb-popup-heading\">{$heading}</h3>";
		}
		
		
		// ------------------------------------------------------
		//  modal styling
		// ------------------------------------------------------
		$style_modal = array();
		
		if($bg_color) $style_modal[] = 'background-color:' . $bg_color;
		
		if ( count( $style_modal ) ) 
		{
			$style_modal = 'style="' . implode( ';', $style_modal ) . '"';
		} else
			$style_modal = '';
			

		// ------------------------------------------------------
		//  content
		// ------------------------------------------------------
		if ( in_array( 'content', $elements ) && ! empty( $content ) ) 
		{
			$content = chiedolabs_shortcode_autop( $content );
		}
		
		// ------------------------------------------------------
		//  close button
		// ------------------------------------------------------
		switch($button_type)
		{
			case 'cross':
				$btn_close = '<div><a style="color: '.$btn_cross_color.'" class="cb-popup-close"><i class="fa fa-times-circle"></i></a></div>';
			break;
			
			default:
				$btn_close = '<div><button class="cb-popup-close">'.$btn_text.'</button></div>';
			break;
		}
		
		
		// ------------------------------------------------------
		//  modal markup
		// ------------------------------------------------------
		$modal = '';
		$modal .= '<div class="cb-popup-modal cb-popup-hidefix cb-popup-effect-'.$animation_effect.'" id="'.$id.'">';
			$modal .= '<div '.$style_modal.' class="cb-popup-content">';
				
				if($title) $modal .= $title;
				$modal .= '<div>';
				
					if ( in_array( 'content', $elements ) ) $modal .= $content;

					if ( in_array( 'button', $elements ) ) $modal .= $btn_close;
					
				$modal .= '</div>';
					
			$modal .= '</div>';
		$modal .= '</div>';
		$modal .= '<div '.(($overlay_color)?'style="background-color: '.$overlay_color.'"':'').' id="'.$id.'_overlay" class="cb-popup-overlay"></div>';
		
		
		
		// ------------------------------------------------------
		//  Javascript for modal / per modal
		// ------------------------------------------------------
		
		// js opening
		$script = "
( function ($) { 
	'use strict';
	$( document ).ready( function () {";
	
		// remove line breaking from modal markup so javascript doesnt break
		$modal = json_encode($modal);
		// append modal markup to body
		$script .= '
			$("body").append('.$modal.');
		';

		
		// main functions
		$script .= "
				// fixes a glitch when modal is shown momentarily fading out itself when page loads completes
				$('#{$id}').removeClass('cb-popup-hidefix');
				
				function {$id}_show()
				{
					$('#{$id}').addClass('cb-popup-show');
					$('#{$id}_overlay').addClass('cb-popup-overlay-show');
					
					// disable page scroll
					$('body').width($('body').width());
					$('body').height($('body').height());
					$('body').css('overflow', 'hidden');
				}
				
				function {$id}_hide()
				{
					$('#{$id}').removeClass('cb-popup-show');
					$('#{$id}_overlay').removeClass('cb-popup-overlay-show');
					
					// re-enable page scroll
					$('body').css({
						'width':'auto',
						'height':'auto',
						'overflow':'auto'
					});
				}
				
				function {$id}_scroll_adjust()
				{
					$('#{$id} .cb-popup-content').css('max-height', $(window).height()-100 );
				}
				
				{$id}_scroll_adjust();
				$(window).resize( {$id}_scroll_adjust );
				
				// hide on clicking close button or ovarlay
				$('#{$id} .cb-popup-close, #{$id}_overlay').click(function ()
				{
					{$id}_hide();
				});
		";
	
		// js per open action type
		switch($open_action)
		{
			case 'auto':
				if(! $delay OR !is_numeric($delay) OR $delay < 1) $delay = 1;
				$seconds = $delay * 1000;
				
				$script .= "
					var {$id}_autoshow = setInterval(function()
					{
						{$id}_show();
						
						clearInterval({$id}_autoshow);
					}, {$seconds});
				";
			break;
			
			case 'leaving':
				$script .= "
					var {$id}_shown_already = false;
					$(document).bind('mouseleave', function(e)
					{
						if({$id}_shown_already) return;
						
						if (e.pageY - $(window).scrollTop() <= 1) 
						{
							{$id}_show();
							{$id}_shown_already = true;
						}
					});
				";
			break;
			
			case 'button':
			
				$btn_id = 'popup-button-'.rand(0000,9999);
			
				$script .= "
					$('#{$btn_id}').click(function ()
					{
						{$id}_show();
						
						return false;
					});
				";
				
				$html_element .= ST_Pb_Helper_Premade::button('popup_button', $atts, $btn_id);
			break;
		}
		
		
		// js closing
		$script .= "
	})
})( jQuery );";


		$html_element .= '<script type="text/javascript">'.$script.'</script>';
		$html_element .= $other_scripts;

		

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
