<?php


if ( ! class_exists( 'ST_PricingTable2' ) ) :

/**
 * Create button elements
 *
 * @package  ProStyler Builder Shortcodes
 */
class ST_PricingTable2 extends ST_Pb_Shortcode_Element {

	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Pricing table v2', ST_PBL );
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-pricingtable';
		$this->config['description'] = __( 'Creates a pricing package box', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'Pricing table v2', ST_PBL ),
			'data-modal-title' => __( 'Pricing table v2', ST_PBL ),

			'admin_assets' => array(
		// Shortcode initialization
				'st-linktype.js',
				'pricingtable2.js',
		),

			'frontend_assets' => array(
		// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',

				'cbb-prettyphoto-js',
				'cbb-prettyphoto-css',
		// Font IcoMoon
				'st-pb-font-icomoon-css',

		// Shortcode style
				'pricingtable2_frontend.css',
		),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		
		
		
		$this->items['content'] = array(
		
			array(
				'name'     => __( 'Package Name / Title', ST_PBL ),
				'id'       => 'package_heading',
				'type'     => 'text_field',
				'std'      => 'Free Plan',
				'tooltip' => __( 'Enter the package name or table heading', ST_PBL ),
			),
		
			array(
				'name'     => __( 'Sub Heading', ST_PBL ),
				'id'       => 'package_sub_heading',
				'type'     => 'text_field',
				'std'      => '',
				'tooltip' => __( 'Enter short description for this package', ST_PBL ),
			),
			
			array(
				'name'     => __( 'Package Price', ST_PBL ),
				'id'       => 'package_price',
				'type'     => 'text_field',
				'std'      => '£20',
				'tooltip' => __( 'Enter the price for this package. e.g. $157', ST_PBL ),
			),
			
			array(
				'name'     => __( 'Price Unit', ST_PBL ),
				'id'       => 'package_unit',
				'type'     => 'text_field',
				'std'      => 'per month',
				'tooltip' => __( 'Enter the price unit for this package. e.g. per month', ST_PBL ),
			),
			


		);
		
		$this->items['content'] = array_merge(
			$this->items['content'], 
			ST_Pb_Helper_Type::get_button_type('package_button')
		);
		
		$this->items['content'][] = array(
						'type'       => 'skip_to_next_section',
			);

		$this->items['content'][] = array(
				'name' => __( 'Features', ST_PBL ),
				'desc' => __( 'Create the features list using un-ordered list elements.', ST_PBL ),
				'id'   => 'text',
				'type' => 'tiny_mce',
				'role' => 'content',
				'std'  => $this->lorem_text(),
				'rows' => 15,
			);
			
		
		
		$this->items['styling'] = array(
			array(
				'type' => 'preview',
				//'size' => 'full',
			),
			
			array(
				'name'     => __( 'Featured package', ST_PBL ),
				'id'       => 'package_featured',
				'type'     => 'radio',
				'std'      => 'no',
				'options'  => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
				'tooltip' => __( 'Make the box slightly bigger', ST_PBL ),
			),
			
			array(
				'name'    => __( 'Header background', ST_PBL ),
				'id'       => 'header_color',
				'type'     => 'color_picker',
				'std'      => '#00304c',
				'tooltip' => __( '', ST_PBL ),
			),
			
			array(
				'name'    => __( 'Header Text color', ST_PBL ),
				'id'       => 'header_text_color',
				'type'     => 'color_picker',
				'std'      => '#fff',
				'tooltip' => __( '', ST_PBL ),
			),
			
			array(
				'name'    => __( 'Body background', ST_PBL ),
				'id'       => 'body_color',
				'type'     => 'color_picker',
				'std'      => '',
				'tooltip' => __( '', ST_PBL ),
			),
			
			array(
				'name'    => __( 'Body Border color', ST_PBL ),
				'id'       => 'body_border_color',
				'type'     => 'color_picker',
				'std'      => '#e3e3e3',
				'tooltip' => __( '', ST_PBL ),
			),
			
			array(
				'name'    => __( 'Body Text color', ST_PBL ),
				'id'       => 'body_text_color',
				'type'     => 'color_picker',
				'std'      => '',
				'tooltip' => __( '', ST_PBL ),
			),
			
			array(
				'name'    => __( 'Features Divider color', ST_PBL ),
				'id'       => 'features_divider_color',
				'type'     => 'color_picker',
				'std'      => '#e3e3e3',
				'tooltip' => __( '', ST_PBL ),
			),
			
			array(
				'name'     => __( 'Button location', ST_PBL ),
				'id'       => 'button_location',
				'type'     => 'radio',
				'std'      => 'top',
				'options'  => array( 'top' => __( 'Top', ST_PBL ), 'bottom' => __( 'Bottom', ST_PBL ), 'hide' => __( 'Hide', ST_PBL ) ),
				'tooltip' => __( '', ST_PBL ),
			),
			
			ST_Pb_Helper_Type::get_apprearing_animations(),
			ST_Pb_Helper_Type::get_animation_speeds(),
		);
	}
	
	
	function lorem_text()
	{
		return ' 	<ul>
 	<li>‌‌‌<span class="fa-envelope fa" style="font-family: FontAwesome;">‌</span>‌ ‌<b>1,000</b> messages</li>
 	<li>‌‌<span class="fa-signal fa" style="font-family: FontAwesome;">‌</span>‌ <b>Unlimited</b> data</li>
 	<li>‌‌<span class="fa-user fa" style="font-family: FontAwesome;">‌</span>‌ <b>Unlimited</b> users</li>
 	<li>‌‌<span class="fa-smile-o fa" style="font-family: FontAwesome;">‌</span>‌ First 10 day free</li>
</ul>';
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		extract( $arr_params );
		
		// make id to be used everywhere
		$id = 'st_pricing_table_'.rand(0000,9999);
		
		$html_element = $extra_class = '';
		
		if($package_featured=='yes') $extra_class .= ' cbb-pricing-featured';
		
		// ------------------------------------------------------
		//  CSS
		// ------------------------------------------------------
		$html_element .= '<style>';
		
		
		$html_element .= '#'.$id.' {';
			if($body_text_color) $html_element .= 'color:'.$body_text_color.';';
		$html_element .= '}';
		
		
		$html_element .= '#'.$id.' .cbb-pricing-header {';
			if($header_color) $html_element .= 'background-color:'.$header_color.';';
			if($header_text_color) $html_element .= 'color:'.$header_text_color.';';
		$html_element .= '}';
		
		
		$html_element .= '#'.$id.' .cbb-pricing-list {';
			if($body_color) $html_element .= 'background-color:'.$body_color.';';
			if($body_border_color) $html_element .= 'border-color:'.$body_border_color.';';
		$html_element .= '}';
		
		$html_element .= '#'.$id.' .cbb-pricing-list li {';
			if($features_divider_color) $html_element .= 'border-color:'.$features_divider_color.';';
		$html_element .= '}';
		
		
		$html_element .= '</style>';
		
		
		// ------------------------------------------------------
		//  HTML
		// ------------------------------------------------------
		$html_element .= '
                            <div id="'.$id.'" class="cbb-pricing-table '.$extra_class.'">
                                <div class="cbb-pricing-header">
                                    <p class="cbb-pricing-title">'.$package_heading.'</p>
	                                <p class="cbb-pricing-subheading">'.$package_sub_heading.'</p>
                                    <p class="cbb-pricing-rate">'.$package_price.'<span class="cbb-pricing-unit">'.$package_unit.'</span></p>
                                    '.(($button_location=='top')?ST_Pb_Helper_Premade::button('package_button', $atts):'').'
                                </div>

                                <div class="cbb-pricing-list">
                                    '.chiedolabs_shortcode_autop($content).'
                                    '.(($button_location=='bottom')?'<div class="cbb-pricing-button-bottom">'.ST_Pb_Helper_Premade::button('package_button', $atts).'</div>':'').'
                                </div>
                            </div>
		';
		

		return $this->element_wrapper( $html_element, $arr_params );
	}

}

endif;