<?php

if ( ! class_exists( 'ST_Item_Progressbar' ) ) {

	class ST_Item_Progressbar extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'item_text'        => __( 'Progress Bar Item', ST_PBL ),
				'data-modal-title' => __( 'Progress Bar Item', ST_PBL ),
			);

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
						'name'    => __( 'Text', ST_PBL ),
						'id'      => 'pbar_text',
						'type'    => 'text_field',
						'class'   => 'input-sm',
						'std'     => __( ST_Pb_Utils_Placeholder::add_placeholder( 'Progress Bar Item %s', 'index' ), ST_PBL ),
						'role'    => 'title',
					),
					array(
						'name'         => __( 'Percentage', ST_PBL ),
						'id'           => 'pbar_percentage',
						'type'         => 'slider',
						'class'        => 'st-slider',
						'std_max'      => '100',
						'std'          => '25',
					),
					array(
						'name'    => __( 'Color', ST_PBL ),
						'id'      => 'pbar_color',
						'type'    => 'select',
						'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_progress_bar_color() ),
						'options' => ST_Pb_Helper_Type::get_progress_bar_color(),
						//'container_class'   => 'color_select2',
					),
					
					array(
						'name'    => __( 'Info color', ST_PBL ),
						'id'       => 'info_color',
						'type'     => 'color_picker',
						'std'      => '',
					),
					
					array(
						'name'    => __( 'Style', ST_PBL ),
						'id'      => 'pbar_item_style',
						'type'    => 'select',
						'class'   => 'input-sm',
						'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_progress_bar_item_style() ),
						'options' => ST_Pb_Helper_Type::get_progress_bar_item_style()
					),
					array(
						'name'      => __( 'Icon', ST_PBL ),
						'id'        => 'pbar_icon',
						'type'      => 'icons',
						'std'       => '',
						'role'      => 'title_prepend',
						'title_prepend_type' => 'icon',
					),
					array(
						'id'    => 'pbar_group',
						'class' => 'pbar_group_type',
						'type'  => 'hidden',
						'std'   => 'multiple-bars',
					),
				)
			);
		}

		public function element_shortcode_full( $atts = null, $content = null ) {
			extract( shortcode_atts( $this->config['params'], $atts ) );
			$pbar_percentage       = floatval( $pbar_percentage );
			$pbar_color            = ( strtolower( $pbar_color ) == 'progress-bar-primary' || empty( $pbar_color ) ) ? $pbar_color = '' : ' ' . $pbar_color;
			$percent               = ( ! $pbar_percentage ) ? '' : $pbar_percentage . '%';
			$pbar_value			   = ( ! $pbar_percentage ) ? '' : ' aria-valuenow="' . $pbar_percentage . '"';
			$pbar_item_style       = ( ! $pbar_item_style || strtolower( $pbar_item_style ) == 'solid' ) ? '' : $pbar_item_style;
			if ( $pbar_item_style == 'striped' ) {
				$pbar_item_style = ' progress-striped';
			}

			$style = '';
			if($info_color) $style .= 'color:'.$info_color.';';

			$pbar_icon    = ( ! $pbar_icon ) ? '' : "<i class='{$pbar_icon}'></i>";
			$html_content = "[icon]{$pbar_icon}[/icon][text]{$pbar_text}[/text]";


			// Add title progressbar
			$html_content = "<div style='{$style}' class='progress-info'><span class='progress-title'>{$html_content}</span>[percentage]<span class='progress-percentage'>{$pbar_percentage}%</span>[/percentage]</div>";

			if ( $pbar_group == 'stacked' ) {
				$html_sub_elm = '[sub_content]' . $html_content . '[/sub_content]';
				$html_sub_elm .= "<div class='progress-bar{$pbar_color}{$pbar_item_style}' {$pbar_value}></div>";
			} elseif( $pbar_group == 'multiple-bars-within-bars' ) {
				
				$info = "<span class='progress-title'>[icon]{$pbar_icon}[/icon][text]{$pbar_text}[/text]</span>[percentage]<span class='progress-percentage'>{$pbar_percentage}%</span>[/percentage]";
				
				$html_sub_elm .= "<div class='progress{$pbar_item_style}{active}'>";
				$html_sub_elm .= "<div class='progress-bar {$pbar_color}' role='progressbar'{$pbar_value}aria-valuemin='0' aria-valuemax='100'><span style='{$style}' class='sr-only'>{$info}</span></div>";
				$html_sub_elm .= '</div>';
				
			} else {
				$html_sub_elm = '[sub_content]' . $html_content . '[/sub_content]';
				$html_sub_elm .= "<div class='progress{$pbar_item_style}{active}'>";
				$html_sub_elm .= "<div class='progress-bar {$pbar_color}' role='progressbar'{$pbar_value}aria-valuemin='0' aria-valuemax='100'><span class='sr-only'>{$percent}</span></div>";
				$html_sub_elm .= '</div>';
			}

			return $html_sub_elm . '<!--seperate-->';
		}

	}

}