<?php
/**
 * @version    $Id$
 * @package    WR PageBuilder
 * @author     WooRockets Team <support@woorockets.com>
 * @copyright  Copyright (C) 2012 woorockets.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.woorockets.com
 * Technical Support:  Feedback - http://www.woorockets.com
 */

if ( ! class_exists( 'ST_Progresscircle' ) ) :

/**
 * Progress circle element for ProStyler Builder.
 *
 * @since  1.0.0
 */
class ST_Progresscircle extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	function __construct() {
		// Register 3rd-party assets
		add_filter( 'st_pb_register_assets', array( &$this, 'register_assets' ) );

		// Let the parent class continue the construction
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Progress Circle', ST_PBL );
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-ProgressCircle';
		$this->config['description'] = __( 'Animated progress circle', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'Progress Circle', ST_PBL ),
			'data-modal-title' => __( 'Progress Circle', ST_PBL ),
			
			'admin_assets' => array(
				// Shortcode style and script initialization
				'st-colorpicker.js',
				'progresscircle.js',
			),

			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',

				// Font IcoMoon
				'st-pb-font-icomoon-css',

				// Lazy Load
				'st-pb-jquery-lazyload-js',


				// Circliful
				'st-pb-progress-circle-css',
				'st-pb-progress-circle-js',

				// Shortcode style and script initialization
				'progresscircle_frontend.css',
				'progresscircle_frontend.js',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	function element_items() {
		$this->items = array(
			'content' =>array(

				array(
					'name'    => __( 'Text', ST_PBL ),
					'id'      => 'text',
					'type'    => 'text_field',
					'role'    => 'content',
					'std'     => __( 'Circle', ST_PBL),
				),
				array(
					'name'    => __( 'Description', ST_PBL ),
					'id'      => 'description',
					'type'    => 'text_field',
					'std'     => __( '', ST_PBL),
				)
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name' => __('Alignment', ST_PBL),
					'id' => 'align',
					'type' => 'radio_button_group',
					'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_standard_align()),
					'options' => ST_Pb_Helper_Type::get_standard_align(),
					'class' => 'input-sm',
                    'css' => array(
                        array('', 'text-align')
                    )
				),
				array(
					'name'       => __( 'Percentage', ST_PBL ),
					'id'         => 'percent',
					'type'       => 'text_append',
					'type_input' => 'number',
					'class'      => 'input-mini',
					'std'        => '15',
					'append'     => '%',
					'validate'   => 'number',
				),
				array(
					'name'    => __( 'Foreground Color', ST_PBL ),
					'id'      => 'fg_color',
					'type'    => 'color_picker',
					'std'     => ' 	#556b2f',
				),
				array(
					'name'    => __( 'Background Color', ST_PBL ),
					'id'      => 'bg_color',
					'type'    => 'color_picker',
					'std'     => ' 	#eeeeee',
				),
				array(
					'name'       => __( 'Use Fill Color', ST_PBL ),
					'id'         => 'use_fill',
					'type'       => 'radio',
					'std'        => 'no',
					'has_depend' => '1',
					'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
				),
				array(
					'name'       => __( 'Fill Color', ST_PBL ),
					'id'         => 'fill_color',
					'type'       => 'color_picker',
					'std'        => '#ffffff',
					'dependency' => array( 'use_fill', '=', 'yes' )
				),
				array(
					'name'    => __( 'Text &amp; Icon color', ST_PBL ),
					'id'       => 'font_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( 'Color of text and icon.', ST_PBL ),
				),
				array(
					'name'       => __( 'Circle Thickness', ST_PBL ),
					'id'         => 'width',
					'type'       => 'text_append',
					'type_input' => 'number',
					'class'      => 'input-mini',
					'std'        => '15',
					'append'     => 'px',
					'validate'   => 'number',
				),
				array(
					'name'       => __( 'Dimension', ST_PBL ),
					'id'         => 'dimension',
					'type'       => 'text_append',
					'type_input' => 'number',
					'class'      => 'input-mini',
					'std'        => '200',
					'append'     => 'px',
					'validate'   => 'number',
					'tooltip'    => __( 'Size of process circle, caculated by its diameter', ST_PBL )
				),
				array(
					'name'       => __( 'Font Size', ST_PBL ),
					'id'         => 'font_size',
					'type'       => 'text_append',
					'type_input' => 'number',
					'class'      => 'input-mini',
					'std'        => '15',
					'append'     => 'px',
					'validate'   => 'number',
				),
				array(
					'name'       => __( 'Icon', ST_PBL ),
					'id'         => 'icon',
					'type'       => 'icons',
					'std'        => '',
					'title_prepend_type' => 'icon',
				),
				array(
					'name'       => __( 'Show half', ST_PBL ),
					'id'         => 'is_half',
					'type'       => 'radio',
					'std'        => 'no',
					'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
				),
				array(
					'name'            => __( 'Margin', ST_PBL ),
					'container_class' => 'combo-group',
					'id'              => 'circle_margin',
					'type'            => 'margin',
					'extended_ids'    => array( 'circle_margin_top', 'circle_margin_bottom', 'circle_margin_left', 'circle_margin_right' ),
					'circle_margin_top'	   => array( 'std' => '10' ),
					'circle_margin_bottom' => array( 'std' => '10' ),
					'tooltip'              => __( 'External spacing with other elements', ST_PBL ),
					'append'               => 'px',
                    'css' => array(
                        array('', 'margin')
                    )
				),				
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),				
			)
		);

		$this->items['mobile'] = array(
			array(
				'name' => __('Alignment', ST_PBL),
				'id' => 'm_align',
				'type' => 'radio_button_group',
				'std' => ST_Pb_Helper_Type::get_first_option(ST_Pb_Helper_Type::get_standard_align()),
				'options' => ST_Pb_Helper_Type::get_standard_align(),
				'css' => array(
                    'media_query' => array(
                        'query'=>'(max-width: 829px)',
                        'css' => array(
                            array('', 'text-align'),
                        )
                    )
				),
			),
		);

	}

	/**
	 * Register 3rd-party assets.
	 *
	 * @param   array  $assets  Current assets array.
	 *
	 * @return  void
	 */
	public function register_assets( $assets ) {
		$assets['st-pb-progress-circle-css'] = array(
			'src' =>  ST_PB_URI . 'shortcodes/progresscircle/assets/3rd-party/jquery-circliful/css/jquery.circliful.css',
			'ver' => '0.1.5',
		);

		$assets['st-pb-progress-circle-js'] = array(
			'src' =>  ST_PB_URI . 'shortcodes/progresscircle/assets/3rd-party/jquery-circliful/js/jquery.circliful.min.js',
			'ver' => '0.1.5',
		);

		return $assets;
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params = shortcode_atts( $this->config['params'], $atts );
		extract( $arr_params );

		$wrapper_style = '';
		if($font_color) $wrapper_style .= 'color: '.$font_color.';';

		$html = '<div style="'.$wrapper_style.'" class="cbb-st-progress-circle-wrapper">';
		$html .= '<div class="st-progress-circle" ';
		$html .= ( ! empty( $content ) )     ? ' data-text="' . $content . '"' : '';
		$html .= ( ! empty( $description ) ) ? ' data-info="' . $description . '"' : '';
		$html .= ( ! empty( $dimension ) )   ? ' data-dimension="' . $dimension . '"' : '';
		$html .= ( ! empty( $width ) )       ? ' data-width="' . $width . '"' : '';
		$html .= ( ! empty( $font_size ) )   ? ' data-fontsize="' . $font_size . '"' : '';
		$html .= ( ! empty( $percent ) )     ? ' data-percent="' . $percent . '"' : '';
		$html .= ( ! empty( $fg_color ) )    ? ' data-fgcolor="' . $fg_color . '"' : '';
		$html .= ( ! empty( $bg_color ) )    ? ' data-bgcolor="' . $bg_color . '"' : '';
		
		if ( $use_fill == 'yes' ) {
			$html .= ( ! empty( $fill_color ) )  ? ' data-fill="' . $fill_color . '"' : '';
		}
		if ( $is_half == 'yes' ) {
			$html .= ' data-type="half"';
		}
		
		$html .= ( ! empty( $icon ) )  ? ' data-icon="' . $icon . '" data-iconsize="' . $font_size . '"' : '';
		$html .= ( ! empty( $font_color ) )  ? ' data-iconcolor="'.$font_color.'"' : '';
		
		$html .= '></div>';
		$html .= '</div>';

		return $this->element_wrapper( $html, $arr_params );
	}
}

endif;
