<?php


if ( ! class_exists( 'ST_Promobox' ) ) :

/**
 * Create Promobox element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Promobox extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Promotion Box', ST_PBL );
		$this->config['cat']         = __( 'Content', ST_PBL );
		$this->config['icon']        = 'cbi-PromotionBox';
		$this->config['description'] = __( 'Styled box for promotion', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'Promotion Box', ST_PBL ),
			'data-modal-title' => __( 'Promotion Box', ST_PBL ),

			'admin_assets' => array(
				// Shortcode initialization
				'st-popover.js',
				'st-colorpicker.js',
				'st-linktype.js',
				'st-font-color.js'
			),

			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',

				'cbb-prettyphoto-js',
				'cbb-prettyphoto-css',

				// Shortcode style and script initialization
				'promobox_frontend.css',
				'promobox_frontend.js',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'content' => array(

				array(
					'id'      => 'pb_title',
					'name'    => __( 'Promotion Title', ST_PBL ),
					'type'    => 'text_field',
					'class'   => 'input-sm',
					'std'     => __( 'Promotion Box Title', ST_PBL ),
				),
				array(
					'id'      => 'pb_content',
					'role'    => 'content',
					'name'    => __( 'Promotion Content', ST_PBL ),
					'type'    => 'tiny_mce',
					'rows'    => '12',
					'std'     => ST_Pb_Helper_Type::lorem_text(12),
				),
				array(
							'type'       => 'skip_to_next_section',
				),
				array(
					'name'    => __( 'Button Title', ST_PBL ),
					'id'      => 'pb_button_title',
					'type'    => 'text_field',
					'class'   => 'input-sm',
					'std'     => 'Button Title',
				),
				array(
					'name'       => __( 'Button Link', ST_PBL ),
					'id'         => 'link_type',
					'type'       => 'select',
					'class'      => 'input-sm',
					'std'        => 'url',
					'options'    => ST_Pb_Helper_Type::get_link_types(),
					'has_depend' => '1',
				),
				array(
					'name'       => __( 'URL', ST_PBL ),
					'id'         => 'pb_button_url',
					'type'       => 'text_field',
					'class'      => 'input-sm',
					'std'        => 'http://',
					'dependency' => array( 'link_type', '=', 'url' )
				),
				array(
					'name'  => __( 'Single Item', ST_PBL ),
					'id'    => 'single_item',
					'type'  => 'type_group',
					'std'   => '',
					'items' => ST_Pb_Helper_Type::field_data_source(array(
						'callback' => 'ST_Pb_Helper_Type::get_single_item_button_bar',
						'args' => array(
							'link_type',
							array(
								'type'         => 'items_list',
								'options_type' => 'select',
								'class'        => 'select2-select',
								'ul_wrap'      => false,
							)
						)
					)),
				),
				array(
					'name'       => __( 'Open in', ST_PBL ),
					'id'         => 'pb_button_open_in',
					'type'       => 'select',
					'class'      => 'input-sm',
					'std'        => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_open_in_options() ),
					'options'    => ST_Pb_Helper_Type::get_open_in_options(),
					'dependency' => array( 'link_type', '!=', 'no_link' ),
					'has_depend' => '1'
				),
						
				// yunus edit - lightbox size option, same is applied to button type field
				array(
							'name'                 => __( 'Lightbox size', ST_PBL ),
							'container_class'      => 'combo-group dimension-inline',
							'id'                   => 'lb',
							'type'                 => 'dimension',
							'extended_ids'         => array( 'lb_width', 'lb_height', 'lb_width_unit', 'lb_height_unit' ),
							'lb_width'      => array( 'std' => '100' ),
							'lb_height'     => array( 'std' => '100' ),
							'lb_width_unit' => array(
								'options' => array( 'px' => 'px', '%' => '%' ),
								'std'     => '%',
							),
							'lb_height_unit' => array(
								'options' => array( 'px' => 'px', '%' => '%' ),
								'std'     => '%',
							),
							'tooltip' => __( 'Set width and height of lightbox window', ST_PBL ),
							'dependency' => array( 'pb_button_open_in', '=', 'lightbox' ),
				),
				
			),
			'styling' => array(
				array(
					'type' => 'preview',
					'size' => 'full',
				),
				array(
					'name' => __( 'Background Color', ST_PBL ),
					'type' => array(
/*
						array(
							'id'           => 'pb_bg_value',
							'type'         => 'text_field',
							'class'        => 'input-small',
							'std'          => '#F6F6F6',
							'parent_class' => 'combo-item',
						),
*/
						array(
							'id'           => 'pb_bg_color',
							'type'         => 'color_picker',
							'std'          => '#F6F6F6',
							'parent_class' => 'combo-item',
						),
					),
					'container_class' => 'combo-group',
				),
				array(
					'name'             => __( 'Border Width', ST_PBL ),
					'container_class'  => 'combo-group',
					'id'               => 'pb_border',
					'type'             => 'margin',
					'extended_ids'     => array( 'pb_border_top', 'pb_border_right', 'pb_border_bottom', 'pb_border_left' ),
					'pb_border_top'    => array( 'std' => '5' ),
					'pb_border_right'  => array( 'std' => '5' ),
					'pb_border_bottom' => array( 'std' => '5' ),
					'pb_border_left'   => array( 'std' => '5' ),
				),
				array(
					'name' => __( 'Border Color', ST_PBL ),
					'type' => array(
/*
						array(
							'id'           => 'pb_border_value',
							'type'         => 'text_field',
							'class'        => 'input-small',
							'std'          => '#A0CE4E',
							'parent_class' => 'combo-item',
						),
*/
						array(
							'id'           => 'pb_border_color',
							'type'         => 'color_picker',
							'std'          => '#A0CE4E',
							'parent_class' => 'combo-item',
						),
					),
					'container_class' => 'combo-group',
				),
				array(
					'name'    => __( 'Show Shadow', ST_PBL ),
					'id'      => 'pb_show_drop',
					'type'    => 'radio',
					'std'     => 'yes',
					'options' => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'tooltip' => __( 'Shadow of Promotion Box', ST_PBL )
				),
				array(
					'name'    => __( 'Elements', ST_PBL ),
					'id'      => 'elements',
					'type'    => 'items_list',
					'std'     => 'title__#__content__#__button',
					'options' => array(
						'title'   => __( 'Title', ST_PBL ),
						'content' => __( 'Content', ST_PBL ),
						'button'  => __( 'Button', ST_PBL )
					),
					'options_type'    => 'checkbox',
					'popover_items'   => array( 'title', 'button' ),
					'tooltip'         => __( 'Elements to display on promotion box', ST_PBL ),
					'style'           => array( 'height' => '200px' ),
					'container_class' => 'unsortable content-elements',
				),
				// Popup settings for Title
				array(
					'name'              => __( 'Font', ST_PBL ),
					'id'                => 'title_font',
					'type'              => 'select',
					'std'               => 'inherit',
					'options'           => array( 'inherit' => __( 'Inherit', ST_PBL ), 'custom' => __( 'Custom', ST_PBL ) ),
					'has_depend'        => '1',
					'class'             => 'input-medium',
					'tooltip'           => __( 'Select Font Type', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'title',
				),
				array(
					'name' => __( 'Font Face', ST_PBL ),
					'id'   => 'title_font_family',
					'type' => array(
						array(
							'id'           => 'title_font_face_type',
							'type'         => 'jsn_select_font_type',
							'class'        => 'input-medium input-sm',
							'std'          => 'standard fonts',
							'options'      => ST_Pb_Helper_Type::get_fonts(),
							'parent_class' => 'combo-item',
						),
						array(
							'id'           => 'title_font_face_value',
							'type'         => 'jsn_select_font_value',
							'class'        => 'input-medium input-sm',
							'std'          => 'Verdana',
							'options'      => '',
							'parent_class' => 'combo-item',
						),
					),
					'dependency'        => array( 'title_font', '=', 'custom' ),
					'tooltip'           => __( 'Select Font Face', ST_PBL ),
					'container_class'   => 'combo-group hidden',
					'data_wrap_related' => 'title',
				),

				array(
					'name' => __( 'Bottom Padding', ST_PBL ),
					'type' => array(
						array(
							'id'         => 'title_padding_bottom',
							'type'       => 'text_append',
							'type_input' => 'number',
							'class'      => 'input-mini',
							'std'        => '',
							'append'     => 'px',
							'validate'   => 'number',
						),
					),
					'tooltip'           => __( 'Set Bottom Padding', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'title',
				),
				array(
					'name' => __( 'Bottom Margin', ST_PBL ),
					'type' => array(
						array(
							'id'         => 'title_margin_bottom',
							'type'       => 'text_append',
							'type_input' => 'number',
							'class'      => 'input-mini',
							'std'        => '',
							'append'     => 'px',
							'validate'   => 'number',
						),
					),
					'tooltip'           => __( 'Set Bottom Margin', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'title',
				),
				array(
					'name'              => __( 'Size', ST_PBL ),
					'id'                => 'pb_button_size',
					'type'              => 'select',
					'std'               => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_button_size() ),
					'options'           => ST_Pb_Helper_Type::get_button_size(),
					'tooltip'           => __( 'Set Button Size', ST_PBL ),
					'container_class'   => 'hidden',
					'data_wrap_related' => 'button',
				),
				array(
					'name'              => __( 'Button Color', ST_PBL ),
					'id'                => 'pb_button_color',
					'type'              => 'select',
					'std'               => 'btn-danger',
					'options'           => ST_Pb_Helper_Type::get_button_color(),
					'tooltip'           => __( 'Set Button Color', ST_PBL ),
					'container_class'   => 'hidden color_select2',
					'data_wrap_related' => 'button',
				),
				array(
					'name' => __( 'Title Font Attributes', ST_PBL ),
					'type' => array(
						array(
							'id'           => 'title_font_size',
							'type'         => 'text_append',
							'type_input'   => 'number',
							'class'        => 'input-mini',
							'std'          => '',
							'append'       => 'px',
							'validate'     => 'number',
							'parent_class' => 'combo-item input-append-inline',
						),
						array(
							'id'           => 'title_font_style',
							'type'         => 'select',
							'class'        => 'input-medium st-mini-input input-sm',
							'std'          => 'bold',
							'options'      => ST_Pb_Helper_Type::get_font_styles(),
							'parent_class' => 'combo-item',
						),
						array(
							'id'           => 'title_font_color',
							'type'         => 'color_picker',
							'std'          => '#000000',
							'parent_class' => 'combo-item',
						),
					),
					'dependency'        => array( 'title_font', '=', 'custom' ),
					'tooltip'           => __( 'Set Font Attribute', ST_PBL ),
					'container_class'   => 'combo-group',
					//'data_wrap_related' => 'title',
				),
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		$html_element = '';
		$arr_params   = shortcode_atts( $this->config['params'], $atts );
		extract( $arr_params );
		$styles       = array();
		if ( $pb_bg_color ) {
			$styles[] = 'background-color:' . $pb_bg_color;
		}
		if ( intval( $pb_border_top ) > 0 ) {
			$styles[] = 'border-top-width:' . ( int ) $pb_border_top . 'px';
			$styles[] = 'border-top-style: solid';
		}
		if ( intval( $pb_border_left ) > 0 ) {
			$styles[] = 'border-left-width:' . ( int ) $pb_border_left . 'px';
			$styles[] = 'border-left-style: solid';
		}
		if ( intval( $pb_border_bottom ) > 0 ) {
			$styles[] = 'border-bottom-width:' . ( int ) $pb_border_bottom . 'px';
			$styles[] = 'border-bottom-style: solid';
		}
		if ( intval( $pb_border_right ) > 0 ) {
			$styles[] = 'border-right-width:' . ( int ) $pb_border_right . 'px';
			$styles[] = 'border-right-style: solid';
		}
		if ( $pb_border_color ) {
			$styles[] = 'border-color:' . $pb_border_color;
		}

		$elements = explode( '__#__', $elements );
		$class    = '';
		if ( $pb_show_drop == 'yes' ) {
			$class .= 'promo-box-shadow';
		}
		$single_item = explode( '__#__', $single_item );
		$single_item = $single_item[0];
		$script      = $cls_button_fancy = $target = $button = '';
		if ( in_array( 'button', $elements ) ) {
			$taxonomies = ST_Pb_Helper_Type::get_public_taxonomies();
			$post_types = ST_Pb_Helper_Type::get_post_types();
			
			if(isset($lb_width_unit) && $lb_width_unit=='px') $lb_width_unit = '';
			if(isset($lb_height_unit) && $lb_height_unit=='px') $lb_height_unit = '';
					
			$lightbox_w = (isset($lb_width) && $lb_width) ? $lb_width.$lb_width_unit : '100%';
			$lightbox_h = (isset($lb_height) && $lb_height) ? $lb_height.$lb_height_unit : '100%';
			
			// single post
			if ( array_key_exists( $link_type, $post_types ) ) {
				$permalink      = get_permalink($single_item);
					
				if($pb_button_open_in == 'lightbox') $permalink = add_query_arg( 'iframe=true&width='.$lightbox_w.'&height='.$lightbox_h, '', $permalink );
				
				$button_href = "href='{$permalink}'";
			}
			// taxonomy
			else if ( array_key_exists( $link_type, $taxonomies ) ) {
				$permalink = get_term_link( intval( $single_item ), $link_type );
				if ( ! is_wp_error( $permalink ) )
				{
					if($pb_button_open_in == 'lightbox') $permalink = add_query_arg( 'iframe=true&width='.$lightbox_w.'&height='.$lightbox_h, '', $permalink );
						
					$button_href = "href='{$permalink}'";
				}
			}
			else {
				switch ( $link_type ) {
					case 'no_link':
						$button_href = '';
						break;
					case 'url':
					
						if($pb_button_open_in == 'lightbox') $pb_button_url = add_query_arg( 'iframe=true&width='.$lightbox_w.'&height='.$lightbox_h, '', $pb_button_url );

					
						$button_href = "href='{$pb_button_url}'";
						break;
				}
			}

			if ( $pb_button_open_in AND $link_type != 'no_link' ) {
				switch ( $pb_button_open_in ) {
					case 'current_browser':
						$target = '';
						break;
					case 'new_browser':
						$target = ' target="_blank"';
						break;
					case 'new_window':
						$cls_button_fancy = 'st-button-new-window';
						$script = ST_Pb_Helper_Functions::new_window( ".$cls_button_fancy", array( 'width' => '75%', 'height' => '75%' ) );
						break;
					case 'lightbox':
						$cls_button_fancy = 'prettyphoto';
						break;
				}
			}

			$pb_button_size = ( isset( $pb_button_size ) && $pb_button_size != 'default' ) ? $pb_button_size : '';
			$pb_button_color = ( isset( $pb_button_color ) && $pb_button_color != 'default' ) ? $pb_button_color : '';
			
			$button = "<a class='pull-right btn {$pb_button_size} {$pb_button_color} {$cls_button_fancy}' {$target} {$button_href}>{$pb_button_title}</a>";
		}

		if ( ! in_array( 'content', $elements ) ) $class .= ' st-pb-no-content';

		$styles = implode( ';', $styles );
		$styles = ( $styles ) ? "style='{$styles}'" : '';
		$html_element .= "<div class='st-promobox'>";
		$html_element .= "<section class='{$class}' {$styles}>";
		$html_element .= $button;
		if ( in_array( 'title', $elements ) ) {
			$style_title = array();
			if ( $title_font == 'custom' ) {
				if ( $title_font_face_type == 'google fonts' ) {
					$script .= ST_Pb_Helper_Functions::add_google_font_link_tag( $title_font_face_value );
					$style_title[] = 'font-family:' . $title_font_face_value;
				} elseif ( $title_font_face_value ) {
					$style_title[] = 'font-family:' . $title_font_face_value;
				}
				if ( intval( $title_font_size ) > 0 ) {
					$style_title[] = 'font-size:' . intval( $title_font_size ) . 'px';
				}
				switch ( $title_font_style ) {
					case 'bold':
						$style_title[] = 'font-weight:700';
						break;
					case 'italic':
						$style_title[] = 'font-style:italic';
						break;
					case 'normal':
						$style_title[] = 'font-weight:normal';
						break;
				}
				if ( strpos( $title_font_color, '#' ) !== false ) {
					$style_title[] = 'color:' . $title_font_color;
				}
			}
			if ( $title_padding_bottom ) {
				$style_title[] = 'padding-bottom:' . $title_padding_bottom . 'px';
			}
			if ( $title_margin_bottom ) {
				$style_title[] = 'margin-bottom:' . $title_margin_bottom . 'px';
			}
			if ( count( $style_title ) ) {
				$style_title = 'style="' . implode( ';', $style_title ) . '"';
			} else
			$style_title = '';
			$html_element .= "<h2 {$style_title}>{$pb_title}</h2>";
		}
		$content = ( ! $content ) ? '' : $content;
		
		if ( ! empty( $content ) ) {
			$content = chiedolabs_shortcode_autop( $content );
		}
		
		if ( in_array( 'content', $elements ) )
			$html_element .= $content;
		
		$html_element .= '</section>';
		$html_element .= '</div>';

		return $this->element_wrapper( $html_element . $script, $arr_params );
	}
}

endif;
