<?php


if ( ! class_exists( 'ST_QRCode' ) ) :

/**
 * Create QR Code element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_QRCode extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'QR Code', ST_PBL );
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-QRCode';
		$this->config['description'] = __( 'QR code with data setting', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content'  => __( 'QR Code', ST_PBL ),
			'data-modal-title' => __( 'QR Code', ST_PBL ),

			'admin_assets' => array(
		// Shortcode initialization
				'qrcode.js',
		),

			'frontend_assets' => array(
		// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
		),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'content' => array(
				array(
					'name'          => __( 'Data', ST_PBL ),
					'id'            => 'qr_content',
					'type'          => 'text_area',
					'class'         => 'input-sm',
					'std'           => 'http://www.stencilor.com',
					'tooltip'       => __( 'Here you can input names, urls, phone numbers, email addresses or plain text', ST_PBL ),
					'exclude_quote' => '1',
				),
				array(
					'name'    => __( 'Image ALT Text', ST_PBL ),
					'id'      => 'qr_alt',
					'type'    => 'text_field',
					'class'   => 'input-sm',
					'std'     => __( 'Wordpress themes from www.stencilor.com', ST_PBL ),
					'tooltip' => __( 'Text tooltip appears when QR box is hovered through', ST_PBL ),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'    => __( 'Container Style', ST_PBL ),
					'id'      => 'qr_container_style',
					'type'    => 'radio',
					//'class'   => 'input-sm',
					'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_qr_container_style() ),
					'options' => ST_Pb_Helper_Type::get_qr_container_style(),
				),
				array(
					'name'    => __( 'Alignment', ST_PBL ),
					'id'      => 'qr_alignment',
					'class'   => 'input-sm',
					'type'    => 'radio_button_group',
					'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_text_align() ),
					'options' => ST_Pb_Helper_Type::get_text_align(),
				),
				array(
					'name'         => __( 'QR Code Size', ST_PBL ),
					'id'           => 'qrcode_sizes',
					'type'         => 'select',
					'class'        => 'input-mini-m input-sm st-select2-editor',
					'std'          => '150',
					'options'      => array(
						'150' => __( '150', ST_PBL ),
						'200' => __( '200', ST_PBL ),
						'250' => __( '250', ST_PBL ),
						'300' => __( '300', ST_PBL ),
						'350' => __( '350', ST_PBL ),
					),
					'parent_class'    => 'combo-item input-append select-append input-group input-select-append st-input-append',
					'append_text'     => 'px',
					'container_class' => 'combo-group',
					'disable_select2' => true
				),				
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		$html_element = '';
		$arr_params   = ( shortcode_atts( $this->config['params'], $atts ) );
		extract( $arr_params );
		$qrcode_sizes  = ( $qrcode_sizes ) ? ( int ) $qrcode_sizes : 0;
		$cls_alignment = '';
		if ( strtolower( $arr_params['qr_alignment'] ) != 'inherit' ) {
			if ( strtolower( $arr_params['qr_alignment'] ) == 'left' ) {
				$cls_alignment = 'pull-left';
			}
			if ( strtolower( $arr_params['qr_alignment'] ) == 'right' ) {
				$cls_alignment = 'pull-right';
			}
			if ( strtolower( $arr_params['qr_alignment'] ) == 'center' ) {
				$cls_alignment = 'text-center';
			}
		}
		$class_img    = ( $qr_container_style != 'no-styling' ) ? "class='{$qr_container_style}'" : '';
		$qr_content   = str_replace( '<st_quote>', '"', $qr_content );
		$image        = 'https://chart.googleapis.com/chart?chs=' . $qrcode_sizes . 'x' . $qrcode_sizes . '&cht=qr&chld=H|1&chl=' . $qr_content;
		$qr_alt       = ( ! empty( $qr_alt ) ) ? "alt='{$qr_alt}'" : '';
		$html_element = "<img src='{$image}' {$qr_alt} width='{$qrcode_sizes}' height='{$qrcode_sizes}' $class_img />";
		if ( $cls_alignment != '' ) {
			$html_element = "<div>{$html_element}</div>";
		}

		return $this->element_wrapper( $html_element, $arr_params, $cls_alignment );
	}
}

endif;
