<?php


if ( ! class_exists( 'ST_Revolutionslider' ) 
	&& is_plugin_active( 'revslider/revslider.php' ) ) :

/**
 * Create Alert element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Revolutionslider extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Revolution slider', ST_PBL );
		$this->config['cat']         = __( 'Wordpress Plugins', ST_PBL );
		$this->config['icon']        = 'cbi-RevolutionSlider';
		$this->config['description'] = __( 'Easily add sliders created with Revolution Slider', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		global $wpdb;
		$rs = $wpdb->get_results(
			"
SELECT id, title, alias
FROM " . $wpdb->prefix . "revslider_sliders
ORDER BY id ASC LIMIT 999
"
		);
		$revsliders = array();
		if ( $rs ) {
			foreach ( $rs as $slider ) {
				$revsliders[$slider->alias] = $slider->title;
			}
		} else {
			$revsliders[0] = __( 'No sliders found', ST_PBL );
		}	
		
		$this->items = array(
			'content' => array(

				array(
					'name'    => __( 'Revolution Slider', ST_PBL ),
					'id'      => 'alias',
					'type'    => 'select',
					'std'     => '',
					'options' => $revsliders,
					'tooltip' => __( 'Select your Revolution Slider.', ST_PBL ),
				),	
				
				array(
					'name'     => __( 'Show Info boxes', ST_PBL ),
					'id'       => 'show_info_boxes',
					'type'     => 'radio',
					'std'      => 'yes',
					'options'  => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'has_depend' => 1
				),
				
				array(
					'name'     => __( 'Overlay boxes', ST_PBL ),
					'id'       => 'overlay_boxes',
					'type'     => 'radio',
					'std'      => 'yes',
					'options'  => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'dependency'  => array( 'show_info_boxes', '=', 'yes' ),
				),
				
				array(
					'name'    => __( 'Style', ST_PBL ),
					'id'      => 'style',
					'type'    => 'select',
					'std'     => 'style1',
					'options' => array(
						"style1"=>"Style 1 (Default - Circle icons)",
						"style4"=>"Style 2 (Rounded square icons)",
						"style2"=>"Style 3 (Icons on side)",
						"style3"=>"Style 4 (Icons on top but within area)",
					),
					'tooltip' => __( 'Info boxes style.', ST_PBL ),
					'dependency'  => array( 'show_info_boxes', '=', 'yes' ),
				),	
				
				array(
					'name'    => __( 'Size', ST_PBL ),
					'id'      => 'size',
					'type'    => 'select',
					'std'     => 'full',
					'options' => array(
						"full"=>"Full Width",
						"container"=>"Container Width",
					),
				),	
				
			),
			
			'Info-box1' => array(
				
				array(
					'name'     => __( 'Heading', ST_PBL ),
					'id'       => 'slider_info_box_1_heading',
					'type'     => 'text_field',
					'std'      => 'Box1 Heading',
				),

				array(
					'name'     => __( 'Text', ST_PBL ),
					'id'       => 'slider_info_box_1_text',
					'type'     => 'text_area',
					'std'      => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
				),
				
				
				array(
					'name'     => __( 'Icon', ST_PBL ),
					'id'       => 'slider_info_box_1_icon',
					'type'     => 'icons',
					'std'      => 'fa fa-star-o',
				),

				
			),
			
			'Info-box2' => array(
				
				array(
					'name'     => __( 'Heading', ST_PBL ),
					'id'       => 'slider_info_box_2_heading',
					'type'     => 'text_field',
					'std'      => 'Box2 Heading',
				),

				array(
					'name'     => __( 'Text', ST_PBL ),
					'id'       => 'slider_info_box_2_text',
					'type'     => 'text_area',
					'std'      => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
				),
				
				
				array(
					'name'     => __( 'Icon', ST_PBL ),
					'id'       => 'slider_info_box_2_icon',
					'type'     => 'icons',
					'std'      => 'fa fa-star-o',
				),

				
			),
			
			'Info-box3' => array(
				
				array(
					'name'     => __( 'Heading', ST_PBL ),
					'id'       => 'slider_info_box_3_heading',
					'type'     => 'text_field',
					'std'      => 'Box3 Heading',
				),

				array(
					'name'     => __( 'Text', ST_PBL ),
					'id'       => 'slider_info_box_3_text',
					'type'     => 'text_area',
					'std'      => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
				),
				
				
				array(
					'name'     => __( 'Icon', ST_PBL ),
					'id'       => 'slider_info_box_3_icon',
					'type'     => 'icons',
					'std'      => 'fa fa-star-o',
				),

				
			),
			
			'styling' => array(

				
						
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),				
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		if ( isset( $_GET['st_shortcode_preview'] ) )
		{
			return '<center>[Revolution slider is not shown in the preview]</center>';
		}
		
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		
		$output = $title = $alias = $el_class = '';
		extract( shortcode_atts( array(
		    'alias' => '',
		    'size' => 'full',
		    'style'=>'style1',
		    'show_info_boxes' => 'yes',
		    'overlay_boxes' => 'yes',
		), $atts ) );
		
		$html_element  = '';
		if($show_info_boxes=='no') $css_class .= ' disable_info_boxes';
		if($overlay_boxes=='no') $css_class .= ' dont_overlay_boxes';
		
		$output .= '<div class="rev_slider_holder slider-size-'.$size.'">';
		$output .= '<div class="'.$css_class.'">';
		
		$slider = do_shortcode('[rev_slider '.$alias.']');
		//$slider = do_shortcode('[rev_slider alias="HP4PS530-400a"]');
		//return $slider;
		//die();

		if(preg_match('/Revolution Slider Error/i', $slider))
		{
			if(preg_match('/not found/i', $slider)) 
			{
				$slider = '<h3>Slider not found</h3>';
				$slider = '<div class="wpg-rev-slider-error">'.$slider.'</div>';
			}
			//$slider = '<div class="wpg-rev-slider-error">'.$slider.'</div>';
		}
		
		$output .= $slider;
		
		$output .= '</div>';
		
		//return $output;
		
		if($show_info_boxes=='yes')
		{
			$output .= '
				<div class="below_slider below_slider-'.$style.' '.(($overlay_boxes=='no')?'dont_overlay_boxes':'').'">
					<div class="below_slider_inner">
						<div class="'.(($size=='full')?'container':'').'">
							<div class="row">';
			
			if($style=='style2')
			{
				$output .= '
								<div class="block-wrap col-sm-4 col-md-4">
									<div class="block-content">
										<h2 class="block-title">
											<div class="block-icon">
												<div class="animated bounceIn" data-animation="bounceIn" data-animation-delay="03">
													<span>
														<i class="'.$atts['slider_info_box_1_icon'].'"></i>
													</span>
												</div>
											</div>
											'.$atts['slider_info_box_1_heading'].'
										</h2>
										<p>'.$atts['slider_info_box_1_text'].'</p>
									</div>
								</div>
								
								<div class="block-wrap col-sm-4 col-md-4">
									<div class="block-content">
										<h2 class="block-title">
											<div class="block-icon">
												<div class="animated bounceIn" data-animation="bounceIn" data-animation-delay="03">
													<span>
														<i class="'.$atts['slider_info_box_2_icon'].'"></i>
													</span>
												</div>
											</div>
											'.$atts['slider_info_box_2_heading'].'
										</h2>
										<p>'.$atts['slider_info_box_2_text'].'</p>
									</div>
								</div>
								
								<div class="block-wrap col-sm-4 col-md-4">
									<div class="block-content">
										<h2 class="block-title">
											<div class="block-icon">
												<div class="animated bounceIn" data-animation="bounceIn" data-animation-delay="03">
													<span>
														<i class="'.$atts['slider_info_box_3_icon'].'"></i>
													</span>
												</div>
											</div>
											'.$atts['slider_info_box_3_heading'].'
										</h2>
										<p>'.$atts['slider_info_box_3_text'].'</p>
									</div>
								</div>
				';
			}
			else
			{				
				$output .= '
								<div class="block-wrap col-sm-4 col-md-4">
									<div class="block-icon">
										<div class="animated bounceIn" data-animation="bounceIn" data-animation-delay="03">
											<span>
												<i class="'.$atts['slider_info_box_1_icon'].'"></i>
											</span>
										</div>
									</div>
									<div class="block-content">
										<h2 class="block-title">'.$atts['slider_info_box_1_heading'].'</h2>
										<p>'.$atts['slider_info_box_1_text'].'</p>
									</div>
								</div>
								
								<div class="block-wrap col-sm-4 col-md-4">
									<div class="block-icon">
										<div class="animated bounceIn" data-animation="bounceIn" data-animation-delay="03">
											<span>
												<i class="'.$atts['slider_info_box_2_icon'].'"></i>
											</span>
										</div>
									</div>
									<div class="block-content">
										<h2 class="block-title">'.$atts['slider_info_box_2_heading'].'</h2>
										<p>'.$atts['slider_info_box_2_text'].'</p>
									</div>
								</div>
								
								<div class="block-wrap col-sm-4 col-md-4">
									<div class="block-icon">
										<div class="animated bounceIn" data-animation="bounceIn" data-animation-delay="03">
											<span>
												<i class="'.$atts['slider_info_box_3_icon'].'"></i>
											</span>
										</div>
									</div>
									<div class="block-content">
										<h2 class="block-title">'.$atts['slider_info_box_3_heading'].'</h2>
										<p>'.$atts['slider_info_box_3_text'].'</p>
									</div>
								</div>
				';
			}
							
			$output .=
							'</div> <!-- end .row -->
						</div>
					</div>
				</div>
			';
		}
		
		$output .= '</div>';

		$html_element = $output;

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
