<?php


if ( ! class_exists( 'ST_Section' ) ) :

/**
 * Create Alert element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Section extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Section (One Page Websites)', ST_PBL );
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-Section';
		$this->config['description'] = __( 'Creates scrolling areas on your navigation menu', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(

		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		
		$this->items['content'] = array(

			array(
				'name'     => __( 'Section ID', ST_PBL ),
				'id'       => 'id',
				'type'     => 'random_id',
				'std'      => '',
				'tooltip' => __( 'Put this id in your menu to make it jump to this section upon clicking', ST_PBL ),
			),

		);

	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		extract( shortcode_atts( array(
		    'id' => '',
		), $atts ) );
		
		$id = preg_replace('/#/i', '', $id);

		$html_element = '<span class="st-section-element" id="'.$id.'"></span>';

		return $html_element;
	}
}

endif;
