<?php


if ( ! class_exists( 'ST_Sidebar' ) ) :

/**
 * Create Alert element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Sidebar extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Widgetised Sidebar', ST_PBL );
		$this->config['cat']         = __( 'Extra', ST_PBL );
		$this->config['icon']        = 'cbi-Sidebar';
		$this->config['description'] = __( 'Easily add widgets to your page', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{	
		$sidebars_global = $GLOBALS['wp_registered_sidebars'];

		$sidebars = array();
		foreach ( $sidebars_global as $sidebar ) 
		{
			$sidebars[ $sidebar["id"] ] = $sidebar["name"];
		}
		
		$this->items = array(
			'content' => array(

				array(
					'name'    => __( 'Sidebar', ST_PBL ),
					'id'      => 'sidebar_id',
					'type'    => 'select',
					//'std'     => '',
					'options' => $sidebars,
					'tooltip' => __( 'Select which widget area output.', ST_PBL ),
				),	
				
				
			),
			
			'styling' => array(

				
						
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),				
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		
		extract( shortcode_atts( array(
		    'sidebar_id' => '',
		), $atts ));
		
		ob_start();
		dynamic_sidebar($sidebar_id);
		$sidebar_value = ob_get_contents();
		ob_end_clean();

		$html_element = $sidebar_value;

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
