<?php


if ( ! class_exists( 'ST_Spacer' ) ) :

/**
 * Create Alert element.
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Spacer extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Spacer / Gap', ST_PBL );
		$this->config['cat']         = __( 'Basic', ST_PBL );
		$this->config['icon']        = 'cbi-SpacerGap';
		$this->config['description'] = __( 'Add empty space with custom height', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(

		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() 
	{
		
		$this->items['content'] = array(

			array(
				'name'     => __( 'Height', ST_PBL ),
				'id'       => 'height',
				'type'         => 'text_append',
				'type_input'   => 'number',
				'class'        => 'input-mini',
				'std'          => '32',
				'append'       => 'px',
				'validate'     => 'number',
			),

		);

		$this->items['styling'] = array(

				array(
					'type' => 'preview',
				),

		);

	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) 
	{
		// do not remove, used in element_wrapper
		$arr_params	   = ( shortcode_atts( $this->config['params'], $atts ) ); 
		
		extract( shortcode_atts( array(
		    'height' => '',
		), $atts ) );

		$html_element = '<div style="height: '.$height.'px"><span class="st_empty_space_inner"></span></div>';

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
