<?php

if ( ! class_exists( 'ST_Item_Tab' ) ) {
	/**
	 * Create child Tab element
	 *
	 * @package  ProStyler Builder Shortcodes
	 * @since    1.0.0
	 */
	class ST_Item_Tab extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'data-modal-title' => __( 'Tab Item', ST_PBL ),

			);

			// Inline edit for sub item
			$this->config['edit_inline'] = true;
		}

		/**
		 * DEFINE setting options of shortcode
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
								'name'  => __( 'Heading', ST_PBL ),
								'id'    => 'heading',
								'type'  => 'text_field',
								'class' => 'input-sm',
								'role'  => 'title',
								'std'   => __( ST_Pb_Utils_Placeholder::add_placeholder( 'Tab Item %s', 'index' ), ST_PBL ),
					),

					array(
						'name'       => __( 'Content Source', ST_PBL ),
						'id'         => 'content_source',
						'type'       => 'radio',
						'std'        => 'editor',
						'options'    => array( 'editor' => __( 'Editor', ST_PBL ), 'page_embed' => __( 'Page embed', ST_PBL ) ),
						'has_depend' => '1',
					),

					array(
						'name'    => __( 'Select Page', ST_PBL ),
						'id'      => 'page',
						'type'    => 'select',
						'std'     => '',
						'role'=>'title',
						'options' => ST_Pb_Helper_Functions::pages_array(),
						'dependency'      => array( 'content_source', '=', 'page_embed' ),
					),

					array(
								'name' => __( 'Content Editor', ST_PBL ),
								'id'   => 'body',
								'role' => 'content',
								'type' => 'tiny_mce',
								//'container_class' => 'st_tinymce_replace',
								'std'  => ST_Pb_Helper_Type::lorem_text(),
								'dependency'      => array( 'content_source', '=', 'editor' ),
					),
					array(
								'name'      => __( 'Icon', ST_PBL ),
								'id'        => 'icon',
								'type'      => 'icons',
								'std'       => '',
								'role'      => 'title_prepend',
								'title_prepend_type' => 'icon',
					),
				)
			);
		}

		/**
		 * DEFINE shortcode content
		 *
		 * @param type $atts
		 * @param type $content
		 */
		public function element_shortcode_full( $atts = null, $content = null ) {
			$arr_params = ( shortcode_atts( $this->config['params'], $atts ) );
			extract( $arr_params );
			
			$inner_content = '';
			if($content_source == 'page_embed')
			{
				if(isset($page) && trim($page))
				{	
					$inner_content = '<!--page_embed=['.$page.']-->';
				}
			}
			else
			{
				$inner_content = chiedolabs_shortcode_autop( $content );
			}

			$custom_style  = ST_Pb_Utils_Placeholder::get_placeholder( 'custom_style' );
			return "$heading<!--heading-->$icon<!--icon--><div id='pane{index}' class='tab-pane {active} {fade_effect}' $custom_style>
			{$inner_content}
				</div><!--seperate-->";
		}

	}

}
