<?php



if ( ! class_exists( 'ST_Tab' ) ) :

/**
 * Create Tabs element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Tab extends ST_Pb_Shortcode_Parent {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']        = strtolower( __CLASS__ );
		$this->config['name']             = __( 'Tab', ST_PBL );
		$this->config['cat']              = __( 'Interactive Elements', ST_PBL );
		$this->config['icon']             = 'cbi-Tab';
		$this->config['has_subshortcode'] = 'ST_Item_' . str_replace( 'ST_', '', __CLASS__ );
		$this->config['description']      = __( 'Tabbed content', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
				// Font IcoMoon
				'st-pb-font-icomoon-css',
				// Shortcode style
				'tab_frontend.css',
				'tab_frontend.js'
			),
			'admin_assets' => array(
				'st-pb-joomlashine-iconselector-js',
				'tab.js',
			),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'action' => array(
				array(
					'id'      => 'btn_convert',
					'type'    => 'button_group',
					'bound'   => 0,
					'actions' => array(
						array(
							'std'         => __( 'Accordion', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'tab_to_accordion',
						),
						array(
							'std'         => __( 'Carousel', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'tab_to_carousel',
						),
						array(
							'std'         => __( 'List', ST_PBL ),
							'action_type' => 'convert',
							'action'      => 'tab_to_list',
						),
					)
				),
			),
			'content' => array(	

				array(
					'id'            => 'tab_items',
					'type'          => 'group',
					'shortcode'     => ucfirst( __CLASS__ ),
					'sub_item_type' => $this->config['has_subshortcode'],
					'sub_items'     => array(
						array( 'std' => '' ),
						array( 'std' => '' ),
					),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'     => __( 'Open First', ST_PBL ),
					'id'       => 'initial_open',
					'type'     => 'text_number',
					'std'      => '1',
					'class'    => 'input-mini',
					'validate' => 'number',
					'tooltip'  => __( 'Tab to be opened at first load', ST_PBL ),
				),
				array(
					'name'       => __( 'Fade Effect', ST_PBL ),
					'id'         => 'fade_effect',
					'type'       => 'radio',
					'std'        => 'no',
					'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'has_depend' => '1',
				),
				array(
					'name'    => __( 'Tab Position', ST_PBL ),
					'id'      => 'tab_position',
					'type'    => 'radio_button_group',
					'class'   => 'input-sm',
					'std'     => 'top',
					'options' => array(
						'top'     => __( '<i class="st-icon-tab-top" title="Top"></i>', ST_PBL ),
						'bottom'  => __( '<i class="st-icon-tab-bottom" title="Bottom"></i>', ST_PBL ),
						'left'    => __( '<i class="st-icon-tab-left" title="Left"></i>', ST_PBL ),
						'right'   => __( '<i class="st-icon-tab-right" title="Right"></i>', ST_PBL ),
					),
				),


				array(
					'name'    => __( 'Heading', ST_PBL ),
					'type'    => 'group_open',
				),

				array(
					'name'    => __( 'Text color', ST_PBL ),
					'id'       => 'h_text_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .tabbable > .nav > li > a', 'color'),
					),
				),

				array(
					'name'    => __( 'Background color', ST_PBL ),
					'id'       => 'h_bg_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .tabbable > .nav > li > a', 'background-color'),
					),
				),

				array(
					'name'    => __( 'Active Text color', ST_PBL ),
					'id'       => 'h_h_text_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .tabbable > .nav > li.active > a', 'color'),
						array('> .tabbable > .nav > li:hover > a', 'color'),
					),
				),

				array(
					'name'    => __( 'Active Background color', ST_PBL ),
					'id'       => 'h_h_bg_color',
					'type'     => 'color_picker',
					'std'      => '#ffffff',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .tabbable > .nav > li.active > a', 'background-color'),
						array('> .tabbable > .nav > li:hover > a', 'background-color'),
					),
				),

				array(
					'name'    => __( 'Border color', ST_PBL ),
					'id'       => 'border_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .tabbable > .nav > li.active > a', 'border-color'),
						array('> .tabbable > .tab-content', 'border-color'),

						array('> .tabbable > .nav > li.active > a', 'border-bottom-color', 'transparent', array(
								array('tab_position', '=', 'top')
							)),
						array('> .tabbable > .nav-tabs', 'border-bottom-color', '', array(
								array('tab_position', '=', 'top')
							)),

						array('> .tabbable > .nav-tabs', 'border-top-color', '', array(
								array('tab_position', '=', 'bottom')
							)),
					),
				),

				array(
					'type'    => 'group_close',
				),

				array(
					'name'    => __( 'Content Background color', ST_PBL ),
					'id'       => 'bg_color',
					'type'     => 'color_picker',
					'std'      => '',
					'tooltip' => __( '', ST_PBL ),
					'css' => array(
						array('> .tabbable > .tab-content', 'background-color'),
					),
				),

				array(
					'name' => __( 'Rounded corners', ST_PBL ),
					'id'           => 'border_radius',
					'type'     => 'slider',
					'class'        => 'st-slider',
					'std_max'      => '20',
					'std'          => '0',
					'append'       => 'px',
					'validate'     => 'number',
					'css' => array(
						array('> .tabbable.tabs-top > .tab-content', 'border-bottom-left-radius'),
						array('> .tabbable.tabs-top > .tab-content', 'border-bottom-right-radius'),
						array('> .tabbable.tabs-top > .nav > li > a', 'border-radius', '%value% %value% 0 0'),

						array('> .tabbable.tabs-below > .tab-content', 'border-top-left-radius'),
						array('> .tabbable.tabs-below > .tab-content', 'border-top-right-radius'),
						array('> .tabbable.tabs-below > .nav > li > a', 'border-radius', '0 0 %value% %value%'),

						array('> .tabbable.tabs-left > .tab-content', 'border-top-right-radius'),
						array('> .tabbable.tabs-left > .tab-content', 'border-bottom-right-radius'),
						array('> .tabbable.tabs-left > .nav > li > a', 'border-radius', '%value% 0 0 %value%'),

						array('> .tabbable.tabs-right > .tab-content', 'border-top-left-radius'),
						array('> .tabbable.tabs-right > .tab-content', 'border-bottom-left-radius'),
						array('> .tabbable.tabs-right > .nav > li > a', 'border-radius', '0 %value% %value% 0'),
					),
				),


				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params   = ( shortcode_atts( $this->config['params'], $atts ) );
		$initial_open = intval( $arr_params['initial_open'] );
		$tab_position = ( $arr_params['tab_position'] );

		$random_id    = ST_Pb_Utils_Common::random_string();

		$tab_navigator   = array();
		$tab_navigator[] = '<ul class="nav nav-tabs">';
		$sub_shortcode   = do_shortcode( $content );


		$items         = explode( '<!--seperate-->', $sub_shortcode );
		$items         = array_filter( $items );
		$initial_open  = ( $initial_open > count( $items ) ) ? 1 : $initial_open;
		$fade_effect = '';
		if ( $arr_params['fade_effect'] == 'yes' ) {
			$fade_effect = 'fade in';
		}
		foreach ( $items as $idx => $item ) {
			// Extract icon & heading
			$ex_heading = explode( '<!--heading-->', $item );
			$ex_icon    = explode( '<!--icon-->', isset ( $ex_heading[1] ) ? $ex_heading[1] : '' );

			$new_key = $random_id . $idx;
			$active  = ( $idx + 1 == $initial_open ) ? 'active' : '';

			$item            = isset ( $ex_icon[1] ) ? $ex_icon[1] : '';
			$item            = str_replace( '{index}', $new_key, $item );
			$item            = str_replace( '{active}', $active, $item );
			$item            = str_replace( '{fade_effect}', $fade_effect, $item );
			
			// replace content of tab with page embed
			if(preg_match('/'.preg_quote('<!--page_embed=[').
				'([a-z0-9]+(?:-[a-z0-9]+)*)'
				.preg_quote(']-->').'/i', $item, $page_embed) 
				&& isset($page_embed[1]) )
			{
				$page_embed = $page_embed[1];
				$tab_content = do_shortcode( $this->get_page_content( $page_embed ) );

				$item = str_replace('<!--page_embed=['.$page_embed.']-->', $tab_content, $item);
			}
			else
			{
				$item = do_shortcode( $item );
			}

			$items[ $idx ] = $item;

			$icon    = ! empty ( $ex_icon[0] ) ?  "<i class='{$ex_icon[0]}'></i>&nbsp;" : '';
			$heading = ! empty ( $ex_heading[0] ) ? $ex_heading[0] : ( __( 'Tab Item ' ) . ' ' . $idx );
			ST_Pb_Helper_Functions::heading_icon( $heading, $icon );
			$active_li       = ( $idx + 1 == $initial_open ) ? "class='active'" : '';
			$tab_navigator[] = "<li $active_li><a href='#pane$new_key'>{$icon}{$heading}</a></li>";
		}
		$sub_shortcode = implode( '', $items );
		$tab_content   = "<div class='tab-content'>$sub_shortcode</div>";
		// update min-height of each tab content in case tap position is left/right
		if ( in_array( $tab_position, array( 'left', 'right' ) ) ) {
			$min_height  = 36 * count( $items );
			$tab_content = ST_Pb_Utils_Placeholder::remove_placeholder( $tab_content, 'custom_style', "style='min-height: {$min_height}px'" );
		}

		$tab_navigator[] = '</ul>';

		$tab_positions = array( 'top' => 'tabs-top', 'left' => 'tabs-left', 'right' => 'tabs-right', 'bottom' => 'tabs-below' );
		$extra_class = $tab_positions[ $tab_position ];
		if ( $tab_position == 'bottom' ) {
			$tab_content .= implode( '', $tab_navigator );
		} else {
			$tab_content = implode( '', $tab_navigator ) . $tab_content;
		}


		$html_element = "<div class='tabbable $extra_class' id='tab_{ID}'>$tab_content</div>";
		$html_element = str_replace( '{ID}', "$random_id", $html_element );
		return $this->element_wrapper( $html_element, $arr_params );
	}



	function get_page_content($id, $echo_css = true)
	{
		$page = get_page_by_path($id,OBJECT,'page');
		
		if(! $page OR !isset($page->ID)) return false;

		// Get what tab (Classic - Pagebuilder) is active when Save content of this post
		$st_page_active_tab = get_post_meta( $page->ID, '_wr_page_active_tab', true );
		$st_deactivate_pb = get_post_meta( $page->ID, '_wr_deactivate_pb', true );

		$content = $page->post_content;
		$content = ST_Pb_Helper_Shortcode::get_builder_tab_content(
			$content, 
			$page, 
			$st_page_active_tab,
			$st_deactivate_pb
		);

		// if not deactivate pagebuilder on this post/page then add its css etc
		if ( empty( $st_deactivate_pb ) ) 
		{

			$custom_css_data = ST_Pb_Helper_Functions::custom_css_data( isset ( $page->ID ) ? $page->ID : NULL );
			extract( $custom_css_data );

			if($css_custom)
			{
				$css_custom = html_entity_decode( stripslashes( $css_custom ) );

				$this->page_css = balanceTags( "<style id='st-pb-custom-{$post->ID}-css'>\n$css_custom\n</style>\n" );
				if($echo_css) echo $this->page_css;
			}
		}

		if(! trim($content)) return false;
		
		return $content;
	}


}

endif;
