<?php

if ( ! class_exists( 'ST_Item_Table' ) ) {

	/**
	 * Create Table child element
	 *
	 * @package  ProStyler Builder Shortcodes
	 * @since    1.0.0
	 */
	class ST_Item_Table extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'item_text'        => __( '', ST_PBL ),
				'data-modal-title' => __( 'Table Item', ST_PBL ),
				'item_wrapper'     => 'div',
				'action_btn'       => 'edit',

				'admin_assets' => array(
					// Shortcode initialization
					'item_table.js',
				),
			);
		}

		/**
		 * DEFINE setting options of shortcode
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
						'name' => __( 'Width', ST_PBL ),
						'type' => array(
							array(
								'id'           => 'width_value',
								'type'         => 'text_number',
								'std'          => '',
								'class'        => 'input-mini',
								'validate'     => 'number',
								'parent_class' => 'combo-item merge-data',
							),
							array(
								'id'           => 'width_type',
								'type'         => 'select',
								'class'        => 'input-mini',
								'options'      => array( 'percentage' => '%', 'px' => 'px' ),
								'std'          => 'percentage',
								'parent_class' => 'combo-item merge-data',
							),
						),
						'container_class' => 'combo-group',
					),
					array(
						'name'            => __( 'Tag Name', ST_PBL ),
						'id'              => 'tagname',
						'type'            => 'text_field',
						'std'             => 'td',
						'type_input'      => 'hidden',
						'container_class' => 'hidden',
                        'tooltip' => __( '', ST_PBL ),
					),
					array(
						'name'     => __( 'Row Span', ST_PBL ),
						'id'       => 'rowspan',
						'type'     => 'text_number',
						'std'      => '1',
						'class'    => 'input-mini positive-val',
						'validate' => 'number',
						'role'     => 'extract',
                        'tooltip' => __( 'Enable extending over multiple rows', ST_PBL ),
					),
					array(
						'name'     => __( 'Column Span', ST_PBL ),
						'id'       => 'colspan',
						'type'     => 'text_number',
						'std'      => '1',
						'class'    => 'input-mini positive-val',
						'validate' => 'number',
						'role'     => 'extract',
                        'tooltip' => __( 'Enable extending over multiple columns', ST_PBL ),
					),
					array(
						'name'    => __( 'Row Style', ST_PBL ),
						'id'      => 'rowstyle',
						'type'    => 'select',
						'class'   => 'input-sm',
						'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_table_row_color() ),
						'options' => ST_Pb_Helper_Type::get_table_row_color(),
					),
					array(
						'name'   => __( 'Content', ST_PBL ),
						'id'     => 'cell_content',
						'role'   => 'content',
						'role_2' => 'title',
						'type'   => 'tiny_mce',
						'std'    => __( '', ST_PBL ),
                        'tooltip' => __( 'Table content', ST_PBL ),
					),
				)
			);
		}

		/**
		 * DEFINE shortcode content
		 *
		 * @param type $atts
		 * @param type $content
		 */
		public function element_shortcode_full( $atts = null, $content = null ) {
			$atts = shortcode_atts( $this->config['params'], $atts );
			extract( $atts );
			
			$rowstyle = ( ! $rowstyle || strtolower( $rowstyle ) == 'default' ) ? '' : $rowstyle;
			
			if(isset($atts[0]))
			{
				$tagname = $atts[0];
				if($tagname == "tagname='tr_start'")
				{
					return "tr_start<!--seperate-->";
				}
				
				if($tagname == "tagname='tr_end'")
				{
					return "tr_end<!--seperate-->";
				}
			}
			
			if ( in_array( $tagname, array( 'tr_start', 'tr_end' ) ) ) {
				return "$tagname<!--seperate-->";
			}
			
			$width_type = $width_type == 'percentage' ? '%' : $width_type;
			$width = ! empty( $width_value ) ? "width='{$width_value}{$width_type}'" : '';
			$empty = empty( $content ) ? '<!--empty-->' : '';
			return "<CELL_WRAPPER class='$rowstyle' rowspan='$rowspan' colspan='$colspan' $width>" . chiedolabs_shortcode_autop( $content ) . "</CELL_WRAPPER>$empty<!--seperate-->";
		}

	}

}
