<?php


if ( ! class_exists( 'ST_Table' ) ) :

/**
 * Create Table element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Table extends ST_Pb_Shortcode_Parent {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']        = strtolower( __CLASS__ );
		$this->config['name']             = __( 'Table (DEPRECIATED)', ST_PBL );
		$this->config['cat']              = __( 'Content', ST_PBL );
		$this->config['icon']             = 'cbi-table';
		$this->config['has_subshortcode'] = 'ST_Item_' . str_replace( 'ST_', '', __CLASS__ );
		$this->config['description']      = __( 'Creates a table to display your information', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'admin_assets' => array(
				// Shortcode initialization
				'table.js',
			),
			'frontend_assets' => array(
				// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
			),
		);

		// Do not use Ajax to load element settings modal because this element has sub-item
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'content' => array(

				array(
					'name'          => __( 'Table Content', ST_PBL ),
					'id'            => 'table_',
					'type'          => 'table',
					'shortcode'     => ucfirst( __CLASS__ ),
					'sub_item_type' => $this->config['has_subshortcode'],
					'sub_items'     => array(
						array( 'std' => "[st_item_table tagname='tr_start' ][/st_item_table]" ),
						array( 'std' => '' ),
						array( 'std' => '' ),
						array( 'std' => "[st_item_table tagname='tr_end' ][/st_item_table]" ),
						array( 'std' => "[st_item_table tagname='tr_start' ][/st_item_table]" ),
						array( 'std' => '' ),
						array( 'std' => '' ),
						array( 'std' => "[st_item_table tagname='tr_end' ][/st_item_table]" ),
					),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'    => __( 'Style', ST_PBL ),
					'id'      => 'tb_style',
					'type'    => 'select',
					'class'   => 'input-sm',
					'options' => array( 'table-default' => __( 'Default', ST_PBL ), 'table-striped' => __( 'Striped', ST_PBL ), 'table-bordered' => __( 'Bordered', ST_PBL ), 'table-hover' => __( 'Hover', ST_PBL ) ),
					'std'     => 'default',
				),
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params    = ( shortcode_atts( $this->config['params'], $atts ) );

		$sub_shortcode = do_shortcode( $content );
		// seperate by cell
		$items_html    = explode( '<!--seperate-->', $sub_shortcode );

		// remove empty element
		$items_html    = array_filter( $items_html );
		$row           = 0;
		$not_empty     = 0;
		$updated_html  = array();
		
		foreach ( $items_html as $item ) {
			$cell_html = '';
			$cell_wrap = ( $row == 0 ) ? 'th' : 'td';

			if ( strpos( $item, 'CELL_WRAPPER' ) === false ) {
				$cell_html .= ( $item == 'tr_start' ) ? '<tr>' : '</tr>';
				if ( strip_tags( $item ) == 'tr_end' )
				$row++;
			}
			else {
				if ( strpos( $item, '<!--empty-->' ) !== false ) {
					$item = str_replace( '<!--empty-->', '', $item );
				} else {
					$not_empty++;
				}

				$cell_html .= str_replace( 'CELL_WRAPPER', $cell_wrap, $item );
			}
			$updated_html[] = $cell_html;
		}

		$sub_shortcode = ( $not_empty == 0 ) ? '' : implode( '', $updated_html );

		$html_element = "<table class='table {$arr_params['tb_style']}'>" . $sub_shortcode . '</table>';
		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
