
(function ($) {
	'use strict';
	
	$(document).ready(function () {
		
		// Set manual event previous for testimonial left control.
		$('.st-element-testimonial .left').on('click', function (e) {
			e.preventDefault();
			var parent_id = $(this).closest('.st-testimonial').attr('id');
			if ( typeof( $('#' + parent_id).carousel ) == 'function' ) {
				$( '#' + parent_id ).carousel( 'prev' );
			}
		});
		
		// Set manual event next for testimonial right control.
		$('.st-element-testimonial .right').on('click', function (e) {
			e.preventDefault();
			var parent_id = $(this).closest('.st-testimonial').attr('id');
			if ( typeof( $('#' + parent_id).carousel ) == 'function' ) {
				$( '#' + parent_id ).carousel( 'next' );
			}
		});
		
		// Set manual event for testimonial indicator controls.
		$('.st-element-testimonial .carousel-indicators li').each(function (index) {
			$(this).on('click', function (e) {
				e.preventDefault();
				var parent_id = $(this).closest('.st-testimonial').attr('id');
				if ( typeof( $('#' + parent_id ).carousel ) == 'function' ) {
					$('#' + parent_id ).carousel( index );
				}
			});
		});
	});
})(jQuery);