<?php

if ( ! class_exists( 'ST_Item_Testimonial' ) ) {

	class ST_Item_Testimonial extends ST_Pb_Shortcode_Child {

		public function __construct() {
			parent::__construct();
		}

		/**
		 * DEFINE configuration information of shortcode
		 */
		public function element_config() {
			$this->config['shortcode'] = strtolower( __CLASS__ );
			$this->config['exception'] = array(
				'item_text'        => __( 'Testimonial Item', ST_PBL ),
				'data-modal-title' => __( 'Testimonial Item', ST_PBL ),

			);
			

			// Inline edit for sub item
			//$this->config['edit_inline'] = true;
		}

		/**
		 * DEFINE setting options of shortcode
		 */
		public function element_items() {
			$this->items = array(
				'Notab' => array(
					array(
						'name'  => __( 'Title', ST_PBL ),
						'id'    => 'elm_title',
						'type'  => 'text_field',
						'role'  => 'title',
						'std'   => __( ST_Pb_Utils_Placeholder::add_placeholder( 'Testimonial Item %s', 'index' ), ST_PBL )
					),
					array(
						'name'    => __( 'Client\'s Name', ST_PBL ),
						'type'    => array(
							array(
								'id'          => 'name',
								'type'        => 'text_field',
								'std'         => '',
								'placeholder' => 'John Doe',
								'parent_class' => 'combo-item input-append-inline',
							),
							array(
								'id'           => 'name_height',
								'type'         => 'text_append',
								'type_input'   => 'number',
								'class'        => 'input-mini',
								'std'          => '14',
								'append'       => 'px',
								'validate'     => 'number',
								'parent_class' => 'combo-item input-append-inline',
							),
							array(
								'id'           => 'name_color',
								'type'         => 'color_picker',
								'std'          => '',
								'parent_class' => 'combo-item',
							),
						),
						'tooltip'         => __( 'Client\'s Name Description', ST_PBL ),
						'container_class' => 'combo-group',
					),
					array(
						'name'    => __( 'Client\'s Position', ST_PBL ),
						'id'      => 'job_title',
						'type'    => 'text_field',
						'std'     => __( '', ST_PBL ),
						'tooltip' => __( 'Client\'s Position Description', ST_PBL ),
						'placeholder' => 'CEO'
					),
					array(
						'name' => __( 'Feedback Content', ST_PBL ),
						'id'   => 'body',
						'role' => 'content',
						'type' => 'tiny_mce',
						'std'  => ST_Pb_Helper_Type::lorem_text()
					),
					array(
						'name'    => __( 'Country', ST_PBL ),
						'id'      => 'country',
						'type'    => 'text_field',
						'std'     => __( '', ST_PBL ),
						'tooltip' => __( 'Country Description', ST_PBL )
					),
					array(
						'name'    => __( 'Company', ST_PBL ),
						'id'      => 'company',
						'type'    => 'text_field',
						'std'     => __( '', ST_PBL ),
						'tooltip' => __( 'Company Description', ST_PBL )
					),
					array(
						'name'    => __( 'Website URL', ST_PBL ),
						'id'      => 'web_url',
						'type'    => 'text_field',
						'std'     => __( 'http://', ST_PBL ),
						'tooltip' => __( 'Website URL Description', ST_PBL )
					),
					array(
						'name'    => __( 'Avatar', ST_PBL ),
						'id'      => 'image_file',
						'type'    => 'select_media',
						'std'     => '',
						'class'   => 'jsn-input-large-fluid',
						'tooltip' => __( 'Image File for User', ST_PBL )
					),
				)
			);
		}

		/**
		 * DEFINE shortcode content
		 *
		 * @param type $atts
		 * @param type $content
		 */
		public function element_shortcode_full( $atts = null, $content = null ) {
			$atts = shortcode_atts( $this->config['params'], $atts );
			extract( $atts );

			$atts['testimonial_content'] = chiedolabs_shortcode_autop($content);
			return serialize( $atts ) . '<!--seperate-->';
		}

	}

}
