<?php


if ( ! class_exists( 'ST_Text' ) ) :

/**
 * Create Text element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Text extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Text', ST_PBL );
		$this->config['cat']         = __( 'Basic,Content', ST_PBL );
		$this->config['icon']        = 'cbi-Text';
		$this->config['description'] = __( 'Adds Simple text or shortcodes', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(
			'default_content' => __( 'Text', ST_PBL ),

			'admin_assets' => array(
		// Shortcode initialization
				'st-colorpicker.js',
				'text.js',
		),

			'frontend_assets' => array(
		// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
		),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	function element_items() {

		$this->items = array(
			'content' => array(

				array(
					'name' => __( 'Content', ST_PBL ),
					'desc' => __( 'Enter some content for this textblock', ST_PBL ),
					'id'   => 'text',
					'type' => 'tiny_mce',
					'role' => 'content',
					'std'  => ST_Pb_Helper_Type::lorem_text(),
					'rows' => 15,
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'               => __( 'Margin', ST_PBL ),
					'container_class'    => 'combo-group',
					'id'                 => 'text_margin',
					'type'               => 'margin',
					'extended_ids'       => array( 'text_margin_top', 'text_margin_right', 'text_margin_bottom', 'text_margin_left' ),
					'text_margin_top'    => array( 'std' => '0' ),
					'text_margin_bottom' => array( 'std' => '0' ),
					'tooltip'            => __( 'External spacing with other elements', ST_PBL ),
                       'append'               => 'px',
                        'css' => array(
                            array('', 'margin')
                        )
				),
				array(
					'name'       => __( 'Enable Dropcap', ST_PBL ),
					'id'         => 'enable_dropcap',
					'type'       => 'radio',
					'std'        => 'no',
					'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'tooltip'    => __( 'The first letter of paragraph that is enlarged', ST_PBL ),
					'has_depend' => '1',
				),
				array(
					'name' => __( 'Font Face', ST_PBL ),
					'id'   => 'dropcap_font_family',
					'type' => array(
						array(
							'id'           => 'dropcap_font_face_type',
							'type'         => 'jsn_select_font_type',
							'class'        => 'input-medium input-sm',
							'std'          => 'standard fonts',
							'options'      => ST_Pb_Helper_Type::get_fonts(),
							'parent_class' => 'combo-item',
						),
						array(
							'id'           => 'dropcap_font_face_value',
							'type'         => 'jsn_select_font_value',
							'class'        => 'input-medium input-sm',
							'std'          => 'Verdana',
							'options'      => '',
							'parent_class' => 'combo-item',
						),
					),
					'dependency'      => array( 'enable_dropcap', '=', 'yes' ),
					'tooltip'         => __( 'Set Font Face', ST_PBL ),
					'container_class' => 'combo-group',
				),
				array(
					'name' => __( 'Font Attributes', ST_PBL ),
					'type' => array(
						array(
							'id'           => 'dropcap_font_size',
							'type'         => 'text_append',
							'type_input'   => 'number',
							'class'        => 'input-mini',
							'std'          => '64',
							'append'       => 'px',
							'validate'     => 'number',
							'parent_class' => 'combo-item input-mini-inline',
						),
						array(
							'id'           => 'dropcap_font_style',
							'type'         => 'select',
							'class'        => 'input-medium st-mini-input input-sm',
							'std'          => 'bold',
							'options'      => ST_Pb_Helper_Type::get_font_styles(),
							'parent_class' => 'combo-item',
						),
						array(
							'id'           => 'dropcap_font_color',
							'type'         => 'color_picker',
							'std'          => '#000000',
							'parent_class' => 'combo-item',
						),
					),
					'dependency'      => array( 'enable_dropcap', '=', 'yes' ),
					'tooltip'         => __( 'Set Font Attribute', ST_PBL ),
					'container_class' => 'combo-group',
				),				
				ST_Pb_Helper_Type::get_apprearing_animations(),
				ST_Pb_Helper_Type::get_animation_speeds(),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params = shortcode_atts( $this->config['params'], $atts );
		extract( $arr_params );
		

		$random_id = ST_Pb_Utils_Common::random_string();
		$script = $html_element = '';
		if ( ! empty( $content ) ) {
			$content = chiedolabs_shortcode_autop( $content );
		}
		if ( isset( $enable_dropcap ) && $enable_dropcap == 'yes' ) {
			if ( $content ) {
				$styles = array();
				if ( $dropcap_font_face_type == 'google fonts' AND $dropcap_font_face_value != '' ) {
					$script .= ST_Pb_Helper_Functions::add_google_font_link_tag( $dropcap_font_face_value );
					$styles[] = 'font-family:' . $dropcap_font_face_value;
				} elseif ( $dropcap_font_face_type == 'standard fonts' AND $dropcap_font_face_value ) {
					$styles[] = 'font-family:' . $dropcap_font_face_value;
				}

				if ( intval( $dropcap_font_size ) > 0 ) {
					$styles[] = 'font-size:' . intval( $dropcap_font_size ) . 'px';
					$styles[] = 'line-height:' . intval( $dropcap_font_size ) . 'px';
				}
				switch ( $dropcap_font_style ) {
					case 'bold':
						$styles[] = 'font-weight:700';
						break;
					case 'italic':
						$styles[] = 'font-style:italic';
						break;
					case 'normal':
						$styles[] = 'font-weight:normal';
						break;
				}

				if ( strpos( $dropcap_font_color, '#' ) !== false ) {
					$styles[] = 'color:' . $dropcap_font_color;
				}

				if ( count( $styles ) ) {
					$html_element .= '<style type="text/css">';
					$html_element .= sprintf( '%1$s .dropcap:first-letter, %1$s .dropcap p:first-letter { float:left;', "#$random_id" );
					$html_element .= implode( ';', $styles );
					$html_element .= '}';
					$html_element .= '</style>';
				}

				$html_element .= "<div class='dropcap'>{$content}</div>";
			}
		} else {
			$html_element .= $content;
		}
		$html  = sprintf( '<div class="st_text" id="%s">', $random_id );
		$html .= $script;
		$html .= $html_element;
		$html .= '</div>';

		// Process margins
		if ( isset( $arr_params['text_margin_top'] ) )
			$arr_params['div_margin_top']    = $arr_params['text_margin_top'];
		if ( isset( $arr_params['text_margin_bottom'] ) )
			$arr_params['div_margin_bottom'] = $arr_params['text_margin_bottom'];
		if ( isset( $arr_params['text_margin_right'] ) )
			$arr_params['div_margin_right']  = $arr_params['text_margin_right'];
		if ( isset( $arr_params['text_margin_left'] ) )
			$arr_params['div_margin_left']   = $arr_params['text_margin_left'];

		return $this->element_wrapper( $html, $arr_params );
	}
}

endif;
