<?php



if ( ! class_exists( 'ST_Tooltip' ) ) :

/**
 * Create Tooltip element
 *
 * @package  ProStyler Builder Shortcodes
 * @since    1.0.0
 */
class ST_Tooltip extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	public function element_config() {
		$this->config['shortcode']   = strtolower( __CLASS__ );
		$this->config['name']        = __( 'Tooltip', ST_PBL );
		$this->config['cat']         = __( 'Interactive Elements', ST_PBL );
		$this->config['icon']        = 'cbi-ToolTip';
		$this->config['description'] = __( 'Create a tooltip that shows on hover', ST_PBL );

		// Define exception for this shortcode
		$this->config['exception'] = array(

			'frontend_assets' => array(
		// Bootstrap 3
				'st-pb-bootstrap-css',
				'st-pb-bootstrap-js',
		),
		);

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	public function element_items() {
		$this->items = array(
			'content' => array(

				array(
					'name'    => __( 'Parent Element Text', ST_PBL ),
					'id'      => 'text',
					'type'    => 'text_field',
					'class'   => 'input-sm',
					'std'     => __( 'Your text', ST_PBL ),
				),
				array(
					'name'    => __( 'Tooltip Content', ST_PBL ),
					'id'      => 'tooltip_content',
					'role'    => 'content',
					'type'    => 'tiny_mce',
					'std'     => __( 'Your tooltip content', ST_PBL ),
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'    => __( 'Tooltip Position', ST_PBL ),
					'id'      => 'position',
					'type'    => 'select',
					'class'   => 'input-sm',
					'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_full_positions() ),
					'options' => ST_Pb_Helper_Type::get_full_positions(),
				),
				array(
					'name'       => __( 'Make Parent Element a Button', ST_PBL ),
					'id'         => 'tooltips_button',
					'type'       => 'radio',
					'std'        => 'no',
					'options'    => array( 'yes' => __( 'Yes', ST_PBL ), 'no' => __( 'No', ST_PBL ) ),
					'has_depend' => '1',
					'tooltip' => __( 'Create button from text', ST_PBL ),
				),
				array(
					'name' => __( 'Button Color', ST_PBL ),
					'type' => array(
					array(
							'id'      => 'button_color',
							'type'    => 'select',
							'std'     => ST_Pb_Helper_Type::get_first_option( ST_Pb_Helper_Type::get_button_color() ),
							'options' => ST_Pb_Helper_Type::get_button_color(),
						),
					),
					'dependency' => array( 'tooltips_button', '=', 'yes' ),
					'container_class'   => 'color_select2',
				),
				array(
					'name'            => __( 'Delay', ST_PBL ),
					'container_class' => 'combo-group',
					'type'            => array(
						array(
							'id'            => 'show',
							'type'          => 'text_append',
							'type_input'    => 'number',
							'class'         => 'input-mini',
							'std'           => '500',
							'append_before' => 'Show',
							'append'        => 'ms',
							'parent_class'  => 'input-group-inline',
							'validate'      => 'number',
						),
						array(
							'id'            => 'hide',
							'type'          => 'text_append',
							'type_input'    => 'number',
							'class'         => 'input-mini',
							'std'           => '100',
							'append_before' => 'Hide',
							'append'        => 'ms',
							'parent_class'  => 'input-group-inline',
							'validate'      => 'number',
						),
					),
					'tooltip' => __( 'Set time (ms) to show/ hide tooltip when hover/ leave', ST_PBL ),
				),
			)
		);
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	public function element_shortcode_full( $atts = null, $content = null ) {
		$arr_params = shortcode_atts( $this->config['params'], $atts );
		extract( $arr_params );
		$random_id  = ST_Pb_Utils_Common::random_string();
		$tooltip_id = "tooltip_$random_id";
		// don't allow to run shortcode
		$content = str_replace( '[', '[[', $content );
		$content = str_replace( ']', ']]', $content );
		$content = html_entity_decode( $content );
		$content = preg_replace( '/\s+/', ' ', trim( $content ) );

		$button_color = ( ! $button_color || strtolower( $button_color ) == 'default' ) ? '' : $button_color;
		$position     = strtolower( $position );
		$delay_show   = ! empty( $show ) ? intval( $show ) : 500;
		$delay_hide   = ! empty( $hide ) ? intval( $hide ) : 100;
		$direction    = array( 'top' => 'top', 'bottom' => 'bottom', 'left' => 'left', 'right' => 'right' );
		$script = "<script type='text/javascript'>( function ($) {
				$( document ).ready( function ()
				{
					$('#$tooltip_id').click(function(e){
						e.preventDefault();
					})
					$('#$tooltip_id').tooltip({
						html: true,
						delay: { show: $delay_show, hide: $delay_hide },
						placement: '{$direction[$position]}'
					})
				});
			} )( jQuery )</script>";
		if ( $tooltips_button == 'no' ) {
			$html = "<a id='$tooltip_id' class='st-label-des-tipsy' title='$content' href='#'>$text</a>";
		} else {
			$html = "<a id='$tooltip_id' class='st-label-des-tipsy btn {$button_color}' title='$content' href='#'>$text</a>";
		}
		$html = $html . $script;
		if ( is_admin() ) {
			$custom_style = "style='margin-top: 50px;'";
			$html_element = "<center $custom_style>$html</center>";
		} else
		$html_element = $html;

		return $this->element_wrapper( $html_element, $arr_params );
	}
}

endif;
