<?php


if ( ! class_exists( 'ST_Widget' ) ) :

/**
 * Widget element for ProStyler Builder.
 *
 * @since  1.0.0
 */
class ST_Widget extends ST_Pb_Shortcode_Element {
	/**
	 * Constructor
	 *
	 * @return  void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Configure shortcode.
	 *
	 * @return  void
	 */
	function element_config() {
		$this->config['shortcode'] = strtolower( __CLASS__ );

		// Use Ajax to speed up element settings modal loading speed
		$this->config['edit_using_ajax'] = true;
	}

	/**
	 * Define shortcode settings.
	 *
	 * @return  void
	 */
	function element_items() {
	}

	/**
	 * Generate HTML code from shortcode content.
	 *
	 * @param   array   $atts     Shortcode attributes.
	 * @param   string  $content  Current content.
	 *
	 * @return  string
	 */
	function element_shortcode_full( $atts = null, $content = null ) {
		//echo '<pre>'.print_r($content, TRUE).'</pre>';
		//return ST_Pb_Helper_Shortcode::widget_content( array( $content ) );
	}
}

endif;
