<?php
/**
 * Plugin Name: ProStyler Builder
 * Plugin URI:  http://stencilor.com
 * Description:
 * Version:     0.0.1
 * Author:      Michael.F & Yunus.J
 * Author URI:  http://stencilor.com
 * License:     GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */
/*
====== CHANGELOG ======

 */

// to prevent memory issue when too many shortcodes are used (also applied in ST_Pb_Helper_Shortcode class)
ini_set('memory_limit', '12800M');
ini_set('max_execution_time', 3000);
ini_set('max_input_time', 3000);

// Define path to this plugin file
define('ST_PB_FILE', __FILE__);

// Load WordPress plugin functions
require_once ABSPATH . 'wp-admin/includes/plugin.php';

if (!class_exists('ST_Pb_Init')):

/**
 * Initialize ProStyler Builder.
 *
 * @package  ProStyler Builder
 * @since    1.0.0
 */
	class ST_Pb_Init {
		/**
		 * Constructor
		 *
		 * @return  void
		 */
		public function __construct() {
			// Load core functionalities
			$this->includes();
			$this->autoload();

			// Initialize assets management and loader
			ST_Pb_Assets_Register::init();
			ST_Pb_Init_Assets::hook();
			// Initialize WR Library
			ST_Pb_Init_Plugin::hook();

			// Register necessary actions
			add_action('widgets_init', array(&$this, 'init'), 100);
			add_action('admin_init', array('ST_Pb_Gadget_Base', 'hook'), 100);
			add_action('init', array('ST_Pb_Gadget_Preview', 'hook'), 100);

			// Activate plugin
			//register_activation_hook( ST_PB_FILE, array( $this, 'do_activate' ) );
			add_action("after_switch_theme", array($this, 'do_activate'));

			// Redirect after plugin activation
			add_action('admin_init', array($this, 'do_activation_redirect'));

			// Initialize built-in shortcodes
			include dirname(__FILE__) . '/shortcodes/main.php';

			// ------------------------------------------------------
			//  yunus edit - file for custom functions
			// ------------------------------------------------------
			include dirname(__FILE__) . '/stencilor/init.php';
		}

		/**
		 * Initialize core functionalities.
		 *
		 * @return  void
		 */
		function init() {
			global $St_Pb, $St_Pb_Widgets;

			// Initialize ProStyler Builder
			$St_Pb = new ST_Pb_Core();
			new ST_Pb_Utils_Plugin();

			do_action('st_pagebuilder_init');

			// Initialize widget support
			$St_Pb_Widgets = !empty($St_Pb_Widgets) ? $St_Pb_Widgets : ST_Pb_Helper_Functions::widgets();
		}

		/**
		 * Include required files.
		 *
		 * @return  void
		 */
		function includes() {
			// include core files
			include_once 'core/loader.php';
			include_once 'defines.php';
		}

		/**
		 * Register autoloader.
		 *
		 * @return  void
		 */
		function autoload() {
			ST_Pb_Loader::register(ST_PB_PATH . 'core', 'ST_Pb_');
			ST_Pb_Loader::register(ST_PB_PATH . 'core/gadget', 'ST_Gadget_');

			// Allow autoload registration from outside
			do_action('st_pb_autoload');
		}

		/**
		 * Activate handle.
		 *
		 * @return  void
		 */
		public function do_activate() {
			update_option('_ST_defualt_providers_v2', '');
		}

		/**
		 * Activation redirect handle.
		 *
		 * @return  void
		 */
		public function do_activation_redirect() {
			if (get_option('st_pagebuilder_do_activation_redirect', 'No') == 'Yes') {
				update_option('st_pagebuilder_do_activation_redirect', 'No');
				wp_redirect(admin_url('admin.php?page=st-pb-about-us'));
			}
		}
	}

// Instantiate ProStyler Builder initialization class
	$GLOBALS['st_pagebuilder'] = new ST_Pb_Init();

endif;

// ------------------------------------------------------
//  update api
// ------------------------------------------------------
/*
require dirname( __FILE__ ) . '/wp-updates-plugin.php';
$MyUpdateChecker = PucFactory::buildUpdateChecker(
'http://members.stencilor.com/update_api/plugin.php',
__FILE__
);
 */