<?php
	
class CBB_frontend
{
	static public $is_frontend = false;
	
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function __construct()
	{
		$this->detect_frontend();
		add_action('init', array($this, 'init'), 10);
		add_filter('st_element_html', array($this, 'elements_wrapper'), 10, 2);
	}
	
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function detect_frontend()
	{
		if ( ! isset($_GET['st_frontend']) OR $_GET['st_frontend']!='1') 
			return false;
			
		CBB_frontend::$is_frontend = true;
	}
	
	
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function init()
	{
		if ( ! CBB_frontend::is_frontend() ) 
			return false;
			
		if(! current_user_can('edit_pages') )
		{
			echo 'Unauthorised access';
			die();
			return false;
		}
			
		add_action( 'wp_enqueue_scripts', array($this, 'assets'));
		add_action( 'wp_footer', array($this, 'display'));
	}
	
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function assets()
	{
		$assets = array(
			// ------------------------------------------------------
			//  JS
			// ------------------------------------------------------
			'jquery-ui-resizable',
			'jquery-ui-sortable',
			'jquery-ui-droppable',
			'jquery-ui-tabs',
			'jquery-ui-dialog',
			'jquery-ui-button',
			'jquery-ui-slider',
			'jquery-effects-core',
			'jquery-effects-fade',
			
			'cbb-frontend-js' => array(
				'src' => 'stencilor/frontend/assets/js/frontend_builder.js',
				'ver' => '1.0',
				'deps' => array('cbb-sortable'),
			),
			
			// ------------------------------------------------------
			//  CSS
			// ------------------------------------------------------
			'cbb-frontend-css' => array(
				'src' => 'stencilor/frontend/assets/css/frontend_builder.css',
				'ver' => '1.0',
			),
		);
		
		foreach($assets as $handle=>$args)
		{
			if(! is_array($args)) 
			{
				$handle = $args;
				$args = array();
			}
			$this->load_asset($handle, $args);
		}
		
		
		wp_localize_script('cbb-frontend', 'CBB', array(
			'ajaxurl'      => admin_url( 'admin-ajax.php' ),
			'adminroot'    => admin_url(),
			'_nonce'       => wp_create_nonce( ST_NONCE ),
			'edit_url' => ST_EDIT_ELEMENT_URL . '&st_frontend_edit=1',
			'save'         => __( 'Save', ST_PBL ),
			'cancel'       => __( 'Cancel', ST_PBL ),
			'delete'       => __( 'Delete Element', ST_PBL ),
			'assets_url'   => ST_PB_URI,
			'st_edit_confirm'       => __( "You have not saved the changes to current element.\n\nPress OK to continue anyway.", ST_PBL ),
		));
	}
	
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function load_asset($handle, $args=array())
	{
		if(! empty($args))
		{
			$args = wp_parse_args($args , array(
				'src'=>'',
				'deps'=>array(),
				'ver'=>'1.0',
				'footer'=>false,
			));
			
			// Fine-tune asset location
			if ( ! preg_match( '#^(https?:)?/#', $args['src'] ) AND is_file( ST_PB_PATH . ltrim( $args['src'], '/' ) ) ) {
				$args['src'] = ST_PB_URI . ltrim( $args['src'], '/' );
			}
		}
		
		$type = ( substr( $handle, -4 ) == '-css' ) ? 'style' : 'script';
		$handle = preg_replace( '/-(css|js)$/', '', $handle );

				
		if ( 'style' == $type )
		{
			if(empty($args)) return wp_enqueue_style($handle);
			
			wp_enqueue_style($handle, $args['src'], $args['deps'], $args['ver'], $args['footer']);
		}
		else
		{
			if(empty($args)) return wp_enqueue_script($handle);
			
			wp_enqueue_script($handle, $args['src'], $args['deps'], $args['ver'], $args['footer']);
		}
	}
	
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function display()
	{
		include_once ST_PB_PATH . 'stencilor/frontend/interface/builder.php';
	}	
	
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	static public function is_frontend()
	{
		return CBB_frontend::$is_frontend;
	}
	

	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function elements_wrapper($output, $instance)
	{
		if(! CBB_frontend::is_frontend()) return $output;
				
		$output = $instance->element_in_pgbldr_frontend( $output, $instance->original_atts, $instance->original_content );


		return $output;
	}
	
		
	/**
	 * 
	 *
	 * @since 0.0.1
	 */
	function elements_wrapperbk($output, $atts, $content, $config, $fields)
	{
		if(! CBB_frontend::is_frontend()) return $output;
		
		
		

		$defaults = $this->fields_to_defaults($fields);
		
		foreach($atts as $key=>$val)
		{
			if(! in_array($key, $defaults))
			{
				unset($atts[ $key ]);
			}
		}
		
		
		$atts = wp_parse_args(
			$atts,
			$defaults
		);
		
		unset( $atts['help_frame'] );
		
		//$atts = array($config['shortcode']=>$atts);
		$atts['shortcode'] = $config['shortcode'];
		

		//$json_atts = json_encode($atts);
		$json_atts = ST_Pb_Helper_Shortcode::generate_shortcode_structure( $config['shortcode'], $config['params'] );

		$output .= '<div class="st_element_controls">';
			$output .= '<div class="st_element_attrss">'.$json_atts.'</div>';
		$output .= '</div>';

		return $output;
	}
	
	
	function fields_to_defaults($fields)
	{
		$defaults = array();
		
		foreach($fields as $sections=>$items)
		{
			foreach($items as $item)
			{
				if(! isset($item['id']) ) continue;
				
				$defaults[ $item['id'] ] = $item['std'];
			}
		}
		
		return $defaults;
	}
	
}

global $st_frontend;
$st_frontend = new CBB_frontend();


// ------------------------------------------------------
//  HELPERS
// ------------------------------------------------------
function is_wr_frontend()
{
	return CBB_frontend::is_frontend();
}