<?php
include "shortcode-wpautop-control.php";
include_once dirname( __FILE__ ) . '/upgrader.php';

if ( ! class_exists( 'CBB_Init' ) ) :

class CBB_Init 
{
	public static $log = array();

	public function __construct() 
	{
		// removes wp autop from shortcodes where we expect raw html/js code etc
		chiedolabs_shortcode_wpautop_control(array('st_html', 'st_newsletter'));
		
		add_action('wp_insert_post', array($this, 'ajax_save'), 99999, 1);
		
		add_filter('st_help_tab', array($this, 'help_tab'), 10, 2);
		
		add_action( 'wp_ajax_st_create_menu_location', array($this, 'ajax_create_menu_location'));
		
		add_action( 'init', array( $this, 'sitewide_init' ) );
		

		// add_action( 'wp_footer', array( $this, 'performanceTest' ) );

		// Initialize frontend editing
		//include_once dirname( __FILE__ ) . '/frontend/main.php';
	}


	function performanceTest()
	{
		// echo '<pre>'.print_r( self::$log , TRUE).'</pre>';

		$allTotalTime = 0;
		foreach (self::$log as $shortcodeName => $all) {
			$s_totalTime = 0;
			foreach ($all as $each) {
				$s_totalTime += $each['timeTaken'];
			}
			$allTotalTime += $s_totalTime;

			echo '<pre>'.print_r( $shortcodeName . ' - Total: '.$s_totalTime , TRUE).'</pre>';

			//$totalTime += $value['timeTaken'];
		}

		echo '<pre>allTotalTime: '.print_r($allTotalTime, TRUE).'</pre>';
	}
	
	function sitewide_init()
	{
		new CBB_upgrader();
	}
	
	function ajax_save($post_id)
	{
		if(! isset($_POST['st_doing_ajax'])) return;

		// if(wp_verify_nonce( '_wpnonce' ))
		// {
		// 	echo "valid \n";
		// }
		// else
		// {
		// 	echo "Invalid \n";
		// }
		
		echo json_encode(array('success' => true));
		exit;
	}
	
	
	function help_tab($std, $element_name)
	{
		$url = $this->help_api_url();
		
		if(! $element_name) return 'No help available for this element';
		
		$element_name = strtolower($element_name);
		
		if(! $url)
		{
			return 'You don not have this feature. If you are using this plugin along with our theme, please activate the theme using your license key.';
		}
		
		$url .= '&element='.$element_name;
		
		
		return '<div class="cbb-frame-url" data-url="'.esc_attr( esc_url( $url ) ).'"><div class="wpg_loader"></div></div>';
	}
	
	
    // ------------------------------------------------------
    //  yunus edit - api url
    // ------------------------------------------------------
    function help_api_url()
    {
		$product = basename(get_template_directory());
		
		$key = trim(get_option('st_license_key'));
		
		if(! $key)
		{
			return false;
		}

    	$url = '//members.prostylertheme.com/?help_tab';
    	$url .= '&key='.$key;
    	$url .= '&product='.$product;
    	
    	return $url;
    }
    
    
    // ------------------------------------------------------
    //  
    // ------------------------------------------------------
    function ajax_create_menu_location()
    {
	    if(! isset($_POST['menu_location_name']) OR ! trim($_POST['menu_location_name']))
	    {
		    echo 'Please specify menu location name';
		    die();
	    }
	    
	    $menu_location_name = trim($_POST['menu_location_name']);
	    $menu_location_key = sanitize_key($menu_location_name);
	    
    	$custom_menus = get_option('cbb_custom_menus');
    	
    	if(isset($custom_menus[ $menu_location_key ])) 
    	{
		    echo 'Menu location with this name already exists';
		    die();
    	}
    	
    	$custom_menus[ $menu_location_key ] = $menu_location_name;
    	
    	update_option('cbb_custom_menus', $custom_menus);
    	
    	echo $this->menu_locations_select($menu_location_key, 'options');
    	die();
    }
    
    static function menu_locations_select($select='', $as='array')
    {
		$menus = array(
			''=>'Select',
			'cbb-new-menu'=>'Create new location',
		);
		
		$theme_menus = get_registered_nav_menus();
		if($theme_menus && is_array($theme_menus))
		{
			$menus = array_merge($menus, $theme_menus);
		}
		
		$custom_menus = get_option('cbb_custom_menus');
		if($custom_menus && is_array($custom_menus))
		{
			$menus = array_merge($menus, $custom_menus);
		}
				
		if($as == 'options')
		{
			$menus_array = $menus;
			$menus = '';
			foreach($menus_array as $key=>$val)
			{
				$menus .= '<option '.(($select==$key)?'selected="selected"':'').' value="'.$key.'">'.$val.'</option>';
			}
		}
		elseif($as == 'json')
		{
			$menus_array = $menus;
			$menus = array();
			foreach($menus_array as $key=>$val)
			{
				$menus[] = array('id'=> $key, 'text'=> $val);
			}
			
			return json_encode($menus);
		}
		
		return $menus;
    }
    
	
}

$GLOBALS['CBB'] = new CBB_Init();

endif;
