<?php

/**
 * Converts WR Shortcodes to ST shortcodes
 * and reduces the size of shortcodes by ommiting default values
 *
 * @since 0.0.1
 */

if (isset($_GET['builder_upgrader']) && $_GET['builder_upgrader'] == '1') {
	global $st_force_init_builder;
	$st_force_init_builder = true;
}

class CBB_upgrader {
	public $message;
	public $shortcode_convert_skipped;

	public static $remap = array(
		'heading_margin_top' => 'div_margin_top',
		'heading_margin_bottom' => 'div_margin_bottom',
		'heading_margin_left' => 'div_margin_left',
		'heading_margin_right' => 'div_margin_right',
	);

	public function __construct() {
		if (!is_admin()) {
			return;
		}

		add_action('admin_init', array($this, 'admin_init'));
		add_action('wp_ajax_cbt_upgrade_content_prostylerRev', array($this, 'upgrade_button'));
	}

	public function admin_init() {

		if (isset($_GET['builder_upgrader']) && $_GET['builder_upgrader'] == '1') {
			$this->init();
		}

		if (isset($_GET['st_msg']) && $_GET['st_msg']) {
			add_action('admin_notices', array($this, 'display_finish_notice'));
		}

		$this->upgrade_notice();


	}

	public function upgrade_notice() {
		if (get_option('st_pagebuilder_upgrade', 'no') == 'yes') {
			add_action('admin_notices', array($this, 'display_admin_notice'));
		}
	}

	public function display_admin_notice() {
		?>
		<div class="notice st-notice error st-animate-attention">
			<div class="st-notice-logo"><?php cbt_logo_small_icon('echo'); ?></div>
			<div class="st-notice-message wp-st-existing">
				<strong><?php _e('IMPORTANT !', ST_PBL);?></strong>
				<br><?php _e('Upgrade your content to work with ProStyler Revelation.', ST_PBL);?>
			</div>
			<div class="st-notice-cta">
				<?php echo '<button class="st-notice-act button-primary cbt_btn_ajax" id="cbt-btn-upgrader" data-ajax-action="cbt_upgrade_content_prostylerRev" data-msg="This process can take few minutes.'."\n\n".'It is highly recommended to make a backup before proceeding.'."\n\n".'Continue?">Upgrade content</button>'; ?>
			</div>
		</div>
		<?php
}

	public function display_finish_notice() {
		?>
		<div class="notice <?php echo $_GET['st_status']; ?> my-acf-notice is-dismissible" >
			<p>
				<?php echo urldecode($_GET['st_msg']); ?>
			</p>
		</div>


		<?php
}

	public function init() {
		if ($this->start() === false) {
			wp_redirect(admin_url('?st_status=error&st_msg=' . urlencode($this->message)));
		} else {
			update_option('st_pagebuilder_upgrade', 'no');
			wp_redirect(admin_url('?st_status=updated&st_msg=' . urlencode($this->message)));
		}

		die();
	}

	public function upgrade_button() {
		if ($this->start() === false) {
			echo '<h2 class="error">' . __('Content failed !') . ': ' . $this->message . '</h2>';
		} else {
			update_option('st_pagebuilder_upgrade', 'no');
			echo '<h2 class="success">' . __('Content upgraded to ProStyler Rev !') . '</h2>';
		}

		die();
	}

	/**
	 * Gets wordpress posts and runs them through
	 * the processor
	 * @return null
	 */
	public function start($filter_posts = array('post_type' => 'any')) {

		if( cbt::increase_memory('3000M') === false )
		{
			echo '<h2 class="cbt-fatal-error">Upgrade failed. Please increase your server\'s memory limit to atleast 256M.<br /><br />If you don\'t know how to do that then please contact your hosting provider.</h2>';
			return false;;
		}

		//cbt_apis::poll_start();
		$this->convertPosts($filter_posts);
		$this->convertWidgets();
		//ob_flush(); flush();

		$this->message = 'Content conversion completed !';
		return true;
	}

	public function convertPosts($filter_posts = array('post_type' => 'any'))
	{
		// $test = '[wr_heading el_title="Our success rate is over 99%" tag="h2" heading_icon_icon="" heading_icon_size="32" heading_icon_color="" heading_icon_style="simple" heading_icon_position="left" icon_margin="10" text_align="center" heading_margin_top="0" heading_margin_left="40" heading_margin_bottom="0" heading_margin_right="40" font="custom" font_face_type="standard fonts" font_face_value="Trebuchet MS" font_size_value_="32" font_style="bold" color="#172d42" enable_underline="yes" border_bottom_width_value_="" border_bottom_style="solid" border_bottom_color="" padding_bottom_value_="" appearing_animation="0" css_suffix="" id_wrapper="" disabled_el="no" wrapper_padding_top="1" wrapper_padding_left="0" wrapper_padding_bottom="1" wrapper_padding_right="0" wrapper_bg_color="#ffffff" wrapper_bg_opacity_slider="" wrapper_bg_opacity="75" wrapper_border_top="4" wrapper_border_left="4" wrapper_border_bottom="0" wrapper_border_right="4" wrapper_border_style="double" wrapper_border_color="#172d42" wrapper_rounded_topleft="0" wrapper_rounded_topright="0" wrapper_rounded_bottomleft="0" wrapper_rounded_bottomright="0" responsive_hide="no" ]Our success rate is over 99%[/wr_heading]';
		// $builder_content = $this->shortcode_convert($test);
		// echo '<pre>$builder_content-old: '.print_r($test, TRUE).'</pre>';
		// echo '<pre>$builder_content-new: '.print_r($builder_content, TRUE).'</pre>';die();
		// return false;

		$posts = get_posts( wp_parse_args( $filter_posts, array(
			'posts_per_page' => -1,
			'post_type'        => 'any',
			'post_status' => 'any',
		)) );


		if (!$posts) {
			$this->message = 'No posts to convert !';
			return false;
		}

		foreach ($posts as $post) {
			cbt_apis::poll('Upgrading Post: '.$post->post_title);

			$classic_content = $post->post_content;
			$builder_content = get_post_meta($post->ID, '_wr_page_builder_content', true);
			$datetime = date("Y-m-d H:i:s");

			if (!trim($classic_content)
				&& !trim($builder_content)) {
				continue;
			}

			if (trim($classic_content)) {
				$classic_content = $this->shortcode_convert($classic_content);
				
				if($this->shortcode_convert_skipped === FALSE)
				{
					wp_update_post(array(
						'ID' => $post->ID,
						'post_content' => $classic_content,
						'post_modified' => $datetime, // so cache is invalidated
					));
				}
			}
			else
			{
				wp_update_post(array(
					'ID' => $post->ID,
					'post_modified' => $datetime, // so cache is invalidated
				));
			}

			if (trim($builder_content)) {
				$builder_content = $this->shortcode_convert($builder_content);

				// update post meta
				if($this->shortcode_convert_skipped === FALSE)
					update_post_meta($post->ID, '_wr_page_builder_content', $builder_content);
			}
		}

		//$this->message = 'Posts conversion completed !';
		return true;
	}

	public function convertWidgets()
	{
		cbt_apis::poll('Converting template widgets');

		$all_widgets = array();
		$sidebars = get_option('sidebars_widgets');
		foreach ($sidebars as $sidebar => $widgets) {
			$this->get_widget_data_for($sidebar, $all_widgets);
		}

		foreach ($all_widgets as $widget_type => $widgets) {
			$new_widgets = array();
			foreach ($widgets as $key => $widget) {
				cbt_apis::poll('Upgrading Widget: '.$widget_type.' -> '.$key);
				$new_widget = array();
				foreach ($widget as $data_key => $data_val) {

					// ignore nested data
					// TO-DO: Recursively handle nested data
					if (! is_string($data_val) ) {
						$new_widget[$data_key] = $data_val;
						continue;
					}

					// finally, convert content
					$data_val = $this->shortcode_convert($data_val);

					// add data to new widget
					$new_widget[$data_key] = $data_val;
				}
				$new_widgets[$key] = $new_widget;
			}

			// replace old widgets for this type with new
			update_option($widget_type, $new_widgets);
		}

		//$this->message = 'Widgets conversion completed !';
		return true;
	}

	/**
	 * Gets all widgets for a sidebar
	 * @param  string $sidebar_id wp sidebar slug
	 * @param  array  &$output    static output, results are appended
	 * @return array             results appended to given output array
	 */
	function get_widget_data_for($sidebar_id, &$output = array()) {
		global $wp_registered_sidebars, $wp_registered_widgets;

		// Holds the final data to return
		//$output = array();

		if (!$sidebar_id) {
			// There is no sidebar registered with the name provided.
			return $output;
		}

		// A nested array in the format $sidebar_id => array( 'widget_id-1', 'widget_id-2' ... );
		$sidebars_widgets = wp_get_sidebars_widgets();
		$widget_ids = $sidebars_widgets[$sidebar_id];

		if (!$widget_ids) {
			// Without proper widget_ids we can't continue.
			return array();
		}

		// Loop over each widget_id so we can fetch the data out of the wp_options table.
		foreach ($widget_ids as $id) {
			// The name of the option in the database is the name of the widget class.
			$option_name = $wp_registered_widgets[$id]['callback'][0]->option_name;

			// Widget data is stored as an associative array. To get the right data we need to get the right key which is stored in $wp_registered_widgets
			$key = $wp_registered_widgets[$id]['params'][0]['number'];
			$widget_data = get_option($option_name);

			// Add the widget data on to the end of the output array.
			$output[$option_name][$key] = $widget_data[$key];
		}

		return $output;
	}

	/**
	 * Replaces old shortcode prefix with new
	 * @param  string $content post content
	 * @return string          processed content
	 */
	public function shortcode_convert($content) {
		$this->shortcode_convert_skipped = false;
		//echo '<pre>before: '.print_r($content, TRUE).'</pre>';
		
		// no old shortcodes
		if (strpos($content,'[wr_') === FALSE)
		{
			$this->shortcode_convert_skipped = true;
			return $content;
		}

		$content = str_replace('[wr_', '[st_', $content);
		$content = str_replace('[/wr_', '[/st_', $content);
		$content = self::shortcode_reduction($content);
		//echo '<pre>after: '.print_r($content, TRUE).'</pre>';

		return $content;
	}

	/**
	 * Sends each shortcode for processing for removal of default values
	 * @param  string $content post content with current prefix
	 * @return string          processed content
	 */
	public static function shortcode_reduction($content) {

		// wrap alone text
		ST_Pb_Helper_Shortcode::$pattern = ST_Pb_Helper_Shortcode::shortcodes_pattern();

		$pattern = ST_Pb_Helper_Shortcode::$pattern;

		return preg_replace_callback(ST_Pb_Helper_Shortcode::$pattern, array('self', '_do_each_shortcode'), $content);
	}

	/**
	 * Splits shortcode to name, params, content etc
	 * and sends for modification
	 * @param  array $m shortcode data in index array
	 * @return string    modified shortcode from _modify_shortcode method
	 */
	public static function _do_each_shortcode($m) {

		// allow [[foo]] syntax for escaping a tag
		if ($m[1] == '[' && $m[6] == ']') {
			return substr($m[0], 1, -1);
		}

		$tag = $m[2];
		$content = isset($m[5]) ? trim($m[5]) : '';

		return call_user_func(array('self', '_modify_shortcode'), $tag, $content, $m[0], $m[3]);
	}

	/**
	 * Modifies a shortcode by removing its default valyes
	 * @param  string $shortcode_name   shortcode's name without brackets
	 * @param  string $content          shortcode's content i.e between [example]CONTENT[/example]
	 * @param  string $shortcode_data   unprocessed shortcode data including content
	 * @param  string $shortcode_params shortcode params in quoted string
	 * @return string                   shortcode without default values
	 */
	public static function _modify_shortcode($shortcode_name, $content = '', $shortcode_data = '', $shortcode_params = '') {
		// get shortcode's class
		$class = ST_Pb_Helper_Shortcode::get_shortcode_class($shortcode_name);


		if (class_exists($class)) {
			// initiate default element
			global $St_Pb;
			$rebuilt_shortcode = false;
			$elements = $St_Pb->get_elements();
			$instance = isset($elements['element'][strtolower($class)]) ? $elements['element'][strtolower($class)] : null;
			if (!is_object($instance)) {
				$instance = new $class();
			}
			$instance->init_element();

			// convert subrows to nested rows
			if($instance->config['shortcode'] == 'st_row') {
				// if sub rows exist
				if (preg_match('/(\[st_subrow.*)/si', $content, $sub_rows)) {
					// echo '<pre>_modify_shortcode $instance: '.print_r($instance->config['shortcode'], TRUE).'</pre>';
					// echo '<pre>$content before: '.print_r($content, TRUE).'</pre>';
					// remove them from the content
					$content_new = preg_replace('/(\[st_subrow.*)/si', '', $content);

					// add them to their own variable
					$sub_rows_html = $sub_rows[0];
					// replace shortcode
					$sub_rows_html = str_replace('st_subrow', 'st_row_3', $sub_rows_html);
					$sub_rows_html = str_replace('st_column', 'st_column_3', $sub_rows_html);
					// put inside new row's column
					$sub_rows_html = '[st_row_2][st_column_2]'. $sub_rows_html .'[/st_column_2][/st_row_2]';
					// put exiting content inside another new row's column
					// our final structure is row with 2 rows inside, 1st having existing content 2nd having subrows
					$content_new = str_replace('st_column', 'st_column_2', $content_new);
					$content_new = '[st_column][st_row_2]'.$content_new .'[/st_row_2]'. $sub_rows_html .'[/st_column]';
					$content = $content_new;

					// echo '<pre>$content_new after: '.print_r($content_new, TRUE).'</pre>';
				}
			}

			// make array from current params
			$current_params = shortcode_parse_atts($shortcode_params);
			$new_params = $current_params;

			// check if default params exist
			if (!empty($current_params) 
				&& isset($instance->config)
				&& isset($instance->config['params'])
				&& !empty($instance->config['params'])) {

				$default_params = $instance->config['params'];
				//echo '<pre>default: '.print_r($default_params, TRUE).'</pre>';
				//echo '<pre>'.print_r('heree', TRUE).'</pre>';

				// re-map changed params
				$current_params = self::convert_old_params($current_params);

				// remove defaults
				$new_params = self::remove_defaults($current_params, $default_params);
				
				$rebuilt_shortcode = true;
			}

			// for child shortcodes
			if(preg_match('/\[st_/', $content))
			{
				$rebuilt_shortcode = true;
				$content = self::shortcode_reduction($content);
			}

			if($rebuilt_shortcode)
			{
				// make shortcode structure with new params and content
				$shortcode_data = ST_Pb_Helper_Shortcode::generate_shortcode_structure($shortcode_name, $new_params, $content);
			}

		}

		return $shortcode_data;
	}

	/**
	 * Remap old params to their new equivalent
	 * @param  array $current_params
	 * @return array                 remapped params
	 */
	public static function convert_old_params($current_params) {
		// $did = false;
		$new_params = $current_params;
		foreach ($current_params as $key => $val) {
			// if remap available
			if (isset(self::$remap[$key])) {
				unset($new_params[$key]); // remove old
				$new_params[ self::$remap[$key] ] = $val; // add new
				// $did = true;
			}
		}

		// if($did)
		// {
		// 	echo '<pre>old params: '.print_r($current_params, TRUE).'</pre>';
		// 	echo '<pre>new params: '.print_r($new_params, TRUE).'</pre>';
		// }

		return $new_params;
	}

	/**
	 * Compares current and default params and removes identifical ones
	 * @param  array $current_params
	 * @param  array $default_params
	 * @return array                 params without default ones
	 */
	public static function remove_defaults($current_params, $default_params) {
		$new_params = $current_params;
		foreach ($current_params as $key => $val) {
			// remove param is it exists with same value in defaults
			if (isset($default_params[$key])
				&& $val == $default_params[$key]) {
				unset($new_params[$key]);
			}
		}

		return $new_params;
	}

}