<?php
/**
 * @version    $Id$
 * @package    ProStyler Builder
 * @author     WooRockets Team <support@www.woorockets.com>
 * @copyright  Copyright (C) 2012 www.woorockets.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.www.woorockets.com
 * Technical Support:  Feedback - http://www.www.woorockets.com
 *
 */

/**
 * @todo : Modal box content
 */

if ( ! isset( $_POST ) ) {
	die;
}

if(isset($_GET['st_frontend_edit-bk']))
{
	//echo '<pre>'.print_r($_POST, TRUE).'</pre>';
	$data = json_decode( stripslashes( $_POST['json'] ) );
	$_POST['shortcode'] = $data->shortcode;
	$_POST['params'] = $data;
	$_POST['el_type'] = 'element';
	$_POST['el_title'] = $data->el_title;
}

extract( $_POST );
$submodal = ! empty( $submodal ) ? 'submodal_frame' : '';
if ( ! isset( $params ) ) {
	exit;
}

if ( ! empty( $shortcode ) ) {
	$script     = '';
	if ( isset( $init_tab ) && $init_tab == 'styling' ) {
		// Auto move to Styling tab if previous action
		// is coping style from other element.
		$script .= "
			(function ($) {
				$(document).ready(function (){
					setTimeout(function (){
						$('[href=\"#styling\"]').click();
					}, 500);

				});
			})(jQuery);";
	}

	if ($_REQUEST['form_only']) {
		$script .=  " var st_pb_modal_ajax = true;";
	}

	ST_Pb_Init_Assets::print_inline( 'js', $script, true );
	?>

<div
	id="st-element-<?php echo esc_attr( ST_Pb_Helper_Shortcode::shortcode_name( $shortcode ) ); ?>">
	<div class="st-pb-form-container jsn-bootstrap3">
		<div id="modalOptions"
			class="form <?php echo esc_attr( $submodal ); ?>">
			<?php
			if ( ! empty( $params ) ) {
				$params = stripslashes( $params );
				$params = urldecode( $params );
			}
			// elements
			if ( $el_type == 'element' ) {

				echo ST_Pb_Objects_Modal::shortcode_modal_settings( $shortcode, $params, isset( $el_title ) ? $el_title : '' );

				?>
			<form id="frm_shortcode_settings" action="" method="post">
			<?php
			// Render the inputs to store element setting data for Copy style feature
			foreach ( $_POST as $k => $v ) {
				echo '<input type="hidden" id="hid-' . $k .  '" name="' . $k . '" value="' . urlencode( $v ) . '" />';
			}
			echo '<input type="hidden" id="hid-init_tab" name="init_tab" value="styling" />';
			?>
			</form>
			<?php
			}
			// widgets
			else if ( $el_type == 'widget' ) {
				$instance          = ST_Pb_Helper_Shortcode::extract_widget_params( $params );
				$instance['title'] = isset( $instance['title'] ) ? $instance['title'] : $el_title;
				
				
				// ------------------------------------------------------
				//  YUNUS EDIT
				// ------------------------------------------------------
				$instance_raw = $instance;
				foreach($instance_raw as $key=>$val)
				{
					$instance[ $key ] = stripslashes($val);
				}

				// generate setting form of widget
				$widget = new $shortcode();
				ob_start();
				$widget->form( $instance );
				$form = ob_get_clean();

				// simplify widget field name
				$exp  = preg_quote( $widget->get_field_name( '____' ) );
				$exp  = str_replace( '____', '(.*? )', $exp );
				$form = preg_replace( '/' . $exp . '/', '$1', $form );

				// simplify widget field id
				$exp  = preg_quote( $widget->get_field_id( '____' ) );
				$exp  = str_replace( '____', '(.*? )', $exp );
				$form = preg_replace( '/' . $exp . '/', '$1', $form );

				// tab and content generate
				$tabs = array();
				foreach ( array( 'content' ) as $i => $tab ) {
					$active               = ( $i ++ == 0 ) ? 'active' : '';
					$data_['href']        = "#$tab";
					$data_['data-toggle'] = 'tab';
					$content_             = ucfirst( $tab );
					$tabs[]               = "<li class='$active'>" . ST_Pb_Objects_Modal::tab_settings( 'a', $data_, $content_ ) . '</li>';
				}

				// content
				$contents   = array();
				$contents[] = "<div class='tab-pane active' id='content'><form id='st-widget-form'>$form</form></div>";

				$output = ST_Pb_Objects_Modal::setting_tab_html( $shortcode, $tabs, $contents, array(), '', array() );

				echo balanceTags( $output );
			}
			?>
			<div id="modalAction" class="st-pb-setting-tab"></div>
		</div>
		<textarea class="hidden" id="shortcode_content">
		<?php echo esc_attr( $params ); ?>
		</textarea>
		<textarea class="hidden" id="st_share_data"></textarea>
		<textarea class="hidden" id="st_merge_data"></textarea>
		<textarea class="hidden" id="st_extract_data"></textarea>
		<input type="hidden" id="st_previewing" value="0" />
		<input id="shortcode_type" type="hidden" value="<?php echo esc_attr( $el_type ); ?>" />
		<input id="shortcode_name" type="hidden" value="<?php echo esc_attr( esc_sql( $_GET['st_modal_type'] ) ); ?>" />



		<?php
		// append custom assets/HTML for specific shortcode here
		do_action( 'st_pb_modal_footer', $shortcode ); ?>
	</div>
</div>
<?php
}