<?php


global $post, $cbt_pro;

wp_nonce_field( 'st_builder', ST_NONCE . '_builder' );

?>


<div id="st-pbd-loading" class="page_preloader text-center" title="<?php _e('Loading...', ST_PBL) ?>">
	<?php
		if(class_exists('cbt_pro') && isset($cbt_pro) && $cbt_pro->is_unbranded)
		{
			echo '<i class="jsn-icon32 jsn-icon-loading"></i>';
		}
		elseif(function_exists('cbt_logo_icon'))
		{
			cbt_logo_icon(true, 'st_logo_loading'); // true for echo
		}
	?>

	<script type="text/javascript">
	var st_save_url = "<?php echo admin_url('post.php'); ?>";
	jQuery('#st-pbd-loading').css({
		'visibility':'visible',
		'opacity':'1',
		'transition-delay': '0s'
	});
	jQuery(function($) {

		$(window).load(function()
		{
			setTimeout(function()
			{
				jQuery('#st-pbd-loading').css({
					'visibility':'hidden',
					'opacity':'0',
					'transition-delay': ''
				});
				// builder preloader
				setTimeout(function()
				{
					$('#st-pbd-loading').removeClass('page_preloader');
				}, 300);
			}, 500);
		});


	});
	</script>
</div>

<!-- Buttons bar -->
<div
	class="jsn-form-bar">


	<!-- Page Templates -->
	<div class="pull-left" id="top-btn-actions">
		<div class="pull-left" id="page-custom-css">
			<button class="btn btn-default" onclick="return false;">
			<?php _e( 'Custom CSS', ST_PBL ) ?>
			</button>
		</div>
		<div class="btn-group dropdown pull-left" id="page-template">
			<a class="btn btn-default dropdown-toggle st-dropdown-toggle"
				href="#"> <?php _e( 'Page presets', ST_PBL ) ?> <span class="caret"></span>
			</a>
			<ul class="dropdown-menu pull-right">
				<li><a href="#" id="save-as-new" class="st-modal-toggle"><?php _e( 'Save as new preset', ST_PBL ); ?>
				</a></li>
				<li><a id="apply-page" href="#"><?php _e( 'Load preset', ST_PBL ); ?>
				</a></li>
			</ul>
		</div>
		<div class="pull-left" id="cbb-empty-builder">
			<a class="btn btn-default" href="#">
				<?php _e( 'Delete all content', ST_PBL ) ?>
			</a>
		</div>
	</div>
	
	<?php
	global $typenow;	
	
	switch($typenow)
	{
		case 'page':
			$save_btn = 'Save Page';
		break;
		case 'post':
			$save_btn = 'Save Post';
		break;
		default:
			$save_btn = 'Save';
		break;
	}
	?>
	
	<div class="pull-right cbb-builder-save-wrapper">
			<button id="cbb-builder-save" class="btn btn-primary" onclick="return false;">
			<?php echo $save_btn; ?>
			</button>
	</div>

	<!-- Save as new template modal -->
	<div id="save-as-new-dialog" role="dialog" aria-hidden="true"
		tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header ui-dialog-title">
					<h3>
					<?php _e( 'Save as new preset', ST_PBL ); ?>
					</h3>
				</div>
				<div class="modal-body form-horizontal">
					<div class="form-group">
						<label class="control-label" for="template-name"><?php _e( 'Preset name:' );?>
						</label>
						<div class="controls">
							<input type="text" id="template-name" class="input form-control">
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<a href="#" class="btn btn-primary template-save"><?php _e( 'Save', ST_PBL ); ?>
					</a> <a href="#" class="btn template-cancel"><?php _e( 'Cancel', ST_PBL ); ?>
					</a>
				</div>
			</div>
		</div>
	</div>
	<!-- END Save as new template modal -->
	
	<!-- YUNUS EDIT -->
	<div class="clearfix"></div>
	
</div>

<!-- ProStyler Builder elements -->
<div class="jsn-section-content jsn-style-light"
	id="form-design-content">

	<div class="st-pb-form-container jsn-layout cbb-sortable-container" style="opacity: 0;">
	<?php if ( @count( $converters ) ) : ?>
		<?php foreach ( $converters as $id => $name ) : ?>
		<!-- Data conversion dialog -->
		<div class="data-conversion-dialog" data-target="<?php echo esc_attr( $id ); ?>">
			<div class="alert alert-warning">
				<i class="icon-warning"></i>
				&nbsp;&nbsp;&nbsp;
				<span class="message">
				<?php
				// Get current post type's singular_name
				$post_type = get_post_type_object( get_post_type() );
				$post_type = strtolower( $post_type->labels->singular_name );

				printf(
					__(
						'Your current %1$s has been built by using <strong>%2$s</strong>. Would you like to convert all data to <strong>ProStyler Builder</strong>?',
						ST_PBL
					),
					$post_type,
					$name
				);
				?>
				</span>
			</div>
			<div class="action">
				<div class="text-center">
					<label>
						<input type="checkbox" name="backup_data" value="1" checked="checked" />
						<?php printf( __( 'I also want to backup all data as a new %s', ST_PBL ), $post_type ); ?>
					</label>
				</div>
				<div class="text-center">
					<button class="btn btn-success col-xs-3 center-block" data-action="convert-only">
						<span data-working-text="<?php _e( 'Converting Data...', ST_PBL ); ?>">
							<?php _e( 'Convert' ); ?>
						</span>
					</button>
					<?php _e( 'or', ST_PBL ); ?>
					<button class="btn btn-link" data-action="convert-and-publish">
						<span data-working-text="<?php _e( 'Converting Data...', ST_PBL ); ?>">
							<?php _e( 'Convert and Publish' ); ?>
						</span>
					</button>
				</div>
			</div>
		</div>
		<?php endforeach; ?>
	<?php
	else :

		$pagebuilder_content = get_post_meta( $post->ID, '_wr_page_builder_content', true );
	
		if ( ! empty( $pagebuilder_content ) ) :
			$builder = new ST_Pb_Helper_Shortcode();
			echo balanceTags( $builder->do_shortcode_admin( $pagebuilder_content ) );
		endif;

	endif; 
	?>
	</div>
	<?php if ( ! @count( $converters ) ) : ?>
<!-- 		<div id="st-add-element-btn-container" class="st-main-btn">
			<a href="javascript:void(0);" class="st-more-element">
				<span class="st-add-element-btn"><i class="fa fa-plus" aria-hidden="true"></i></span>
				<span class="st-add-element-text"><?php _e( 'Insert Element', ST_PBL ) ?></span>
			</a>
		</div> -->

		<div id="jsn-add-container" class="st-main-btn">
			<a href="javascript:void(0);" class="jsn-add-more">
				<span class="st-add-element-btn"><i class="st-icon-add-row" aria-hidden="true"></i></span>
				<span class="st-add-element-text"><?php _e( 'Insert Row', ST_PBL ) ?></span>

				<?php
				// Default layouts
				include ST_PB_TPL_PATH . '/default-layouts.php';
				?>
			</a>
		</div>

		<input type="hidden" id="st-select-media" value="" />
	<?php endif; ?>
	<div id="deactivate-msg" class="jsn-section-empty hidden">
		<p class="jsn-bglabel">
			<span class="jsn-icon64 jsn-icon-remove"></span>
			<?php _e( 'PageBuilder for this page is currently off.', ST_PBL ); ?>
		</p>
		<p class="jsn-bglabel">
			<a href="javascript:void(0)" class="btn btn-success"
				id="status-on-link"><?php _e( 'Turn PageBuilder on', ST_PBL )?> </a>
		</p>

	</div>
	
	<!-- Link to website -->
	<div id="branding">
		<div class="pull-left text-muted">Works best on <a target="_blank" href="https://www.google.co.uk/chrome/browser/desktop/">Google Chrome</a></div>

		<div class="pull-right">
		<?php
			if(class_exists('cbt_pro') && isset($cbt_pro) && $cbt_pro->is_unbranded)
			{

			}
			elseif(function_exists('cbt_logo_icon'))
			{
?>
			<div>
				<?php
					$plugin = get_plugin_data(ST_PB_FILE);
					//echo '<pre>'.print_r($plugin, TRUE).'</pre>';
				?>
				<a href="<?php echo $plugin['PluginURI'] ?>" target="_blank"><?php echo $plugin['Name'] ?></a> 
				<?php _e( 'by', ST_PBL )?>
				<a href="<?php echo $plugin['AuthorURI'] ?>" target="_blank"><?php echo $plugin['AuthorName'] ?></a>
			</div>
<?php
			}
		?>
		</div>
		<div class="clearbreak"></div>
	</div>
	
</div>



			<?php

			// Page Template
			include 'layout/template.php';

			// Insert Post ID as hidden field
			$post_id = isset ( $_GET['post'] ) ? $_GET['post'] : ( isset ( $post->ID ) ? $post->ID : '' );
			?>
<div id="st-pb-css-value">
	<input type="hidden" name="st_pb_post_id" value="<?php echo esc_attr( $post_id ); ?>">
</div>

<div class="cbb-panel st-dialog">
	<div class="cbb-p-topbar">
		<div class="cbb-p-title">
			
		</div>
		<div class="cbb-p-buttons"></div>
	</div>

	<div class="cbb-p-content">

	</div>
</div>


<div id="st_dummy_editor" style="display: none;">
    <?php wp_editor('', 'st_dummy_editor_id', array('wpautop' => true)); ?>
    
	<script type="text/javascript">
	/* save config object as json string in a global var - in my case st_tinyMCEPreInit  */
	jQuery(document).ready(function(e) {
	    if(typeof( st_tinyMCEPreInit ) == 'undefined') {
	        st_tinyMCEPreInit = JSON.stringify(tinyMCEPreInit);
	    }
	});
	</script>
</div>

<div class="cbb-preview"></div>

<script type="text/html" id="tmpl-cbb-preview-template">
<?php echo ST_Pb_Helper_Html_Preview::render(); ?>
</script>

<!--[if IE]>
<style>
	.jsn-quicksearch-field{
		height: 28px;
	}
</style>
<![endif]-->
