<?php

/**
 * @todo : Popover to select Element
 */

global $St_Pb, $St_Pb_Shortcodes, $St_Sc_By_Providers_Name;

// Arrray of element objects
$elements = $St_Pb->get_elements();

if (empty($elements) || empty($elements['element'])) {
	_e('You have not install Free or Pro Shortcode package.');
} else {
	$elements_html = array(
		__('Basic', ST_PBL) => array(),
		__('Content', ST_PBL) => array(),
		__('Media', ST_PBL) => array(),
	); // HTML button of a shortcode
	$categories = array(); // array of shortcode category

	// add st row to elements list
	$elements = array_merge(array('st_row' => $elements['layout']['st_row']), $elements['element']);

	foreach ($elements as $element) {
		// don't show sub-shortcode
		if (!isset($element->config['name'])) {
			continue;
		}

		// get shortcode category
		$category = ''; // category name of this shortcode
		$group_categories = $element->config['cat'] | '';

		if (!empty($St_Pb_Shortcodes[$element->config['shortcode']])) {
			//$category_name = $St_Pb_Shortcodes[ $element->config['shortcode'] ]['provider']['name'] | '';
			$category_name = __('Standard Elements', ST_PBL);
			$category = strtolower(str_replace(' ', '', $category_name));
			if (!array_key_exists($category, $categories)) {
				$categories[$category] = $category_name;
			}

		}

		$group_categories = explode(',', $group_categories);
		foreach ($group_categories as $group_category) {
			$elements_html[$group_category][$element->config['name']] = $element->element_button($category);
		}

	}
	?>
<div id="st-add-element" class="st-add-element add-field-dialog jsn-bootstrap3"
	style="display: none;">
	<div class="popover" style="display: block;">
		<h3 class="popover-title">
		<?php _e('Select Element', ST_PBL);?>
		</h3>
		<a type="button" class="close st-popover-close">&times;</a>
		<div class="popover-content">
			<div class="jsn-elementselector">
				<div class="jsn-fieldset-filter">
					<fieldset>
						<div class="pull-left">
							<select id="jsn_filter_element"
								class="jsn-filter-button input-large">

								<?php
// yunus edit - removed Page Elements optgroup and All Element option as they were sane as Standard Elements
	/*
									<optgroup label="<?php _e( 'Page Elements', ST_PBL ) ?>">
								*/

	// Reorder the Categories of Elements
	$categories_order = array();
	//$categories_order['all'] = __( 'All Elements', ST_PBL );

	// add Standard Elements as second option
	$standard_el = __('Standard Elements', ST_PBL);
	$key = array_search($standard_el, $categories);
	$categories_order[$key] = $standard_el;

	unset($key);

	// Sort other options by alphabetical order
	asort($categories);
	$categories_order = array_merge($categories_order, $categories);

	foreach ($categories_order as $category => $name) {
		$selected = ($name == __('Standard Elements', ST_PBL)) ? 'selected' : '';
		printf('<option value="%s" %s>%s</option>', esc_attr($category), $selected, esc_html($name));
	}

	/* </optgroup> */
	?>

								<option value="widget">
								<?php _e('Widgets', ST_PBL)?>
								</option>
								<option value="shortcode">
								<?php _e('Paste Shortcode', ST_PBL)?>
								</option>
							</select>
						</div>
						<div class="pull-right jsn-quick-search" role="search">
							<input type="text"
								class="input form-control jsn-quicksearch-field"
								placeholder="<?php _e('Search', ST_PBL);?>..."> <a
								href="javascript:void(0);"
								title="<?php _e('Clear Search', ST_PBL);?>"
								class="jsn-reset-search" id="reset-search-btn"><i
								class="icon-remove"></i> </a>
						</div>
					</fieldset>
				</div>
				<!-- Elements -->
				<ul class="jsn-items-list">
				<?php
// shortcode elements
	foreach ($elements_html as $cat => $elements_html_items) {
		asort($elements_html_items);

		if (trim($cat)) {
			echo '<li class="jsn-items-cat">' . $cat . '</li>';
		}

		foreach ($elements_html_items as $idx => $element) {
			echo balanceTags($element);
		}
	}

	// widgets
	global $St_Pb_Widgets;
	foreach ($St_Pb_Widgets as $wg_class => $config) {
		$extra_ = $config['extra_'];
		$config['edit_using_ajax'] = true;

		// ------------------------------------------------------
		//  YUNUS EDIT - Do not show newsletter widget in the list
		// ------------------------------------------------------
		if ($wg_class == 'widget_newsletter') {
			continue;
		}

		echo balanceTags(ST_Pb_Shortcode_Element::el_button($extra_, $config));
	}
	?>
					<!-- Generate text area to add element from raw shortcode -->
					<li class="jsn-item full-width" data-value='raw'
						data-sort='shortcode'><textarea id="raw_shortcode"></textarea>

						<div class="text-center rawshortcode-container">
							<button class="shortcode-item btn btn-success"
								data-shortcode="raw" id="rawshortcode-add">
								<?php _e('Add Element', ST_PBL);?>
							</button>
						</div>
					</li>
				</ul>
				<p style="text-align: center">
				<?php // echo esc_html( __( 'Want to add more elements?', ST_PBL ) ); ?>
					&nbsp;<!--a target="_blank"
						href="<?php //echo esc_url( admin_url( 'admin.php?page=st-pb-addons' ) ); ?>"><?php //echo esc_html( __( 'Check add-ons.', ST_PBL ) ); ?>
					</a-->
				</p>
			</div>
		</div>
	</div>
</div>

<?php
}