<?php


/**
 * @todo : ProStyler Builder Settings page
 */
?>
<div class="wrap">

	<h2>
	<?php esc_html_e( 'ProStyler Builder Settings', ST_PBL ); ?>
	</h2>

	<?php
	// Show message when save
	$saved = ( isset ( $_GET ) && isset($_GET['settings-updated']) && $_GET['settings-updated'] == 'true' ) ? __( 'Settings saved.', ST_PBL ) : __( 'Settings saved.', ST_PBL );

	$msg = $type = '';
	if ( isset ( $_GET['settings-updated'] ) && $_GET['settings-updated'] == 'true' ) {
		$msg  = __( 'Settings saved.', ST_PBL );
		$type = 'updated';
	} else {
		if ( isset($_GET['settings-updated']) && $_GET['settings-updated'] != 'true' ) {
			$msg  = __( 'Settings is not saved.', ST_PBL );
			$type = 'error';
		}
	}

	if ( isset ( $_GET['settings-updated'] ) ) {
		?>
	<div id="setting-error-settings_updated"
		class="<?php echo esc_attr( $type ); ?> settings-error">
		<p>
			<strong><?php echo esc_html( $msg ); ?> </strong>
		</p>
	</div>
	<?php
	}

	// ------------------------------------------------------
	//  yunus edit - removed 'st_pb_settings_cache', 
	// ------------------------------------------------------
	$options = array( 'st_pb_settings_cache', 'st_pb_settings_boostrap_js', 'st_pb_settings_boostrap_css' );
	// submit handle
	if ( ! empty ( $_POST ) ) {
		foreach ( $options as $key ) {
			$value = ! empty( $_POST[$key] ) ? 'enable' : 'disable';
			update_option( $key, $value );
		}

		unset( $_POST );
		ST_Pb_Helper_Functions::alert_msg( array( 'success', __( 'Your settings are saved successfully', ST_PBL ) ) );
	}
	// get saved options value
	foreach ( $options as $key ) {
		$$key = get_option( $key, 'enable' );
	}

	// show options form
	?>
	<form method="POST" action="options.php">
	<?php
	$page = 'st-pb-settings';
	settings_fields( $page );
	do_settings_sections( $page );
	submit_button();
	?>
	</form>
</div>

	<?php
	// Load inline script initialization
	$script = '
		new ST_Pb_Settings({
			ajaxurl: "' . admin_url( 'admin-ajax.php' ) . '",
			_nonce: "' . wp_create_nonce( ST_NONCE ) . '",
			button: "st-pb-clear-cache",
			loading: "#st-pb-clear-cache .layout-loading",
			message: $("#st-pb-clear-cache").parent().find(".layout-message"),
		});
        ';

ST_Pb_Init_Assets::inline( 'js', $script );

	// Load inlide style
	$loading_img = ST_PB_URI . '/assets/main/images/icons-16/icon-16-loading-circle.gif';
	$style = '
		.jsn-bootstrap3 { margin-top: 30px; }
        .jsn-bootstrap3 .checkbox { background:#fff; }
        #st-pb-clear-cache, .layout-message { margin-left: 6px; }
        .jsn-icon-loading { background: url("' . $loading_img . '") no-repeat scroll left center; content: " "; display: none; height: 16px; width: 16px; float: right; margin-left: 20px; margin-top: -26px; padding-top: 10px; }
<<<<<<< Updated upstream
		.st-banner-wrapper .st-banner { float: left; line-height: 0; margin: 0px 10px 0px 10px; }
=======
		.st-banner-l a{
			text-decoration: none;
		}
		.st-banner-l img{
			margin-right: 10px;
		}
		.st-accordion { border: 1px solid #E5E5E5; margin-top: 20px; }
		.st-accordion-title { margin: 0; padding: 8px 20px; cursor: pointer; background: #C3C3C3; }
		.st-accordion-content { padding: 0; border-top: 1px solid #E5E5E5; line-height: 0; display: none; }
>>>>>>> Stashed changes
        ';
ST_Pb_Init_Assets::inline( 'css', $style );
