<?php
add_action( 'cbt_after_all_import_processes', 'cbt_after_content_import', 10, 2 );

if ( !function_exists( 'cbt_after_content_import' ) ) 
{
	function cbt_after_content_import($demo_active_import , $demo_directory_path)
	{
		global $cbt_importer;

		reset( $demo_active_import );
		$current_key = key( $demo_active_import );
		
		cbt_import_revsliders( $demo_directory_path.'revslider' );

		// CONFIG.JSON - Theme configuration
		$demo_config_file = $demo_directory_path .'config.json';
		if(file_exists($demo_config_file)) 
		{
			cbt_apis::poll('Importing template configurations');
			cbt_apply_config_json($demo_config_file);
		}

		// OLD TEMPLATE FALLBACK (depreciated)
		$demo_config_file = $demo_directory_path .'config.php';
		if(file_exists($demo_config_file)) 
		{
			cbt_apis::poll('Importing misc data (sliders etc if any)');
			include_once $demo_config_file;

			// older templates need to be upgraded
			cbt_convert_import();
		}

		cbt_after_remote_import($demo_active_import , $demo_directory_path);

		
        $cbt_importer->end_log();
        
		// force run less compiler on next page load
		update_option('cbt_do_auto_redux_compiler', 'yes');
		
		cbt_apis::poll('Imported successfully. Page will now reload, please wait..', 'success');
		cbt_apis::poll_action('reload');
	}
}

if ( !function_exists( 'cbt_import_revsliders' ) ) 
{
	function cbt_import_revsliders($sliders_dir)
	{
		if ( class_exists( 'RevSlider' ) ) 
		{
			$slider = new RevSlider();

			if(! file_exists($sliders_dir))
			{
				return false;
			}

			$dircontents = scandir($sliders_dir);

			if($dircontents) foreach ($dircontents as $file) 
			{
				$extension = pathinfo($file, PATHINFO_EXTENSION);
				if ($extension != 'zip') continue;
				
				$file = $sliders_dir.'/'.$file;
				$slider->importSliderFromPost( true, true, $file );
			}
			
		}
	}
}

if ( !function_exists( 'cbt_apply_config_json' ) ) 
{
	function cbt_apply_config_json($file_or_data, $backup = true)
	{
		global $cbt_importer;


		// if direct data provided
		if(is_object($file_or_data))
		{
			$config = $file_or_data;
		}
		else // if path to json file
		{
			// Get file contents
			$config = file_get_contents($file_or_data);

	        if(! $config)
	            return false;

	        $config = json_decode($config);
	        if(! is_object($config) OR empty($config))
	        {
	            return false;
	        }

	        $config = (ARRAY) $config;
	    }

        if(! $config)
            return false;


        if($backup)
        	$cbt_importer->backup_config( $config ); // send new config to compare and only backup new options

        foreach($config as $key=>$val)
        {
            switch($key)
            {
                case 'nav_menu_locations':
                    if($val && is_object($val))
                    {
                        $nav_menu_locations = array();
                        foreach($val as $menu_location=>$menu_location_val)
                        {
                            $term = get_term_by( 'name', $menu_location_val, 'nav_menu' );
                            if($term)
                            {
                                $nav_menu_locations[ $menu_location ] = $term->term_id;
                            }
                        }

                        $locations_from_dp = get_theme_mod('nav_menu_locations');
                        if(! $locations_from_dp) $locations_from_dp = array();
                        $nav_menu_locations = array_merge($locations_from_dp, $nav_menu_locations);
                        set_theme_mod('nav_menu_locations', $nav_menu_locations);
                    }
                break;

                case 'page_on_front':
                case 'page_for_posts':
                    if($val && ! is_integer($val))
                    {
                        $val = st_get_id_from_GUID( $val );
                        if(! $val)
                        	break;
                    }


                case 'show_on_front':
                    // echo '<pre>'.$key.': '.print_r($val, TRUE).'</pre>';
                    update_option($key, $val);
                break;
            }
        }

        return true;
	}
}

if ( !function_exists( 'cbt_convert_import' ) ) 
{
	function cbt_convert_import()
	{
		global $cbt_importer;

		$posts_filter = array();
		if(isset($cbt_importer->wordpress_data) 
			&& isset($cbt_importer->wordpress_data['user_id'])
			&& trim($cbt_importer->wordpress_data['user_id']))
		{
			$posts_filter['author'] = $cbt_importer->wordpress_data['user_id'];
		}

		cbt_apis::poll('Upgrading content to ProStyler Rev');
		$upgrader = new CBB_upgrader();

		if($upgrader->start($posts_filter) === false)
		{
			//cbt_apis::poll('Content upgrade failed');
		}
		else
		{
			cbt_apis::poll('Content upgraded');
		}
	}
}


if ( !function_exists( 'cbt_after_remote_import' ) ) 
{
	function cbt_after_remote_import($demo_active_import , $demo_directory_path)
	{
		$folder = basename($demo_directory_path);

		// check if its remote import, if not then skip
		//if(! preg_match('/^remote_import_/i', $folder)) return;

		global $wp_filesystem;
		
		// delete folder of remote import
		$wp_filesystem->rmdir($demo_directory_path, true);
		
	}
}


class cbt_importer
{
	public $import_id;
	public $template_folder;
	public $wordpress_data;
	public $theme_options_backup;
	public $config_backup;
	public $importer_dir;

	function __construct()
	{
		add_action('wp_ajax_cbt_uninstall_demo', array($this, 'uninstall_demo'));
		add_action('admin_print_footer_scripts', array($this, 'imported_demos'));
		add_filter('wbc_importer_dir_path', array($this, 'importer_dir_path'), 10, 1);
		add_action( 'after_setup_theme', array($this, 'setup_importer'), 17 );
		
		$wp_uploads_dir = wp_upload_dir();
		
		$dir = $wp_uploads_dir['basedir'].'/cbt_importer/';
		$url = $wp_uploads_dir['baseurl'].'/cbt_importer/';
		$this->importer_dir = $dir;
		$this->importer_url = $url;

		//add_action( 'admin_init', array($this, 'test'));
	}

	// public function test()
	// {
	// 	$id = 'wbc-import-cbt-template_760';
	// 	$this->set_data($id);
	// 	echo '<pre>$this->wordpress_data: '.print_r($this->wordpress_data, TRUE).'</pre>';

	// 	$sidebars = get_option( 'sidebars_widgets' );
	// 	echo '<pre>$sidebars before: '.print_r($sidebars, TRUE).'</pre>';
	// 	foreach($this->wordpress_data['widgets'] as $sidebar_id=>$widgets)
	// 	{
	// 		if(empty($widgets)) continue;
			
	// 		foreach($widgets as $id)
	// 		{
	// 			if(($key = array_search($id, $sidebars[$sidebar_id])) !== false) {
	// 			    unset($sidebars[$sidebar_id][$key]);
	// 			}
	// 		}
	// 	}
	// 	echo '<pre>$sidebars after: '.print_r($sidebars, TRUE).'</pre>';
	// }
	
	function setup_importer()
	{
		@mkdir($this->importer_dir);
	}
	
	
	function importer_dir_path($default_dir='')
	{
		if(! file_exists($this->importer_dir))
		{
			$this->setup_importer();
		}
		
		return $this->importer_dir;
	}
	
	
	function set_import_id($id)
	{
		$this->import_id = $id;
		$this->set_data($id);
	}

	function set_template_folder($folder)
	{
		$this->template_folder = $folder;
	    $this->template_folder_path = $this->importer_dir . $this->template_folder;
	    $this->template_folder_url = $this->importer_url . $this->template_folder;
	}
	
	function get_data($id)
	{
		return array(
			'wordpress_data'=>get_option('importer_'.$id.'-wordpress_data'),
			'theme_options_backup'=>get_option('importer_'.$id.'-theme_options_backup'),
			'config_backup'=>get_option('importer_'.$id.'-config_backup')
		);
	}
	
	// ------------------------------------------------------
	//  Get logs from database and store to properties
	// ------------------------------------------------------
	function set_data($id)
	{
		$data = $this->get_data($id);
		foreach($data as $key=>$val)
		{
			$this->{$key} = $val;
		}
	}
	
	// ------------------------------------------------------
	//  Add posts to log property
	// ------------------------------------------------------
	function log_userid($id)
	{
		$this->wordpress_data['user_id'] = $id;
	}
	
	// ------------------------------------------------------
	//  Add terms to log property
	// ------------------------------------------------------
	function log_term($id, $tax='category')
	{
		if(isset($this->wordpress_data['terms'][$tax][$id])) return;
		
		$this->wordpress_data['terms'][$tax][] = $id;
	}
	
	// ------------------------------------------------------
	//  Add posts to log property
	// ------------------------------------------------------
	function log_widget($sidebar_id, $widget_id)
	{
		if(isset($this->wordpress_data['widgets'][$sidebar_id][$widget_id])) return;
		
		$this->wordpress_data['widgets'][$sidebar_id][] = $widget_id;
	}
	
	
	// ------------------------------------------------------
	//  Add terms to log property
	// ------------------------------------------------------
	function log_revslider($id)
	{
		if(isset($this->wordpress_data['revslider'][$id])) return;
		
		$this->wordpress_data['terms'][] = $id;
	}
	
	
	// ------------------------------------------------------
	//  Store all logs to database
	// ------------------------------------------------------
	function end_log()
	{
		//echo '<pre>'.print_r($this->wordpress_data, TRUE).'</pre>';
		
		update_option('importer_'.$this->import_id.'-wordpress_data', $this->wordpress_data);
		update_option('importer_'.$this->import_id.'-theme_options_backup', trim($this->theme_options_backup));
		update_option('importer_'.$this->import_id.'-config_backup', trim($this->config_backup));
	}
	

	function backup_config($new_config)
	{
        $include_in_backup = array();
        foreach($new_config as $key=>$val)
        {
        	$include_in_backup[] = $key;
        }

		global $cbt_export;
		$this->config_backup = $cbt_export->config(false, $include_in_backup);
	}
	
	function backup_theme_options()
	{
		if(trim($this->theme_options_backup)) return;

		global $cbt_redux;
        $cbt_redux->ReduxFramework->get_options();
        $backup_options = $cbt_redux->ReduxFramework->options;
        $backup_options['redux-backup'] = '1';
        if ( isset( $var['REDUX_imported'] ) ) {
            unset( $var['REDUX_imported'] );
        }
        if (version_compare(phpversion(), "5.3.0", ">=")) {
            $content = json_encode( $backup_options, true ) ;
        } else {
            $content = json_encode( $backup_options );
        }
        
        if($content)
        {
	        $this->theme_options_backup = $content;
        }
	}
	
	
	
	function uninstall_demo($id='')
	{
		if(! $id)
		{
			if(isset($_POST['demo_id']) && trim($_POST['demo_id']))
			{
				$id = $_POST['demo_id'];
			}
			else
			{
				echo 'Error: No demo id provided';
				die();
			}
		}
		
		$id = 'wbc-import-'.$id;
		
		$this->import_id = $id;
		$this->set_data($id, false);

		if(trim($this->wordpress_data['user_id'])) 
		{
			wp_delete_user( $this->wordpress_data['user_id'] );
			$this->uninstall_trash($this->wordpress_data['user_id']);
			echo "- Content uninstalled \n";
		}
		else
		{
			echo 'Error: No content to uninstall ('.$id.')';
			die();
		}
		
		$this->uninstall_theme_options();
		$this->uninstall_terms();
		$this->uninstall_widgets();
		$this->uninstall_revslider();
		$this->uninstall_config();
		
		delete_option('importer_'.$id.'-wordpress_data');
		delete_option('importer_'.$id.'-theme_options_backup');
		delete_option('importer_'.$id.'-config_backup');
		
		$imported = get_option( 'wbc_imported_demos' );
		if(isset($imported[$id]))
		{
			unset($imported[$id]);
			update_option('wbc_imported_demos', $imported);
		}
		
		echo 'Content successfully uninstalled. Page will now reload';
		die();
	}
	
	
	function uninstall_trash($user_id, $post_type='all')
	{
		if(! $user_id OR $user_id==0 OR !is_numeric($user_id)) return;
		
		if($post_type=='all')
		{
			$post_types = get_post_types( '', 'names' );
			foreach ( $post_types as $post_type ) 
			{
				$this->uninstall_trash($user_id, $post_type);
			}
			
			return;
		}
		
		$args = array(
			'author'=>$user_id,
			'posts_per_page'   => -1,
			'post_type'        => $post_type,
			'post_status'      => 'trash',
			'suppress_filters' => true 
		);
		$posts_array = get_posts( $args );
		
		if(! $posts_array OR empty($posts_array) OR !is_array($posts_array)) return false;
		
		foreach($posts_array as $post)
		{
			wp_delete_post($post->ID, true);
		}
	}
	
	
	function uninstall_terms()
	{
		if(isset($this->wordpress_data['terms']) && !empty($this->wordpress_data['terms']) && is_array($this->wordpress_data['terms']))
		{
			foreach($this->wordpress_data['terms'] as $tax_name=>$tax)
			{
				if(empty($tax)) continue;
				
				foreach($tax as $id)
				{
					wp_delete_term($id, $tax_name);
				}
			}
		}
	}
	
	
	function uninstall_widgets()
	{
		if(isset($this->wordpress_data['widgets']) && !empty($this->wordpress_data['widgets']) && is_array($this->wordpress_data['widgets']))
		{
			$sidebars = get_option( 'sidebars_widgets' );
				
			foreach($this->wordpress_data['widgets'] as $sidebar_id=>$widgets)
			{
				if(empty($widgets)) continue;
				
				foreach($widgets as $id)
				{
					if(($key = array_search($id, $sidebars[$sidebar_id])) !== false) {
					    unset($sidebars[$sidebar_id][$key]);
					}
				}
			}
			
			echo "- Widgets Removed from sidebars \n";
			update_option( 'sidebars_widgets', $sidebars );
		}
	}
	
	
	function uninstall_theme_options()
	{
		global $cbt_redux;
		
		$this->theme_option_name = $cbt_redux->ReduxFramework->args['opt_name'];
		
		if(! $this->theme_option_name) return;
		
		// Get file contents and decode
		$data = $this->theme_options_backup;
		if(! $data) return;
		
		
		$data = json_decode( $data, true );
		$data = maybe_unserialize( $data );
		
		
		// Only if there is data
		if ( !empty( $data ) || is_array( $data ) ) 
		{
			update_option( $this->theme_option_name, $data );
			
			// force run less compiler on next page load
			update_option('cbt_do_auto_redux_compiler', 'yes');
			
			echo "- Theme options reverted \n";
		}
	}
	
	
	function uninstall_revslider()
	{
		if ( ! class_exists( 'RevSlider' ) ) return false;
		
		if(isset($this->wordpress_data['revslider']) && !empty($this->wordpress_data['revslider']) && is_array($this->wordpress_data['revslider']))
		{
			$slider = new RevSlider();
			
			foreach($this->wordpress_data['revslider'] as $id)
			{
				deleteSliderFromData(array('sliderid'=>$id));
			}
			
			echo "- Slides removed \n";
		}
	}


	function uninstall_config()
	{
		// Get file contents
		$data = $this->config_backup;
		cbt_apply_config_json($data, false);
	}
	
	
	function imported_demos()
	{	
		if(!isset($_GET['page']) OR $_GET['page']!='cbt_options') return;

		$imported = get_option( 'wbc_imported_demos' );
		//echo '<pre>'.print_r($imported, TRUE).'</pre>';
		
		$imported_json = array();

        if ( !empty( $imported ) && is_array( $imported ) ) 
        {
			foreach($imported as $demo_id=>$demo)
			{
				$id = preg_replace('/^wbc\-import\-/i','',$demo_id);
				$data = $this->get_data($demo_id);
				//echo '<pre>'.print_r($data, TRUE).'</pre>';
				
				$user_id = 1; 
				$pages_url = '';
				
				if(isset($data['wordpress_data']['user_id']) && trim($data['wordpress_data']['user_id']))
				{
					$user_id = $data['wordpress_data']['user_id'];
					$pages_url = admin_url('edit.php?post_type=page&author='.$user_id);
				}
				
				
				$imported_json[ $id ] = array(
					'author'=>$user_id,
					'pages_url'=>$pages_url,
				);
			}
        }	
		
		?>
		<script>
			var cbt_imported_demos = false;
			<?php if(!empty($imported_json)): ?>
				cbt_imported_demos = <?php echo(json_encode($imported_json));?>;
			<?php endif; ?>
		</script>	
		<?php
	}
	

	
}


global $cbt_importer;
$cbt_importer = new cbt_importer;


function cbt_importer_log_term($id, $tax='category')
{
	global $cbt_importer;
	return $cbt_importer->log_term($id, $tax);
}


