<?php
class cbt_apis
{
	static public $poll_started = false;

	function __construct()
	{
		add_action( 'wp_ajax_cbt_api_request', array($this, 'api_request'));
	}
	
	
	function api_request()
	{
		if(! isset($_POST['api']) OR ! trim($_POST['api']))
		{
			echo 'Please activate your license first to access this feature';
			die();
		}
		
		$api = urldecode(trim($_POST['api']));
		
		if($api == 'colors_display_swatches')
		{
			global $cbt_colors;
			$cbt_colors->display_swatches();
			die();
		}

		$data = @file_get_contents($api);
	
		if(! $data)
		{
		    $ch = curl_init();
		    curl_setopt($ch, CURLOPT_URL, $api);
		    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		    $data = curl_exec($ch);
		    curl_close($ch);
		}

		if(! $data) 
		{
			echo 'Error connecting to API Server';
			die();
		}
		
		if($_POST['nonce'] && trim($_POST['nonce']))
		{
			$nonce = trim($_POST['nonce']);
			$data = preg_replace('/\{NONCE\}/', $nonce, $data);
		}


		echo $data;
		die();
	}
	
	function poll_start()
	{
		self::$poll_started = true;

		ini_set('memory_limit',  '300M');
		ini_set('max_execution_time', 2200);
		
		//ob_start();
		ini_set('output_buffering','on');
		ini_set('zlib.output_compression', 0);
		//ini_set('implicit_flush',1);
		ob_implicit_flush();
	}
	
	
	function poll($msg, $type='normal')
	{
		if(self::$poll_started == false)
			return;
		?>
		<?php echo $msg;?><br />
		<script>
			parent.cbt_import_poll('<?php echo $msg;?>', '<?php echo $type;?>');
		</script>
		<?php
		
		ob_flush(); flush();
	}
	
	function poll_action($action)
	{
		?>
		<script>
			parent.cbt_action_poll('<?php echo $action;?>');
		</script>
		<?php
		
		ob_flush(); flush();
	}

	
}


new cbt_apis();