<?php

class cbt_colors
{
	public $api = 'http://imresourcedemosite.com/colors/';
	public $search;
	public $action;
	public $page;
	
	function __construct()
	{
		require_once dirname( __FILE__ ) . '/color_processor.php';
		
		add_action( 'wp_ajax_cbt_colors_query', array($this, 'ajax'));
	}

	function display()
	{
		if(! is_admin()) return;
		
		if(! isset($_GET['page']) OR $_GET['page']!='cbt_options') return;
	
		ob_start();
		?>
		
		<div id="cbt_colors">
			<div class="cbt_colors-nav">
				<ul>
					<li><a id="cbt-colors-link-popular" href="" rel="<?php echo admin_url('admin-ajax.php?action=cbt_colors_query&cbt_colors_action=popular')?>">Popular</a></li>
					<li><a id="cbt-colors-link-recent" href="" rel="<?php echo admin_url('admin-ajax.php?action=cbt_colors_query&cbt_colors_action=recent')?>">Recent</a></li>
					<li>
							<input id="cbt-colors-search-term" type="text" placeholder="search..." class="button" /> <button id="cbt-colors-search" class="button">Search</button>
					</li>
				</ul>
				<div class="cbt_clearfix"></div>
			</div>
			
			<div class="cbt_clearfix"></div>
			
			<fieldset style="" id="cbt_options-color-schemes" class="redux-field-container redux-field redux-field-init redux-container-image_select " data-id="bk-theme-presets"  data-type="image_select">
				<div id="cbt-swatches-holder">
					
					<?php echo '<div class="cbt_api_request" data-api="colors_display_swatches" data-nonce="" data-callback-event="colors_scheme_field_init"><div class="cbt_loader"></div></div>';
						//$this->display_swatches(); ?>
					
					
				</div>
			</fieldset>
		</div>
		
		

		
		<?php
		
		
		$data = ob_get_contents(); 
		ob_end_clean();
		
		return $data;
	}
	
	
	
	function display_swatches($colors='')
	{
		if(!$colors) 
			$colors = $this->get();
		
		if(! is_array($colors))
		{
			echo $colors;
			return '';
		}
		
		?>
		<div class="cbt-colors-ajax">
		
			<ul class="cbt_swatches"><?php
			
			foreach($colors as $color):
			
				$this->make_swatch($color);
				
			endforeach;
			
			?></ul>
			
			<br />
			
			<div class="cbt_clearfix"></div>
			
			<?php if($this->page > 1):?>
				<button class="cbt-colors-link-back button" rel="<?php echo admin_url('admin-ajax.php?action=cbt_colors_query&cbt_colors_action='.$this->action.'&page='.($this->page-1).'&search='.$this->search)?>">&laquo; Back</button>
			<?php endif;?>
			
			<?php if(! empty($colors)):?>
				<button class="cbt-colors-link-next button-primary" style="float:right;" rel="<?php echo admin_url('admin-ajax.php?action=cbt_colors_query&cbt_colors_action='.$this->action.'&page='.($this->page+1).'&search='.$this->search)?>">Next &raquo;</button>
			<?php endif;?>
			
			<div class="cbt_clearfix"></div>
		
		</div>
		<?php
		
		return '';
	}
	
	
	function ajax()
	{
		if(! is_admin()) return;
		
		$action = 'popular';
		$page = '1';
		$search = '';
		
		if(isset($_GET['cbt_colors_action'])) $action = $_GET['cbt_colors_action'];
		if(isset($_GET['page'])) $page = $_GET['page'];
		if(isset($_GET['search'])) $search = $_GET['search'];
		
		$colors = $this->get($action, $page, $search);
		
		$this->display_swatches($colors);
		
		die();
	}
	
	
	function make_swatch($data)
	{
		static $i;
		if(! $i) $i=10;
		$i++;
		
		
		try
		{
			if(! $data->colors OR ! is_array($data->colors))
			{
				return false;
			}
			
			// ------------------------------------------------------
			//  Make sure all colors are valid
			// ------------------------------------------------------
			foreach($data->colors as $c)
			{
				if(! trim($c)) return;
				
				if(! preg_match('/^#/i', trim($c)) OR strlen(trim($c)) < 7) 
				{
					return false;
				}
			}
			
			$color[1] = new Cbt_Color_processor(trim($data->colors[0]));
			$color[2] = new Cbt_Color_processor(trim($data->colors[1]));
			$color[3] = new Cbt_Color_processor(trim($data->colors[2]));
			$color[4] = new Cbt_Color_processor(trim($data->colors[3]));
			$color[5] = new Cbt_Color_processor(trim($data->colors[4]));
			
			$brightness_index = '';
			foreach($color as $c)
			{
				if(is_null($c)) return false;
				
				$c->isDark();
				$brightness_index[ $c->amount ] = $c;
			}
			
			ksort($brightness_index);
			
			$darkest_1st = array_shift($brightness_index);
			$darkest_2nd = array_shift($brightness_index);
			$darkest_3rd = array_shift($brightness_index);
			$darkest_4th = array_shift($brightness_index);
			//echo '<pre>'.print_r($brightness_index, TRUE).'</pre>';
			$darkest_5th = array_shift($brightness_index);
			
			
			
			$footer = $darkest_1st;
			$header = $darkest_2nd;
			
			if(is_null($header)) return false;
			
			if($header->isDark()) 
			{
				$header_text = $header->lighten(60);
				if(is_object($darkest_5th)) $header_hover_text = $darkest_5th->getHex();
				else
				{
					$header_hover_text = $header->lighten(40);
				}
			}
			else 
			{
				$header_text = $header->darken(50);
				$header_hover_text = $darkest_1st->darken(15);
			}
			
			$top_nav = new Cbt_Color_processor( $header->darken(25) );
			if($top_nav->isDark()) 
			{
				$top_nav_text = $top_nav->lighten(60);
			}
			else 
			{
				$top_nav_text = $top_nav->darken(50);
				$footer_pattern_opacity = '40';
			}	
			
			
			if($footer->isDark()) 
			{
				$footer_text = $footer->lighten(70);
			}
			else 
			{
				$footer_text = $footer->darken(50);
			}	
			
			$info_box = new Cbt_Color_processor( $footer->darken(10) );
			if(! $info_box->isDark()) 
			{
				$info_box_pattern_opacity = '40';
			}
	
			$presets = array(
	        	'footer_bg' => '#'.$footer->darken(10),
	
	        	'sub-floor-color' => '#'.$footer->darken(25),
	        	'info-box-bg' => '#'.$footer->darken(10),
	        	'info-box-text-color' => '#'.$footer_text,
	        	'color2' => '#'.$color[1]->getHex(),
	        	'color1' => '#'.$darkest_1st->getHex(), // mobile header bg color
	        	
	        	'background-color' => '#'.$color[3]->getHex(),
	        	
	            'top-nav-color' => '#'.$top_nav->getHex(),
	            'top-nav-text-color' => '#'.$top_nav_text,
	            'header2-bg' => '#'.$header->getHex(),
	            'header2-text-color' => '#'.$header_text,
				'nav-color' => '#'.$header->getHex(),
	            'nav-text-color' => '#'.$header_text,
	            'nav-hover-color' => '#'.$header_hover_text,
			);
			
			if($presets['color1'] == $presets['color2'])
			{
				$presets['color2'] = new Cbt_Color_processor($presets['color2']);
				$presets['color2'] = '#'.$presets['color2']->darken(10);
			}

			 // mobile hamburger menu bg
			$presets['nav-mobile-btn-color'] = $presets['color2'];
			
			
			if(is_object($darkest_5th))
			{
				$presets['content-bg'] = '#'.$darkest_5th->lighten(20);
			}
			elseif(is_object($darkest_4th))
			{
				$presets['content-bg'] = '#'.$darkest_4th->lighten(25);
			}
			elseif(is_object($darkest_3th))
			{
				$presets['content-bg'] = '#'.$darkest_4th->lighten(30);
			}
			
			
			if(isset($info_box_pattern_opacity))
				$presets['info-box-pattern-opacity'] = $info_box_pattern_opacity;
			
			if(isset($footer_pattern_opacity))
				$presets['footer-pattern-opacity'] = $footer_pattern_opacity;	
				
		} catch (Exception $e) {
		
			return false; // skip the swatch
		
		}
		
		
		
		$presets['redux-backup'] = 1;
		
		$presets = 'data-presets="' . htmlspecialchars( json_encode( $presets ), ENT_QUOTES, 'UTF-8' ) . '"';
	
		?>
		<li class="redux-image-select cbt_swatch">
			<label class=" redux-image-select-preset-theme-presets_<?php echo $i?>" for="theme-presets_<?php echo $i?>">
				<div class="tiles" rel="<?php echo get_stylesheet_directory_uri() . '/library/admin/assets/images/1x1.png'?>" <?php echo $presets?>>
					<input type="radio" class="compiler noUpdateredux-presets" id="theme-presets_<?php echo $i?>" name="cbt_options[theme-presets]" value="<?php echo $i?>" <?php echo $presets?>/>
			
					<ul>
						<?php foreach($data->colors as $color):?>
						
							<li style="background-color: <?php echo $color ?>"></li>
						
						<?php endforeach;?>
					</ul>
					
					<i>
					<?php
					if(strlen($data->title)<=30)
					{
						echo $data->title;
					}
					else
					{
						$y=substr($data->title,0,27) . '...';
						echo $y;
					}	
					?>
					</i>
					
					
					<div class="cbt_clearfix"></div>
				</div>
			</label>
		</li>
		<?php
	}

	
	function get($action='popular', $page='1', $search='')
	{
		$this->action = $action;
		$this->page = $page;
		$this->search = $search;
		$product = basename(get_template_directory());
		
		$key = trim(get_option('cbt_license_key'));
		
		if(! $key)
		{
			echo 'Please activate your license first to access this feature';
			return;
		}

		$this->api .= '?key='.trim($key).'&';
		
		
		//echo '<pre>'.print_r($this->api.'?action='.$action.'&page='.$page.'&search='.$search, TRUE).'</pre>';die();
		
		$url = $this->api.'product='.$product.'&action='.$action.'&page='.$page.'&search='.$search;
	
		$data = @file_get_contents($url);
		
		if(! $data)
		{
		    $ch = curl_init();
		    curl_setopt($ch, CURLOPT_URL, $url);
		    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		    $data = curl_exec($ch);
		    curl_close($ch);
		}
		
		
		if(! $data) return 'Error connecting to API Server';

		$data = json_decode($data);
		
		
		return $data;
	}
}

global $cbt_colors;
$cbt_colors = new cbt_colors;