<?php
class cbt_comments
{

	function __construct()
	{
		add_filter( 'comment_form_default_fields', array($this, 'comment_form_fields') );
		add_filter( 'woocommerce_product_review_comment_form_args', array($this, 'woocommerce_review_form_fields') );
		add_filter( 'comment_form_defaults', array($this, 'comment_form') );
	}

	function comment_form_fields( $args=array(), $class = 'col-md-4' ) {

	    $commenter = wp_get_current_commenter();
	    $req      = get_option( 'require_name_email' );
	    $aria_req = ( $req ? " aria-required='true' required" : '' );
	    $html5    = current_theme_supports( 'html5', 'comment-form' ) ? 1 : 0;
	    
	    $fields   =  array(
	        'author' => '<div class="form-group '.$class.' comment-form-author">' . '<label class="sr-only" for="author">' . __( 'Name' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
	                    '<input class="form-control" id="author" name="author" type="text" placeholder="'.__( 'Your Name', 'cbt' ). ($req ? ' *' :'').'" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /><p id="d1" class="text-danger"></p></div>',
	        'email'  => '<div class="form-group '.$class.' comment-form-email"><label class="sr-only" for="email">' . __( 'Email' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
	                    '<input placeholder="'.__( 'Your email', 'cbt' ). ($req ? ' *' :'') .'" class="form-control" id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /><p id="d2" class="text-danger"></p></div>',
	        'url'    => '<div class="form-group '.$class.' comment-form-url"><label class="sr-only" for="url">' . __( 'Website' ) . '</label> ' .
	                    '<input placeholder="'.__( 'Your website url', 'cbt' ).'" class="form-control" id="url" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /><p id="d4" class="text-danger"></p></div>'        
	    );
	    
	    return $fields;
	}


	function woocommerce_review_form_fields( $args ) {
		// echo '<pre>'.htmlentities(print_r( $args , TRUE)).'</pre>';
		$args['title_reply'] = '<h2>'.__('Your review', 'cbt').'</h2>';
	    $args['fields'] = $this->comment_form_fields( $args, 'col-md-6' );
	    $args['fields']['url'] = '';
	    $args['comment_field'] = '<div class="form-group comment-form-comment">'.str_replace('id="comment"','id="comment" class="form-control" placeholder="'.__( 'Your review here...', 'cbt' ).'"', $args['comment_field']).'</div>';

	    return $args;
	}


	function comment_form( $args ) {
	    $args['comment_field'] = '<div class="form-group comment-form-comment">
	            <label for="comment">' . _x( 'Comment', 'noun' ) . '</label> 
	            <textarea placeholder="'.__( 'Your Comment here...', 'cbt' ).'" class="form-control" id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea><p id="d3" class="text-danger"></p>
	        </div>';
	    $args['class_submit'] = 'btn btn-default'; // since WP 4.1
	    
	    return $args;
	}

}


new cbt_comments();