<?php
$custom_template_content = $custom_template = $custom_template_meta = '';
$cbt_is_custom_template = false;
	
function cbt_get_ID_by_slug($page_slug) {
    $page = get_page_by_path($page_slug);
    if ($page) {
        return $page->ID;
    } else {
        return null;
    }
}

function cbt_get_post_meta_all($post_id){
    global $wpdb;

    $data   =   array();

    $wpdb->query("
        SELECT `meta_key`, `meta_value`
        FROM $wpdb->postmeta
        WHERE `post_id` = $post_id
    ");

    foreach($wpdb->last_result as $k => $v){
        $data[$v->meta_key] =   $v->meta_value;
    };

    return $data;
}

function cbt_default_template_get_meta($abc, $object_id, $meta_key, $single)
{
	//echo '<pre>'.print_r($meta_key, TRUE).'</pre>';
	if(preg_match('/^cbt_/', $meta_key))
	{
		global $custom_template_meta;
		if(isset($custom_template_meta[$meta_key])) return $custom_template_meta[$meta_key];
	}
	
	return $abc;
}

/**
 * Replaces post content with template's content
 * @param  string $content wp post content coming from filter
 * @return string          template shortcodes
 */
function cbt_default_template_content($content)
{
	static $i;

	// only run for the main post
	if($i > 0) return $content;
	$i++;

	
	global $custom_template_content, $wpglow_no_detech_active;
	
	$wpglow_no_detech_active = true;
	
	// replace password protect placeholder with form html
	if ( post_password_required() ) 
	{
		global $custom_template_password_protected_form;
		$custom_template_password_protected_form = $content;
	}

	//$content = str_replace('', $content, $custom_template_content);
	
	return $custom_template_content;
	
	//return $content;
}

// ------------------------------------------------------
//  Add header style class to body
// ------------------------------------------------------
function cbt_custom_template_body_class($classes) 
{
	global $cbt_custom_template_body_class;
	
	// merge other classes
	if(! empty($cbt_custom_template_body_class))
		$classes = array_merge($classes, $cbt_custom_template_body_class);

	// add custom template class
	$classes[] = 'cbt_custom_post_template';
	
	return $classes;
}

/**
 * Gets custom template's content and injects to a global var custom_template_content
 * to replace post content in cbt_default_template_content
 * @param  string $custom_template_slug page slug acting as template
 * @return void
 */
function cbt_apply_custom_template($custom_template_slug)
{
	global $custom_template_content, $custom_template, $custom_template_meta, $template, $cbt_is_custom_template, $cbt_custom_template_body_class;
	
	$cbt_is_custom_template = true;
	
	$custom_template_id = cbt_get_ID_by_slug($custom_template_slug);
	if($custom_template_id)
	{
		$custom_template = get_post($custom_template_id);
		$custom_template_meta = cbt_get_post_meta_all($custom_template_id);


		$template = str_ireplace('.php', '', $custom_template_meta['_wp_page_template']);
		if($template == 'default')
		{
			$template = 'page';
		}	

		// body class
		// with -php
		$cbt_custom_template_body_class[] = 'page-template-'.sanitize_html_class( str_replace( '.', '-', $custom_template_meta['_wp_page_template'] ) );
		// without -php
		$cbt_custom_template_body_class[] = 'page-template-'.sanitize_html_class( str_replace( '.', '-', $template ) );

	
		
		// if myCred plugin is activated then use the temporary workaround (3/3)
		// move filter order so when myCred overwrites the content (e.g to hide the page) it is not replaced by ours
		if( is_plugin_active( 'mycred/mycred.php' ) ) 
		{
			add_filter( 'the_content', 'cbt_default_template_content', 5);
		}
		else
		{
			add_filter( 'the_content', 'cbt_default_template_content', 10);
		}

		add_filter( 'get_post_metadata', 'cbt_default_template_get_meta', 99, 3);
		add_filter( 'body_class','cbt_custom_template_body_class');
		
		
		
		$custom_template_content = $custom_template->post_content;
		$custom_template_content = ST_Pb_Helper_Shortcode::get_builder_tab_content(
			$custom_template_content, 
			$custom_template, 
			$custom_template_meta['_wr_page_active_tab'],
			$custom_template_meta['_wr_deactivate_pb']
		);

		// if not deactivate pagebuilder on this post/page then add its css etc
		if ( empty( $custom_template_meta['_wr_page_active_tab'] ) ) 
		{
			$custom_css_data = ST_Pb_Helper_Functions::custom_css_data( isset ( $custom_template_id ) ? $custom_template_id : NULL );
			extract( $custom_css_data );

			if($css_custom)
			{
				$css_custom = html_entity_decode( stripslashes( $css_custom ) );
				
				add_action('wp_head', 'cbt_apply_custom_template_custom_css');
				
				global $cbt_apply_custom_template_custom_css;
				$cbt_apply_custom_template_custom_css = balanceTags( "<style id='wr-pb-custom-{$custom_template_id}-css'>\n$css_custom\n</style>\n" );
			}
		}
	}
	
}


function cbt_apply_custom_template_custom_css()
{
	global $cbt_apply_custom_template_custom_css;
	echo $cbt_apply_custom_template_custom_css;
}



// ------------------------------------------------------
//  style password protected page form
// ------------------------------------------------------
add_filter( 'the_password_form', 'cbt_custom_password_form' );
function cbt_custom_password_form($form) {
    global $post;
    
    if(! $form) return '';
    
    $output = '[wr_row height="window_center" background="none" border_width_value_="0" border_style="solid" border_color="" text_color="" div_padding_top="10" div_padding_left="10" div_padding_bottom="10" div_padding_right="10" css_suffix="" id_wrapper="" ][wr_column span="span12"]';
	$output .= '<div class="cbt-post-password-form-wrapper">';
    $output .= $form;
    $output .= '</div>';
    $output .= '[/wr_column][/wr_row]';

    return $output;
}
