<?php

class cbt
{
	function __construct()
	{
		
	}

	public function get_post_types()
	{

		// Get all post types
		$post_types = get_post_types( array( 'public' => true ), 'objects' );

		// Prepare post types as field options
		$options = array();

		foreach ( $post_types as $slug => $defines ) {
			// ignore woocommerce product (we disable it by default due to select2 3.5 and 4.0 conflict)
			if('product' == $slug && class_exists( 'WooCommerce' ) )
			{
				continue;
			}

			// Filter supported post type
			if ( 'attachment' != $slug 
				&& 'st_templates' != $slug 
				&& post_type_supports( $slug, 'editor' ) 
				) 
			{
				$options[ $slug ] = $defines->labels->name;
			}
		}

		return $options;
	}

	
	/**
	 * Scans a directory for files of a certain extension.
	 *
	 * @param string $path Absolute path to search.
	 * @param mixed  Array of extensions to find, string of a single extension, or null for all extensions.
	 * @param int $depth How deep to search for files. Optional, defaults to a flat scan (0 depth). -1 depth is infinite.
	 * @param string $relative_path The basename of the absolute path. Used to control the returned path
	 *  for the found files, particularly when this function recurses to lower depths.
	 */
	function scandir( $path, $extensions = null, $depth = 0, $relative_path = '' ) {
	    if ( ! is_dir( $path ) )
	        return false;
	
	    if ( $extensions ) {
	        $extensions = (array) $extensions;
	        $_extensions = implode( '|', $extensions );
	    }
	
	    $relative_path = trailingslashit( $relative_path );
	    if ( '/' == $relative_path )
	        $relative_path = '';
	
	    $results = scandir( $path );
	    $files = array();
	
	    foreach ( $results as $result ) {
	        if ( '.' == $result[0] )
	            continue;
	        if ( is_dir( $path . '/' . $result ) ) {
	            if ( ! $depth || 'CVS' == $result )
	                continue;
	            $found = self::scandir( $path . '/' . $result, $extensions, $depth - 1 , $relative_path . $result );
	            $files = array_merge_recursive( $files, $found );
	        } elseif ( ! $extensions || preg_match( '~\.(' . $_extensions . ')$~', $result ) ) {
	            $files[ $relative_path . $result ] = $path . '/' . $result;
	        }
	    }
	
	    return $files;
	}

	public static function increase_memory($new_memory = '300M')
	{
		$memory = ini_get('memory_limit');
		ini_set('memory_limit',  $new_memory);
		ini_set('max_execution_time', 0);
		
		if($memory)
		{
			$memory = (INT) $memory;
			
			if($memory < 60)
			{
				ini_set('memory_limit',  '1550M');
				$memory = ini_get('memory_limit');
				if($memory) $memory = (INT) $memory;
			}
		
			if($memory < 60) 
			{
				return false;
			}
		}

		return true;
	}

}


function cbt_redux_callback_get_post_types()
{
	return cbt::get_post_types();
}