<?php

// Report simple running errors
//error_reporting(E_ERROR | E_PARSE);

class cbt_menu_icons
{
	function __construct()
	{
		add_action('wp_update_nav_menu_item', array($this, 'nav_update'),10, 3);
		add_filter('wp_setup_nav_menu_item', array($this, 'nav_item') );
		add_filter('wp_edit_nav_menu_walker', array($this, 'nav_edit_walker'),10,2 );
		add_action('wp_ajax_cbt_get_icons', array($this, 'get_icons'));

		if(is_admin()) $this->admin_assets();
	}
	
	
	function admin_assets()
	{
	    wp_register_style(
	        'redux-font-awesome',
	        '//maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css',
	        array(),
	        time(),
	        'all'
	    );  
	    wp_enqueue_style( 'redux-font-awesome' );
	    
	}

	/*
	 * Saves new field to postmeta for navigation
	 */	
	function nav_update($menu_id, $menu_item_db_id, $args ) {
	    if ( is_array($_REQUEST['menu-item-icon']) ) {
	        $custom_value = $_REQUEST['menu-item-icon'][$menu_item_db_id];
	        update_post_meta( $menu_item_db_id, '_menu_item_icon', $custom_value );
	    }
	}
	
	/*
	 * Adds value of new field to $item object that will be passed to     Walker_Nav_Menu_Edit_cbt
	 */
	function nav_item($menu_item) {
	    $menu_item->custom = get_post_meta( $menu_item->ID, '_menu_item_icon', true );
	    return $menu_item;
	}
	
	
	function nav_edit_walker($walker,$menu_id) {
	    return 'Walker_Nav_Menu_Edit_cbt';
	}
	
	
	function get_icons()
	{
		?>
			<div id="cbt_icon_selector">
				<div class="metabox-holder">
					<div class="postbox">
						<h3><strong>Select icon</strong></h3>
						<div class="inside">
							<div class="icon_actions"></div>
							<div class="icon_search">
								
								<?php
									$icon_sections = cbt_menu_icons::icons();
									foreach($icon_sections as $section)
									{
										echo '<h2>'.$section['label'].'</h2><ul class="icons-list fi_icon">';
										foreach($section['items'] as $icon_class => $icon_name)
										{
											echo '<li class="cbt-selectable" data-value="fa '.$icon_class.'"><i class="fa '.$icon_class.'"></i></li>';
										}
										echo '</ul><div class="clearfix clear"></div>';
									}
								?>
								
							</div><!-- .icon_search-->
						</div><!-- .inside-->
					</div><!-- .postbox-->
				</div>
				
				<span class="button-primary cbt-selectable cbt-none-icon" data-value="">No icon</span>
			</div>
		<?php
		
		die();
	}
	
	
	public function icons() {
		return array(
			array(
				'key'   => 'web-application',
				'label' => __( 'Web Application', 'cbt' ),
				'items' => array(
					'fa-adjust'               => __( 'Adjust', 'cbt' ),
					'fa-anchor'               => __( 'Anchor', 'cbt' ),
					'fa-archive'              => __( 'Archive', 'cbt' ),
					'fa-arrows'               => __( 'Arrows', 'cbt' ),
					'fa-arrows-h'             => __( 'Arrows', 'cbt' ),
					'fa-arrows-v'             => __( 'Arrows', 'cbt' ),
					'fa-asterisk'             => __( 'Asterisk', 'cbt' ),
					'fa-ban'                  => __( 'Ban', 'cbt' ),
					'fa-bar-chart-o'          => __( 'Bar Chart', 'cbt' ),
					'fa-barcode'              => __( 'Barcode', 'cbt' ),
					'fa-bars'                 => __( 'Bars', 'cbt' ),
					'fa-beer'                 => __( 'Beer', 'cbt' ),
					'fa-bell'                 => __( 'Bell', 'cbt' ),
					'fa-bell-o'               => __( 'Bell', 'cbt' ),
					'fa-bolt'                 => __( 'Bolt', 'cbt' ),
					'fa-book'                 => __( 'Book', 'cbt' ),
					'fa-bookmark'             => __( 'Bookmark', 'cbt' ),
					'fa-bookmark-o'           => __( 'Bookmark', 'cbt' ),
					'fa-bomb'                 => __( 'Bomb', 'cbt' ),
					'fa-briefcase'            => __( 'Briefcase', 'cbt' ),
					'fa-bug'                  => __( 'Bug', 'cbt' ),
					'fa-building'             => __( 'Building', 'cbt' ),
					'fa-building-o'           => __( 'Building', 'cbt' ),
					'fa-bullhorn'             => __( 'Bullhorn', 'cbt' ),
					'fa-bullseye'             => __( 'Bullseye', 'cbt' ),
					'fa-calendar'             => __( 'Calendar', 'cbt' ),
					'fa-calendar-o'           => __( 'Calendar', 'cbt' ),
					'fa-camera'               => __( 'Camera', 'cbt' ),
					'fa-camera-retro'         => __( 'Camera Retro', 'cbt' ),
					'fa-car'                  => __( 'Car', 'cbt' ),
					'fa-caret-square-o-down'  => __( 'Caret Down', 'cbt' ),
					'fa-caret-square-o-left'  => __( 'Caret Left', 'cbt' ),
					'fa-caret-square-o-right' => __( 'Caret Right', 'cbt' ),
					'fa-caret-square-o-up'    => __( 'Caret Up', 'cbt' ),
					'fa-certificate'          => __( 'Certificate', 'cbt' ),
					'fa-check'                => __( 'Check', 'cbt' ),
					'fa-check-circle'         => __( 'Check', 'cbt' ),
					'fa-check-circle-o'       => __( 'Check', 'cbt' ),
					'fa-check-square'         => __( 'Check', 'cbt' ),
					'fa-check-square-o'       => __( 'Check', 'cbt' ),
					'fa-child'                => __( 'Child', 'cbt' ),
					'fa-circle'               => __( 'Circle', 'cbt' ),
					'fa-circle-o'             => __( 'Circle', 'cbt' ),
					'fa-circle-o-notch'       => __( 'Circle', 'cbt' ),
					'fa-circle-thin'          => __( 'Circle', 'cbt' ),
					'fa-clock-o'              => __( 'Clock', 'cbt' ),
					'fa-cloud'                => __( 'Cloud', 'cbt' ),
					'fa-cloud-download'       => __( 'Cloud Download', 'cbt' ),
					'fa-cloud-upload'         => __( 'Cloud Upload', 'cbt' ),
					'fa-code'                 => __( 'Code', 'cbt' ),
					'fa-code-fork'            => __( 'Code Fork', 'cbt' ),
					'fa-coffee'               => __( 'Coffee', 'cbt' ),
					'fa-cog'                  => __( 'Cog', 'cbt' ),
					'fa-cogs'                 => __( 'Cogs', 'cbt' ),
					'fa-comment'              => __( 'Comment', 'cbt' ),
					'fa-comment-o'            => __( 'Comment', 'cbt' ),
					'fa-comments'             => __( 'Comments', 'cbt' ),
					'fa-comments-o'           => __( 'Comments', 'cbt' ),
					'fa-compass'              => __( 'Compass', 'cbt' ),
					'fa-credit-card'          => __( 'Credit Card', 'cbt' ),
					'fa-crop'                 => __( 'Crop', 'cbt' ),
					'fa-crosshairs'           => __( 'Crosshairs', 'cbt' ),
					'fa-cube'                 => __( 'Cube', 'cbt' ),
					'fa-cubes'                => __( 'Cubes', 'cbt' ),
					'fa-cutlery'              => __( 'Cutlery', 'cbt' ),
					'fa-dashboard'            => __( 'Dashboard', 'cbt' ),
					'fa-database'             => __( 'Database', 'cbt' ),
					'fa-desktop'              => __( 'Desktop', 'cbt' ),
					'fa-dot-circle-o'         => __( 'Dot', 'cbt' ),
					'fa-download'             => __( 'Download', 'cbt' ),
					'fa-edit'                 => __( 'Edit', 'cbt' ),
					'fa-ellipsis-h'           => __( 'Ellipsis', 'cbt' ),
					'fa-ellipsis-v'           => __( 'Ellipsis', 'cbt' ),
					'fa-envelope'             => __( 'Envelope', 'cbt' ),
					'fa-envelope-o'           => __( 'Envelope', 'cbt' ),
					'fa-envelope-square'      => __( 'Envelope', 'cbt' ),
					'fa-eraser'               => __( 'Eraser', 'cbt' ),
					'fa-exchange'             => __( 'Exchange', 'cbt' ),
					'fa-exclamation'          => __( 'Exclamation', 'cbt' ),
					'fa-exclamation-circle'   => __( 'Exclamation', 'cbt' ),
					'fa-exclamation-triangle' => __( 'Exclamation', 'cbt' ),
					'fa-external-link'        => __( 'External Link', 'cbt' ),
					'fa-external-link-square' => __( 'External Link', 'cbt' ),
					'fa-eye'                  => __( 'Eye', 'cbt' ),
					'fa-eye-slash'            => __( 'Eye', 'cbt' ),
					'fa-fax'                  => __( 'Fax', 'cbt' ),
					'fa-female'               => __( 'Female', 'cbt' ),
					'fa-fighter-jet'          => __( 'Fighter Jet', 'cbt' ),
					'fa-film'                 => __( 'Film', 'cbt' ),
					'fa-filter'               => __( 'Filter', 'cbt' ),
					'fa-fire'                 => __( 'Fire', 'cbt' ),
					'fa-fire-extinguisher'    => __( 'Fire Extinguisher', 'cbt' ),
					'fa-flag'                 => __( 'Flag', 'cbt' ),
					'fa-flag-checkered'       => __( 'Flag', 'cbt' ),
					'fa-flag-o'               => __( 'Flag', 'cbt' ),
					'fa-flash'                => __( 'Flash', 'cbt' ),
					'fa-flask'                => __( 'Flask', 'cbt' ),
					'fa-folder'               => __( 'Folder', 'cbt' ),
					'fa-folder-open'          => __( 'Folder Open', 'cbt' ),
					'fa-folder-o'             => __( 'Folder', 'cbt' ),
					'fa-folder-open-o'        => __( 'Folder Open', 'cbt' ),
					'fa-frown-o'              => __( 'Frown', 'cbt' ),
					'fa-gamepad'              => __( 'Gamepad', 'cbt' ),
					'fa-gavel'                => __( 'Gavel', 'cbt' ),
					'fa-gear'                 => __( 'Gear', 'cbt' ),
					'fa-gears'                => __( 'Gears', 'cbt' ),
					'fa-gift'                 => __( 'Gift', 'cbt' ),
					'fa-glass'                => __( 'Glass', 'cbt' ),
					'fa-globe'                => __( 'Globe', 'cbt' ),
					'fa-graduation-cap'       => __( 'Graduation Cap', 'cbt' ),
					'fa-group'                => __( 'Group', 'cbt' ),
					'fa-hdd-o'                => __( 'HDD', 'cbt' ),
					'fa-header'               => __( 'Header', 'cbt' ),
					'fa-headphones'           => __( 'Headphones', 'cbt' ),
					'fa-heart'                => __( 'Heart', 'cbt' ),
					'fa-heart-o'              => __( 'Heart', 'cbt' ),
					'fa-home'                 => __( 'Home', 'cbt' ),
					'fa-history'              => __( 'History', 'cbt' ),
					'fa-inbox'                => __( 'Inbox', 'cbt' ),
					'fa-info'                 => __( 'Info', 'cbt' ),
					'fa-info-circle'          => __( 'Info', 'cbt' ),
					'fa-key'                  => __( 'Key', 'cbt' ),
					'fa-keyboard-o'           => __( 'Keyboard', 'cbt' ),
					'fa-language'             => __( 'Language', 'cbt' ),
					'fa-laptop'               => __( 'Laptop', 'cbt' ),
					'fa-leaf'                 => __( 'Leaf', 'cbt' ),
					'fa-legal'                => __( 'Legal', 'cbt' ),
					'fa-lemon-o'              => __( 'Lemon', 'cbt' ),
					'fa-level-down'           => __( 'Level Down', 'cbt' ),
					'fa-level-up'             => __( 'Level Up', 'cbt' ),
					'fa-life-ring'            => __( 'Life Buoy', 'cbt' ),
					'fa-lightbulb-o'          => __( 'Lightbulb', 'cbt' ),
					'fa-location-arrow'       => __( 'Location Arrow', 'cbt' ),
					'fa-lock'                 => __( 'Lock', 'cbt' ),
					'fa-magic'                => __( 'Magic', 'cbt' ),
					'fa-magnet'               => __( 'Magnet', 'cbt' ),
					'fa-mail-forward'         => __( 'Mail Forward', 'cbt' ),
					'fa-mail-reply'           => __( 'Mail Reply', 'cbt' ),
					'fa-mail-reply-all'       => __( 'Mail Reply All', 'cbt' ),
					'fa-male'                 => __( 'Male', 'cbt' ),
					'fa-map-marker'           => __( 'Map Marker', 'cbt' ),
					'fa-meh-o'                => __( 'Meh', 'cbt' ),
					'fa-microphone'           => __( 'Microphone', 'cbt' ),
					'fa-microphone-slash'     => __( 'Microphone', 'cbt' ),
					'fa-minus'                => __( 'Minus', 'cbt' ),
					'fa-minus-circle'         => __( 'Minus', 'cbt' ),
					'fa-minus-square'         => __( 'Minus', 'cbt' ),
					'fa-minus-square-o'       => __( 'Minus', 'cbt' ),
					'fa-mobile'               => __( 'Mobile', 'cbt' ),
					'fa-mobile-phone'         => __( 'Mobile Phone', 'cbt' ),
					'fa-moon-o'               => __( 'Moon', 'cbt' ),
					'fa-music'                => __( 'Music', 'cbt' ),
					'fa-paw'                  => __( 'Paw', 'cbt' ),
					'fa-paper-plane'          => __( 'Paper Plane', 'cbt' ),
					'fa-paper-plane-o'        => __( 'Paper Plane', 'cbt' ),
					'fa-pencil'               => __( 'Pencil', 'cbt' ),
					'fa-pencil-square'        => __( 'Pencil', 'cbt' ),
					'fa-pencil-square-o'      => __( 'Pencil', 'cbt' ),
					'fa-phone'                => __( 'Phone', 'cbt' ),
					'fa-phone-square'         => __( 'Phone', 'cbt' ),
					'fa-picture-o'            => __( 'Picture', 'cbt' ),
					'fa-plane'                => __( 'Plane', 'cbt' ),
					'fa-plus'                 => __( 'Plus', 'cbt' ),
					'fa-plus-circle'          => __( 'Plus', 'cbt' ),
					'fa-plus-square'          => __( 'Plus', 'cbt' ),
					'fa-plus-square-o'        => __( 'Plus', 'cbt' ),
					'fa-power-off'            => __( 'Power Off', 'cbt' ),
					'fa-print'                => __( 'Print', 'cbt' ),
					'fa-puzzle-piece'         => __( 'Puzzle Piece', 'cbt' ),
					'fa-qrcode'               => __( 'QR Code', 'cbt' ),
					'fa-question'             => __( 'Question', 'cbt' ),
					'fa-question-circle'      => __( 'Question', 'cbt' ),
					'fa-quote-left'           => __( 'Quote Left', 'cbt' ),
					'fa-quote-right'          => __( 'Quote Right', 'cbt' ),
					'fa-random'               => __( 'Random', 'cbt' ),
					'fa-rebel'                => __( 'Rebel', 'cbt' ),
					'fa-recycle'              => __( 'Recycle', 'cbt' ),
					'fa-refresh'              => __( 'Refresh', 'cbt' ),
					'fa-reply'                => __( 'Reply', 'cbt' ),
					'fa-reply-all'            => __( 'Reply All', 'cbt' ),
					'fa-retweet'              => __( 'Retweet', 'cbt' ),
					'fa-road'                 => __( 'Road', 'cbt' ),
					'fa-rocket'               => __( 'Rocket', 'cbt' ),
					'fa-rss'                  => __( 'RSS', 'cbt' ),
					'fa-rss-square'           => __( 'RSS Square', 'cbt' ),
					'fa-search'               => __( 'Search', 'cbt' ),
					'fa-search-minus'         => __( 'Search Minus', 'cbt' ),
					'fa-search-plus'          => __( 'Search Plus', 'cbt' ),
					'fa-share'                => __( 'Share', 'cbt' ),
					'fa-share-alt'            => __( 'Share', 'cbt' ),
					'fa-share-alt-square'     => __( 'Share', 'cbt' ),
					'fa-share-square'         => __( 'Share', 'cbt' ),
					'fa-share-square-o'       => __( 'Share', 'cbt' ),
					'fa-shield'               => __( 'Shield', 'cbt' ),
					'fa-shopping-cart'        => __( 'Shopping Cart', 'cbt' ),
					'fa-sign-in'              => __( 'Sign In', 'cbt' ),
					'fa-sign-out'             => __( 'Sign Out', 'cbt' ),
					'fa-signal'               => __( 'Signal', 'cbt' ),
					'fa-sitemap'              => __( 'Sitemap', 'cbt' ),
					'fa-sliders'              => __( 'Sliders', 'cbt' ),
					'fa-smile-o'              => __( 'Smile', 'cbt' ),
					'fa-sort'                 => __( 'Sort', 'cbt' ),
					'fa-sort-asc'             => __( 'Sort ASC', 'cbt' ),
					'fa-sort-desc'            => __( 'Sort DESC', 'cbt' ),
					'fa-sort-down'            => __( 'Sort Down', 'cbt' ),
					'fa-sort-up'              => __( 'Sort Up', 'cbt' ),
					'fa-sort-alpha-asc'       => __( 'Sort Alpha ASC', 'cbt' ),
					'fa-sort-alpha-desc'      => __( 'Sort Alpha DESC', 'cbt' ),
					'fa-sort-amount-asc'      => __( 'Sort Amount ASC', 'cbt' ),
					'fa-sort-amount-desc'     => __( 'Sort Amount DESC', 'cbt' ),
					'fa-sort-numeric-asc'     => __( 'Sort Numeric ASC', 'cbt' ),
					'fa-sort-numeric-desc'    => __( 'Sort Numeric DESC', 'cbt' ),
					'fa-space-shuttle'        => __( 'Space Shuttle', 'cbt' ),
					'fa-spoon'                => __( 'Spoon', 'cbt' ),
					'fa-spinner'              => __( 'Spinner', 'cbt' ),
					'fa-square'               => __( 'Square', 'cbt' ),
					'fa-square-o'             => __( 'Square', 'cbt' ),
					'fa-star'                 => __( 'Star', 'cbt' ),
					'fa-star-half'            => __( 'Star Half', 'cbt' ),
					'fa-star-half-o'          => __( 'Star Half', 'cbt' ),
					'fa-star-half-empty'      => __( 'Star Half Empty', 'cbt' ),
					'fa-star-half-full'       => __( 'Star Half Full', 'cbt' ),
					'fa-star-o'               => __( 'Star', 'cbt' ),
					'fa-subscript'            => __( 'Subscript', 'cbt' ),
					'fa-suitcase'             => __( 'Suitcase', 'cbt' ),
					'fa-sun-o'                => __( 'Sun', 'cbt' ),
					'fa-superscript'          => __( 'Superscript', 'cbt' ),
					'fa-tablet'               => __( 'Tablet', 'cbt' ),
					'fa-tachometer'           => __( 'Tachometer', 'cbt' ),
					'fa-tag'                  => __( 'Tag', 'cbt' ),
					'fa-tags'                 => __( 'Tags', 'cbt' ),
					'fa-tasks'                => __( 'Tasks', 'cbt' ),
					'fa-taxi'                 => __( 'Taxi', 'cbt' ),
					'fa-terminal'             => __( 'Terminal', 'cbt' ),
					'fa-thumb-tack'           => __( 'Thumb Tack', 'cbt' ),
					'fa-thumbs-down'          => __( 'Thumbs Down', 'cbt' ),
					'fa-thumbs-up'            => __( 'Thumbs Up', 'cbt' ),
					'fa-thumbs-o-down'        => __( 'Thumbs Down', 'cbt' ),
					'fa-thumbs-o-up'          => __( 'Thumbs Up', 'cbt' ),
					'fa-ticket'               => __( 'Ticket', 'cbt' ),
					'fa-times'                => __( 'Times', 'cbt' ),
					'fa-times-circle'         => __( 'Times', 'cbt' ),
					'fa-times-circle-o'       => __( 'Times', 'cbt' ),
					'fa-tint'                 => __( 'Tint', 'cbt' ),
					'fa-toggle-down'          => __( 'Toggle Down', 'cbt' ),
					'fa-toggle-left'          => __( 'Toggle Left', 'cbt' ),
					'fa-toggle-right'         => __( 'Toggle Right', 'cbt' ),
					'fa-toggle-up'            => __( 'Toggle Up', 'cbt' ),
					'fa-tree'                 => __( 'Tree', 'cbt' ),
					'fa-trash-o'              => __( 'Trash', 'cbt' ),
					'fa-trophy'               => __( 'Trophy', 'cbt' ),
					'fa-truck'                => __( 'Truck', 'cbt' ),
					'fa-umbrella'             => __( 'Umbrella', 'cbt' ),
					'fa-university'           => __( 'University', 'cbt' ),
					'fa-unlock'               => __( 'Unlock', 'cbt' ),
					'fa-unlock-alt'           => __( 'Unlock', 'cbt' ),
					'fa-unsorted'             => __( 'Unsorted', 'cbt' ),
					'fa-upload'               => __( 'Upload', 'cbt' ),
					'fa-user'                 => __( 'User', 'cbt' ),
					'fa-users'                => __( 'Users', 'cbt' ),
					'fa-video-camera'         => __( 'Video Camera', 'cbt' ),
					'fa-volume-down'          => __( 'Volume Down', 'cbt' ),
					'fa-volume-off'           => __( 'Volume Of', 'cbt' ),
					'fa-volume-up'            => __( 'Volume Up', 'cbt' ),
					'fa-warning'              => __( 'Warning', 'cbt' ),
					'fa-wrench'               => __( 'Wrench', 'cbt' ),
				),
			),
			array(
				'key'   => 'directional',
				'label' => __( 'Directional', 'cbt' ),
				'items' => array(
					'fa-angle-down'           => __( 'Angle Down', 'cbt' ),
					'fa-angle-left'           => __( 'Angle Left', 'cbt' ),
					'fa-angle-right'          => __( 'Angle Right', 'cbt' ),
					'fa-angle-up'             => __( 'Angle Up', 'cbt' ),
					'fa-angle-double-down'    => __( 'Angle Double Down', 'cbt' ),
					'fa-angle-double-left'    => __( 'Angle Double Left', 'cbt' ),
					'fa-angle-double-right'   => __( 'Angle Double Right', 'cbt' ),
					'fa-angle-double-up'      => __( 'Angle Double Up', 'cbt' ),
					'fa-arrow-circle-o-down'  => __( 'Arrow Circle Down', 'cbt' ),
					'fa-arrow-circle-o-left'  => __( 'Arrow Circle Left', 'cbt' ),
					'fa-arrow-circle-o-right' => __( 'Arrow Circle Right', 'cbt' ),
					'fa-arrow-circle-o-up'    => __( 'Arrow Circle Up', 'cbt' ),
					'fa-arrow-circle-down'    => __( 'Arrow Circle Down', 'cbt' ),
					'fa-arrow-circle-left'    => __( 'Arrow Circle Left', 'cbt' ),
					'fa-arrow-circle-right'   => __( 'Arrow Circle Right', 'cbt' ),
					'fa-arrow-circle-up'      => __( 'Arrow Circle Up', 'cbt' ),
					'fa-arrow-down'           => __( 'Arrow Down', 'cbt' ),
					'fa-arrow-left'           => __( 'Arrow Left', 'cbt' ),
					'fa-arrow-right'          => __( 'Arrow Right', 'cbt' ),
					'fa-arrow-up'             => __( 'Arrow Up', 'cbt' ),
					'fa-arrows'               => __( 'Arrows', 'cbt' ),
					'fa-arrows-alt'           => __( 'Arrows', 'cbt' ),
					'fa-arrows-h'             => __( 'Arrows', 'cbt' ),
					'fa-arrows-v'             => __( 'Arrows', 'cbt' ),
					'fa-caret-down'           => __( 'Caret Down', 'cbt' ),
					'fa-caret-left'           => __( 'Caret Left', 'cbt' ),
					'fa-caret-right'          => __( 'Caret Right', 'cbt' ),
					'fa-caret-up'             => __( 'Caret Up', 'cbt' ),
					'fa-caret-square-o-down'  => __( 'Caret Down', 'cbt' ),
					'fa-caret-square-o-left'  => __( 'Caret Left', 'cbt' ),
					'fa-caret-square-o-right' => __( 'Caret Right', 'cbt' ),
					'fa-caret-square-o-up'    => __( 'Caret Up', 'cbt' ),
					'fa-chevron-circle-down'  => __( 'Chevron Circle Down', 'cbt' ),
					'fa-chevron-circle-left'  => __( 'Chevron Circle Left', 'cbt' ),
					'fa-chevron-circle-right' => __( 'Chevron Circle Right', 'cbt' ),
					'fa-chevron-circle-up'    => __( 'Chevron Circle Up', 'cbt' ),
					'fa-chevron-down'         => __( 'Chevron Down', 'cbt' ),
					'fa-chevron-left'         => __( 'Chevron Left', 'cbt' ),
					'fa-chevron-right'        => __( 'Chevron Right', 'cbt' ),
					'fa-chevron-up'           => __( 'Chevron Up', 'cbt' ),
					'fa-hand-o-down'          => __( 'Hand Down', 'cbt' ),
					'fa-hand-o-left'          => __( 'Hand Left', 'cbt' ),
					'fa-hand-o-right'         => __( 'Hand Right', 'cbt' ),
					'fa-hand-o-up'            => __( 'Hand Up', 'cbt' ),
					'fa-long-arrow-down'      => __( 'Long Arrow Down', 'cbt' ),
					'fa-long-arrow-left'      => __( 'Long Arrow Left', 'cbt' ),
					'fa-long-arrow-right'     => __( 'Long Arrow Right', 'cbt' ),
					'fa-long-arrow-up'        => __( 'Long Arrow Up', 'cbt' ),
				),
			),
			array(
				'key'   => 'file-types',
				'label' => __( 'File Types', 'cbt' ),
				'items' => array(
					'fa-file'              => __( 'File', 'cbt' ),
					'fa-file-o'            => __( 'File', 'cbt' ),
					'fa-file-text'         => __( 'File: Text', 'cbt' ),
					'fa-file-text-o'       => __( 'File: Text', 'cbt' ),
					'fa-file-archive-o'    => __( 'File: Archive', 'cbt' ),
					'fa-file-audio-o'      => __( 'File: Audio', 'cbt' ),
					'fa-file-code-o'       => __( 'File: Code', 'cbt' ),
					'fa-file-excel-o'      => __( 'File: Excel', 'cbt' ),
					'fa-file-image-o'      => __( 'File: Image', 'cbt' ),
					'fa-file-pdf-o'        => __( 'File: PDF', 'cbt' ),
					'fa-file-powerpoint-o' => __( 'File: Powerpoint', 'cbt' ),
					'fa-file-video-o'      => __( 'File: Video', 'cbt' ),
					'fa-file-word-o'       => __( 'File: Word', 'cbt' ),
				),
			),
			
			array(
				'key'   => 'text-editor',
				'label' => __( 'Text Editor', 'cbt' ),
				'items' => array(
					'fa-align-left'    => __( 'Align Left', 'cbt' ),
					'fa-align-center'  => __( 'Align Center', 'cbt' ),
					'fa-align-justify' => __( 'Justify', 'cbt' ),
					'fa-align-right'   => __( 'Align Right', 'cbt' ),
					'fa-bold'          => __( 'Bold', 'cbt' ),
					'fa-clipboard'     => __( 'Clipboard', 'cbt' ),
					'fa-columns'       => __( 'Columns', 'cbt' ),
					'fa-copy'          => __( 'Copy', 'cbt' ),
					'fa-cut'           => __( 'Cut', 'cbt' ),
					'fa-paste'         => __( 'Paste', 'cbt' ),
					'fa-eraser'        => __( 'Eraser', 'cbt' ),
					'fa-files-o'       => __( 'Files', 'cbt' ),
					'fa-font'          => __( 'Font', 'cbt' ),
					'fa-indent'        => __( 'Indent', 'cbt' ),
					'fa-outdent'       => __( 'Outdent', 'cbt' ),
					'fa-italic'        => __( 'Italic', 'cbt' ),
					'fa-link'          => __( 'Link', 'cbt' ),
					'fa-unlink'        => __( 'Unlink', 'cbt' ),
					'fa-list'          => __( 'List', 'cbt' ),
					'fa-list-alt'      => __( 'List', 'cbt' ),
					'fa-list-ol'       => __( 'Ordered List', 'cbt' ),
					'fa-list-ul'       => __( 'Unordered List', 'cbt' ),
					'fa-paperclip'     => __( 'Paperclip', 'cbt' ),
					'fa-paragraph'     => __( 'Paragraph', 'cbt' ),
					'fa-repeat'        => __( 'Repeat', 'cbt' ),
					'fa-undo'          => __( 'Undo', 'cbt' ),
					'fa-save'          => __( 'Save', 'cbt' ),
					'fa-strikethrough' => __( 'Strikethrough', 'cbt' ),
					'fa-table'         => __( 'Table', 'cbt' ),
					'fa-text-height'   => __( 'Text Height', 'cbt' ),
					'fa-text-width'    => __( 'Text Width', 'cbt' ),
					'fa-th'            => __( 'TH', 'cbt' ),
					'fa-th-large'      => __( 'TH Large', 'cbt' ),
					'fa-th-list'       => __( 'TH List', 'cbt' ),
					'fa-underline'     => __( 'Underline', 'cbt' ),
				),
			),
			array(
				'key'   => 'video-player',
				'label' => __( 'Video Player', 'cbt' ),
				'items' => array(
					'fa-arrows-alt'    => __( 'Arrows', 'cbt' ),
					'fa-backward'      => __( 'Backward', 'cbt' ),
					'fa-compress'      => __( 'Compress', 'cbt' ),
					'fa-eject'         => __( 'Eject', 'cbt' ),
					'fa-expand'        => __( 'Expand', 'cbt' ),
					'fa-fast-backward' => __( 'Fast Backward', 'cbt' ),
					'fa-fast-forward'  => __( 'Fast Forward', 'cbt' ),
					'fa-forward'       => __( 'Forward', 'cbt' ),
					'fa-pause'         => __( 'Pause', 'cbt' ),
					'fa-play'          => __( 'Play', 'cbt' ),
					'fa-play-circle'   => __( 'Play', 'cbt' ),
					'fa-play-circle-o' => __( 'Play', 'cbt' ),
					'fa-step-backward' => __( 'Step Backward', 'cbt' ),
					'fa-step-forward'  => __( 'Step Forward', 'cbt' ),
					'fa-stop'          => __( 'Stop', 'cbt' ),
					'fa-youtube-play'  => sprintf( __( '%s Play', 'cbt' ), 'YouTube' ),
				),
			),
			
			array(
				'key'   => 'currency',
				'label' => __( 'Currency', 'cbt' ),
				'items' => array(
					'fa-bitcoin'      => __( 'Bitcoin', 'cbt' ),
					'fa-dollar'       => __( 'Dollar', 'cbt' ),
					'fa-euro'         => __( 'Euro', 'cbt' ),
					'fa-gbp'          => __( 'GBP', 'cbt' ),
					'fa-money'        => __( 'Money', 'cbt' ),
					'fa-rouble'       => __( 'Rouble', 'cbt' ),
					'fa-inr'          => __( 'Rupee', 'cbt' ),
					'fa-try'          => __( 'Turkish Lira', 'cbt' ),
					'fa-krw'          => __( 'Won', 'cbt' ),
					'fa-jpy'          => __( 'Yen', 'cbt' ),
				),
			),
			array(
				'key'   => __( 'medical', 'cbt' ),
				'label' => __( 'Medical', 'cbt' ),
				'items' => array(
					'fa-ambulance'   => __( 'Ambulance', 'cbt' ),
					'fa-h-square'    => __( 'Hospital', 'cbt' ),
					'fa-hospital-o'  => __( 'Hospital', 'cbt' ),
					'fa-medkit'      => __( 'Medkit', 'cbt' ),
					'fa-stethoscope' => __( 'Stethoscope', 'cbt' ),
					'fa-user-md'     => __( 'User MD', 'cbt' ),
					'fa-wheelchair'  => __( 'Wheelchair', 'cbt' ),
				),
			),

			array(
				'key'   => __( 'brand', 'cbt' ),
				'label' => __( 'Brand', 'cbt' ),
				'items' => array(
					'fa-adn'                => 'ADN',
					'fa-android'            => 'Android',
					'fa-apple'              => 'Apple',
					'fa-behance'            => 'Behance',
					'fa-behance-square'     => 'Behance',
					'fa-bitbucket'          => 'Bitbucket',
					'fa-bitbucket-square'   => 'Bitucket Square',
					'fa-codepen'            => 'CodePen',
					'fa-css3'               => 'CSS3',
					'fa-delicious'          => 'Delicious',
					'fa-deviantart'         => 'deviantART',
					'fa-digg'               => 'Digg',
					'fa-dribbble'           => 'Dribbble',
					'fa-dropbox'            => 'DropBox',
					'fa-drupal'             => 'Drupal',
					'fa-empire'             => 'Empire',
					'fa-facebook'           => 'Facebook',
					'fa-facebook-square'    => 'Facebook',
					'fa-flickr'             => 'Flickr',
					'fa-foursquare'         => 'Foursquare',
					'fa-git'                => 'Git',
					'fa-git-square'         => 'Git',
					'fa-github'             => 'GitHub',
					'fa-github-alt'         => 'GitHub',
					'fa-github-square'      => 'GitHub',
					'fa-gittip'             => 'GitTip',
					'fa-google'             => 'Google',
					'fa-google-plus'        => 'Google+',
					'fa-google-plus-square' => 'Google+',
					'fa-hacker-news'        => 'Hacker News',
					'fa-html5'              => 'HTML5',
					'fa-instagram'          => 'Instagram',
					'fa-joomla'             => 'Joomla',
					'fa-jsfiddle'           => 'JSFiddle',
					'fa-linkedin'           => 'LinkedIn',
					'fa-linkedin-square'    => 'LinkedIn',
					'fa-linux'              => 'Linux',
					'fa-maxcdn'             => 'MaxCDN',
					'fa-openid'             => 'OpenID',
					'fa-pagelines'          => 'Pagelines',
					'fa-pied-piper'         => 'Pied Piper',
					'fa-pied-piper-alt'     => 'Pied Piper',
					'fa-pinterest'          => 'Pinterest',
					'fa-pinterest-square'   => 'Pinterest',
					'fa-qq'                 => 'QQ',
					'fa-reddit'             => 'reddit',
					'fa-reddit-square'      => 'reddit',
					'fa-renren'             => 'Renren',
					'fa-skype'              => 'Skype',
					'fa-slack'              => 'Slack',
					'fa-soundcloud'         => 'SoundCloud',
					'fa-spotify'            => 'Spotify',
					'fa-stack-exchange'     => 'Stack Exchange',
					'fa-stack-overflow'     => 'Stack Overflow',
					'fa-steam'              => 'Steam',
					'fa-steam-square'       => 'Steam',
					'fa-stumbleupon'        => 'StumbleUpon',
					'fa-stumbleupon-circle' => 'StumbleUpon',
					'fa-tencent-weibo'      => 'Tencent Weibo',
					'fa-trello'             => 'Trello',
					'fa-tumblr'             => 'Tumblr',
					'fa-tumblr-square'      => 'Tumblr',
					'fa-twitter'            => 'Twitter',
					'fa-twitter-square'     => 'Twitter',
					'fa-vimeo-square'       => 'Vimeo',
					'fa-vine'               => 'Vine',
					'fa-vk'                 => 'VK',
					'fa-weixin'             => 'Weixin',
					'fa-weibo'              => 'Wibo',
					'fa-windows'            => 'Windows',
					'fa-wordpress'          => 'WordPress',
					'fa-xing'               => 'Xing',
					'fa-xing-square'        => 'Xing',
					'fa-yahoo'              => 'Yahoo!',
					'fa-youtube'            => 'YouTube',
					'fa-youtube-square'     => 'YouTube',
				),
			),
		);
	}

}

new cbt_menu_icons();



/**
 * Copied from Walker_Nav_Menu_Edit class in core
 * 
 * Create HTML list of nav menu input items.
 *
 * @package WordPress
 * @since 3.0.0
 * @uses Walker_Nav_Menu
 */
class Walker_Nav_Menu_Edit_cbt extends Walker_Nav_Menu  {
/**
 * @see Walker_Nav_Menu::start_lvl()
 * @since 3.0.0
 *
 * @param string $output Passed by reference.
 */
function start_lvl( &$output, $depth = 0, $args = array() ) {}

/**
 * @see Walker_Nav_Menu::end_lvl()
 * @since 3.0.0
 *
 * @param string $output Passed by reference.
 */
function end_lvl(&$output, $depth = 0, $args = array()) {
}

/**
 * @see Walker::start_el()
 * @since 3.0.0
 *
 * @param string $output Passed by reference. Used to append additional content.
 * @param object $item Menu item data object.
 * @param int $depth Depth of menu item. Used for padding.
 * @param object $args
 */
function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
    global $_wp_nav_menu_max_depth;
    $_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;

    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

    ob_start();
    $item_id = esc_attr( $item->ID );
    $removed_args = array(
        'action',
        'customlink-tab',
        'edit-menu-item',
        'menu-item',
        'page-tab',
        '_wpnonce',
    );

    $original_title = '';
    if ( 'taxonomy' == $item->type ) {
        $original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
        if ( is_wp_error( $original_title ) )
            $original_title = false;
    } elseif ( 'post_type' == $item->type ) {
        $original_object = get_post( $item->object_id );
        $original_title = $original_object->post_title;
    }

    $classes = array(
        'menu-item menu-item-depth-' . $depth,
        'menu-item-' . esc_attr( $item->object ),
        'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
    );

    $title = $item->title;

    if ( ! empty( $item->_invalid ) ) {
        $classes[] = 'menu-item-invalid';
        /* translators: %s: title of menu item which is invalid */
        $title = sprintf( __( '%s (Invalid)' ), $item->title );
    } elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
        $classes[] = 'pending';
        /* translators: %s: title of menu item in draft status */
        $title = sprintf( __('%s (Pending)'), $item->title );
    }

    $title = empty( $item->label ) ? $title : $item->label;

    ?>
    <li id="menu-item-<?php echo $item_id; ?>" class="<?php echo implode(' ', $classes ); ?>">
        <dl class="menu-item-bar">
            <dt class="menu-item-handle">
                <span class="item-title"><?php echo esc_html( $title ); ?></span>
                <span class="item-controls">
                    <span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
                    <span class="item-order hide-if-js">
                        <a href="<?php
                            echo wp_nonce_url(
                                add_query_arg(
                                    array(
                                        'action' => 'move-up-menu-item',
                                        'menu-item' => $item_id,
                                    ),
                                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                                ),
                                'move-menu_item'
                            );
                        ?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up'); ?>">&#8593;</abbr></a>
                        |
                        <a href="<?php
                            echo wp_nonce_url(
                                add_query_arg(
                                    array(
                                        'action' => 'move-down-menu-item',
                                        'menu-item' => $item_id,
                                    ),
                                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                                ),
                                'move-menu_item'
                            );
                        ?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down'); ?>">&#8595;</abbr></a>
                    </span>
                    <a class="item-edit" id="edit-<?php echo $item_id; ?>" title="<?php esc_attr_e('Edit Menu Item'); ?>" href="<?php
                        echo ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? admin_url( 'nav-menus.php' ) : add_query_arg( 'edit-menu-item', $item_id, remove_query_arg( $removed_args, admin_url( 'nav-menus.php#menu-item-settings-' . $item_id ) ) );
                    ?>"><?php _e( 'Edit Menu Item' ); ?></a>
                </span>
            </dt>
        </dl>

        <div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo $item_id; ?>">
            <?php if( 'custom' == $item->type ) : ?>
                <p class="field-url description description-wide">
                    <label for="edit-menu-item-url-<?php echo $item_id; ?>">
                        <?php _e( 'URL' ); ?><br />
                        <input type="text" id="edit-menu-item-url-<?php echo $item_id; ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
                    </label>
                </p>
            <?php endif; ?>
            <p class="description description-thin">
                <label for="edit-menu-item-title-<?php echo $item_id; ?>">
                    <?php _e( 'Navigation Label' ); ?><br />
                    <input type="text" id="edit-menu-item-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
                </label>
            </p>
            <p class="description description-thin">
                <label for="edit-menu-item-attr-title-<?php echo $item_id; ?>">
                    <?php _e( 'Title Attribute' ); ?><br />
                    <input type="text" id="edit-menu-item-attr-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->post_excerpt ); ?>" />
                </label>
            </p>
            <p class="field-link-target description">
                <label for="edit-menu-item-target-<?php echo $item_id; ?>">
                    <input type="checkbox" id="edit-menu-item-target-<?php echo $item_id; ?>" value="_blank" name="menu-item-target[<?php echo $item_id; ?>]"<?php checked( $item->target, '_blank' ); ?> />
                    <?php _e( 'Open link in a new window/tab' ); ?>
                </label>
            </p>
            <p class="field-css-classes description description-thin">
                <label for="edit-menu-item-classes-<?php echo $item_id; ?>">
                    <?php _e( 'CSS Classes (optional)' ); ?><br />
                    <input type="text" id="edit-menu-item-classes-<?php echo $item_id; ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo $item_id; ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
                </label>
            </p>
            <p class="field-xfn description description-thin">
                <label for="edit-menu-item-xfn-<?php echo $item_id; ?>">
                    <?php _e( 'Link Relationship (XFN)' ); ?><br />
                    <input type="text" id="edit-menu-item-xfn-<?php echo $item_id; ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
                </label>
            </p>
            <p class="field-description description description-wide">
                <label for="edit-menu-item-description-<?php echo $item_id; ?>">
                    <?php _e( 'Description' ); ?><br />
                    <textarea id="edit-menu-item-description-<?php echo $item_id; ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo $item_id; ?>]"><?php echo esc_html( $item->description ); // textarea_escaped ?></textarea>
                    <span class="description"><?php _e('The description will be displayed in the menu if the current theme supports it.'); ?></span>
                </label>
            </p>        
            <?php
            /*
             * This is the added field
             */
            ?>      
            <p class="field-custom description description-wide">
                <label for="edit-menu-item-icon-<?php echo $item_id; ?>">
                    <?php _e( 'Icon' ); ?><br />
                    <input type="hidden" id="edit-menu-item-icon-<?php echo $item_id; ?>" class="widefat code edit-menu-item-icon" name="menu-item-icon[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->custom ); ?>" />
                    
                    <a data-item="<?php echo $item_id; ?>" class="cbt_select_icon" href="#"><span ><i id="edit-menu-item-icon-preview-<?php echo $item_id; ?>" class="<?php echo esc_attr( $item->custom ); ?>"></i></span> Select icon</a> 
                </label>
            </p>
            

            <?php
            /*
             * end added field
             */
            ?>
            <div class="menu-item-actions description-wide submitbox">
                <?php if( 'custom' != $item->type && $original_title !== false ) : ?>
                    <p class="link-to-original">
                        <?php printf( __('Original: %s'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
                    </p>
                <?php endif; ?>
                <a class="item-delete submitdelete deletion" id="delete-<?php echo $item_id; ?>" href="<?php
                echo wp_nonce_url(
                    add_query_arg(
                        array(
                            'action' => 'delete-menu-item',
                            'menu-item' => $item_id,
                        ),
                        remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                    ),
                    'delete-menu_item_' . $item_id
                ); ?>"><?php _e('Remove'); ?></a> <span class="meta-sep"> | </span> <a class="item-cancel submitcancel" id="cancel-<?php echo $item_id; ?>" href="<?php echo esc_url( add_query_arg( array('edit-menu-item' => $item_id, 'cancel' => time()), remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) ) ) );
                    ?>#menu-item-settings-<?php echo $item_id; ?>"><?php _e('Cancel'); ?></a>
            </div>

            <input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo $item_id; ?>]" value="<?php echo $item_id; ?>" />
            <input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" />
            <input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object ); ?>" />
            <input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" />
            <input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" />
            <input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->type ); ?>" />
        </div><!-- .menu-item-settings-->
        <ul class="menu-item-transport"></ul>
    <?php
    $output .= ob_get_clean();
    }
}