<?php
if(!class_exists('Cbt_metaboxes'))
{
	class Cbt_metaboxes 
	{
		public $prefix = 'cbt_';
	
		function __construct()
		{
			//add_filter('cmb2_meta_boxes', array($this, 'pages_metabox'));
			//add_filter('cmb2_meta_boxes', array($this, 'posts_metabox'));
			
			add_action( 'cmb2_init', array($this, 'pages_metabox'));
			add_action( 'cmb2_init', array($this, 'posts_metabox'));
			
			add_action( 'cmb2_render_background', array($this, 'add_field_background'), 10, 5 );
			add_action( 'cmb2_render_dependent_text', array($this, 'add_field_dependent_text'), 10, 5 );
			add_action( 'cmb2_render_video_still', array($this, 'add_field_video_still'), 10, 5 );
			
			add_action( 'cmb2_render_videos_library', array($this, 'add_field_videos_library'), 10, 5 );

			add_action('wp_head', array($this, 'add_styles'));
		}
		
		
		function pages_metabox()
		{
			global $wp_registered_sidebars;
			$wp_registered_sidebars_list = array();
			if($wp_registered_sidebars) foreach($wp_registered_sidebars as $sidebar)
			{
				$wp_registered_sidebars_list[ $sidebar['id'] ] = $sidebar['name'];
			}
			
			
			$prefix = $this->prefix; // Prefix for all fields
			
			$metabox = new_cmb2_box( array(
				'id'            => 'page_settings',
				'title'         => __( 'Page Settings', 'cbt' ),
				'object_types'  => array( 'page', ), // Post type
				'context'       => 'normal',
				'priority'      => 'high',
				'show_names'    => true, // Show field names on the left
				// 'cmb_styles' => false, // false to disable the CMB stylesheet
				// 'closed'     => true, // true to keep the metabox closed by default
			) );
			
			$metabox->add_field( array(
				'name' => __( 'Google map height', 'cbt' ),
				'desc' => __( '', 'cbt' ),
				'id'   => $prefix . 'map_height',
				'type' => 'text_small',
				'default' => '300px',
			) );
			
			$metabox->add_field( array(
			    'name' => __('Sidebar', 'cbt'),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'sidebar',
			    'type' => 'select',
			    'options'=> $wp_registered_sidebars_list,
			    'default' => 'sidebar1',
			) );
		
			$metabox->add_field( array(
			    'name' => __('Layout', 'cbt'),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'layout',
			    'type' => 'select',
			    'options'=> array(
				    'default'=> 'Default',
				    'boxed'=> 'Boxed',
				    'wide'=> 'Wide',
			    ),
			    'default' => 'default',
			) );
			
			$metabox->add_field( array(
			    'name' => __('Background', 'cbt'),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'background',
			    'type' => 'select',
			    'options'=> array(
				    'default'=> 'Default',
				    'custom'=> 'Custom Image',
				    'library' => 'ProStyler Videos',
					'youtube' => 'Video (Youtube)',
					'hosted' => 'Video (Direct)',
			    ),
			    'default' => 'default',
			) );
			
			$metabox->add_field( array(
			    'name' => __('Custom Background', 'cbt'),
			    'dependency' => array(
			    	'field'=>$prefix . 'background', 
			    	'value'=>'custom'
			    ),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'custom_background',
			    'type' => 'background'
			) );
			
			
			$metabox->add_field( array(
			    'name' => __('ProStyler Video backgrounds', 'cbt'),
			    'dependency' => array(
			    	'field'=>$prefix . 'background', 
			    	'value'=>'library'
			    ),
			    'desc' => __('These are pre-made, ready to go video backgrounds', 'cbt'),
			    'id' => $prefix . 'video-background-library',
			    'type' => 'videos_library'
			) );
			
			
			$metabox->add_field( array(
			    'name' => __('Youtube URL', 'cbt'),
			    'dependency' => array(
			    	'field'=>$prefix . 'background', 
			    	'value'=>'youtube'
			    ),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'video-background-youtube',
			    'type' => 'dependent_text'
			) );
			
			$metabox->add_field( array(
			    'name' => __('Video URL (MP4)', 'cbt'),
			    'dependency' => array(
			    	'field'=>$prefix . 'background', 
			    	'value'=>'hosted'
			    ),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'video-background-hosted-mp4',
			    'type' => 'dependent_text'
			) );
			
			$metabox->add_field( array(
			    'name' => __('Video URL (WebM)', 'cbt'),
			    'dependency' => array(
			    	'field'=>$prefix . 'background', 
			    	'value'=>'hosted'
			    ),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'video-background-hosted-webm',
			    'type' => 'dependent_text'
			) );
			
			$metabox->add_field( array(
			    'name' => __('Video Still Image', 'cbt'),
			    'dependency' => array(
			    	'field'=>$prefix . 'background', 
			    	'value'=>array('hosted','youtube')
			    ),
			    'desc' => __('Used for mobile and browsers which dont support video', 'cbt'),
			    'id' => $prefix . 'video-background-still',
			    'type' => 'video_still'
			) );
			
			$metabox->add_field( array(
			    'name' => __('Hide Page Title?', 'cbt'),
			    'desc' => __('Yes', 'cbt'),
			    'id' => $prefix . 'hide_title',
			    'type' => 'checkbox'
			) );
			
			
			// ------------------------------------------------------
			//  
			// ------------------------------------------------------

			
			$metabox = new_cmb2_box( array(
				'id'            => 'sidebar_settings',
				'title'         => __( 'Select Sidebar', 'cbt' ),
				'object_types'  => array( 'page', ), // Post type
				'context'       => 'side',
				'priority'      => 'default',
				'show_names' => false, // Show field names on the left
				'show_on' => array( 'key' => 'page-template', 'value' => 'template-sidebar.php' ),
			) );
			
			
			$metabox->add_field( array(
			    'name' => __('Sidebar', 'cbt'),
			    'desc' => __('', 'cbt'),
			    'id' => $prefix . 'sidebar2',
			    'type' => 'select',
			    'options'=> $wp_registered_sidebars_list,
			    'default' => 'sidebar1',
			) );

		}
		
		
		function posts_metabox()
		{
			$prefix = $this->prefix; // Prefix for all fields
			
			$metabox = new_cmb2_box( array(
				'id'            => 'post_settings',
				'title'         => __( 'Post Settings', 'cbt' ),
				'object_types'  => array( 'post', ), // Post type
				'context'       => 'normal',
				'priority'      => 'high',
				'show_names'    => true, // Show field names on the left
				// 'cmb_styles' => false, // false to disable the CMB stylesheet
				// 'closed'     => true, // true to keep the metabox closed by default
			) );
		
			$metabox->add_field( array(
			    'name' => __('Hide Post Header?', 'cbt'),
			    'desc' => __('Yes', 'cbt'),
			    'id' => $prefix . 'hide_post_header',
			    'type' => 'checkbox'
			) );
		}
		
		
		
		function add_styles()
		{
			global $post, $cbt_options;
			
			if(! isset($post)) return;
			if(! isset($post->ID)) return;


			$background = get_post_meta( $post->ID, 'cbt_background', true );
			if($background == 'default') return;
			
			
			$page_layout = get_post_meta( $post->ID, 'cbt_layout', true );
			
			switch($page_layout)
			{
				case 'boxed':
					$boxed_layout = true;
				break;
				
				case 'wide':
					$boxed_layout = false;
				break;
				
				default:
					if($cbt_options['boxed_layout'] == '1') $boxed_layout = true;
					else $boxed_layout = false;
				break;
			}
			
			$template = get_post_meta( $post->ID, '_wp_page_template', true );
			
			$url = '';
			if($background == 'library')
			{
				$url = get_post_meta( $post->ID, 'cbt_video-background-library', true );
				$background = 'youtube';
			}
			
			if($background == 'youtube')
			{
				if(! $url) $url = get_post_meta( $post->ID, 'cbt_video-background-youtube', true );
				
				$url = trim($url);
				
				if(! $url) return;
				
				$cbt_options['video-background'] = 'youtube';
				$cbt_options['video-background-youtube'] = $url;
				$cbt_options['video-background-still'] = trim(get_post_meta( $post->ID, 'cbt_video-background-still', true ));
				
				
				if($boxed_layout==false)
				{
					//$style = 'body { background: transparent !important; }';
					$style = 'body #main_area { background: transparent !important; }';
				}
			}
			elseif($background == 'hosted')
			{
				$video_mp4 = trim(get_post_meta( $post->ID, 'cbt_video-background-hosted-mp4', true ));
				$video_webm = trim(get_post_meta( $post->ID, 'cbt_video-background-hosted-webm', true ));
				
				if(! $video_mp4 && ! $video_webm) return;
				
				$cbt_options['video-background'] = 'hosted';
				$cbt_options['video-background-hosted-mp4'] = $video_mp4;
				$cbt_options['video-background-hosted-webm'] = $video_webm;
				$cbt_options['video-background-still'] = trim(get_post_meta( $post->ID, 'cbt_video-background-still', true ));
				
				if($boxed_layout==false)
				{
					//$style = 'body { background: transparent !important; }';
					$style = 'body #main_area { background: transparent !important; }';
				}
			}
			elseif($background == 'custom')
			{
				$options = get_post_meta( $post->ID, 'cbt_custom_background', true );
				
				$upload_img = get_stylesheet_directory_uri() . '/library/admin/assets/images/upload.png';
				
				//echo '<pre>'.print_r($options, TRUE).'</pre>';
	
				$attachment = 'fixed';
				$position = 'top left';
				$repeat = 'repeat';
				$size = 'inherit';
				
				$options["background_image"] = $options["background-pattern-url"];
				
				$background_color = $options["background-color"];
				if(!$background_color OR $background_color == '#') $background_color = '';		
				
				
		    	if(preg_match('/upload\.png/i', $options["background_image"])) 
		    	{
		    		$options["background_image"] = $options['background-url'];
					$attachment = $options['background-attachment'];
					$position = $options['background-position'];
					$repeat = $options['background-repeat'];
					$size = $options['background-size'];
		    	}
		    	
		    	$style = 'body.boxed_layout';
		    	if(! $boxed_layout) 
		    	{
			    	$style = '#main_area';
		    	
				    if($template && $template=='template-blank.php')
				    {
					    $style = '
					    	#main_area { background: transparent !important; }
					    ';
					    
					    $style .= 'body.boxed_layout, body.page-template-template-blank';
				    }
			    }
	
			    $style .= '
				{
				 	background-image: url("'.$options["background_image"].'");
					background-position: '.$position.';
					background-repeat: '.$repeat.';
					'.(($background_color)?'background-color: '.$background_color.'!important;':'').'
					background-attachment: '.$attachment.';
					
					background-size: '.$size.';
					-moz-background-size: '.$size.';
					-webkit-background-size: '.$size.';
					-o-background-size: '.$size.';
				}
			    ';
		    }
		
			?>
			<style>
				<?php echo $style; ?>
			</style>	
			<?php
		}

		
		function add_field_videos_library($field_args, $value, $object_id, $object_type, $field_type_object)
		{
			?>
			<script type="text/javascript">
			jQuery(document).ready(function($) 
			{
				var elm = $('#<?php echo $field_type_object->_id( '_wrapper' )?>').closest('.cmb-row');
				
				<?php if(isset($field_args->args['dependency']) && $field_args->args['dependency']):?>
					
					elm.hide();
					
					
					var dependency = $('#<?php echo $field_args->args['dependency']['field']?>');
					if(dependency.val() == '<?php echo $field_args->args['dependency']['value']?>')
					{
						elm.show();
					}
					
					dependency.change(function ()
					{
						if($(this).val()=='<?php echo $field_args->args['dependency']['value']?>')
						{
							elm.show();
						}
						else
						{
							elm.hide();
						}
					});
				<?php endif;?>
				
				$('.cbt-metabox-background-field-patterns input[type="radio"]', elm).click(function ()
				{
					$('.cbt-metabox-background-field-patterns input[type="radio"]', elm).closest('li').removeClass('cbt-metabox-background-field-pattern-selected');
					
					if($(this).val() == '<?php echo $upload_img?>')
					{
						$('.cbt-metabox-background-upload', elm).show();
					}
					else
					{
						$('.cbt-metabox-background-upload', elm).hide();
					}
					
					$(this).closest('li').addClass('cbt-metabox-background-field-pattern-selected');
				});
				
			}); 
			</script>
			
			<div id="<?php echo $field_type_object->_id( '_wrapper' )?>" class="">
				
			<?php
				
			$meta_value = $value;
			$id = $field_type_object->_id();
			$name = $field_type_object->_name();
			
			$patterns = cbt_video_bgs_lib();
			?>
			
					<ul class="cbt-metabox-background-field-patterns cbt-metabox-imgs-library">
						
						<?php $i=0; foreach($patterns as $val=>$pattern): $i++;?>
						<li class="<?php echo ($value==$val)?'cbt-metabox-background-field-pattern-selected':'';?>">
							<label class="" for="<?php echo $field_type_object->_id( '-url-'.$i )?>">
								<input 
									<?php echo ($value==$val)?'checked="checked"':'';?> 
									type="radio" 
									class="" 
									id="<?php echo $field_type_object->_id( '-url-'.$i )?>" 
									name="<?php echo $field_type_object->_name()?>" 
									value="<?php echo $val?>"
								>
								<span style="width: 100px;height:56px;background-image: url(<?php echo $pattern['img']?>);"></span>
							</label>
						</li>
						<?php endforeach;?>
						
					</ul>
			
				<?php
					
				echo $field_type_object->_desc( true );
				?>
				
			</div>
			<?php
		}
		
		
		function add_field_dependent_text($field_args, $value, $object_id, $object_type, $field_type_object)
		{
			?>
			<script type="text/javascript">
			jQuery(document).ready(function($) 
			{
				<?php if(isset($field_args->args['dependency']) && $field_args->args['dependency']):?>
					var elm = $('#<?php echo $field_type_object->_id( '_wrapper' )?>').closest('.cmb-row');
					elm.hide();
					
					
					var dependency = $('#<?php echo $field_args->args['dependency']['field']?>');
					if(dependency.val() == '<?php echo $field_args->args['dependency']['value']?>')
					{
						elm.show();
					}
					
					dependency.change(function ()
					{
						if($(this).val()=='<?php echo $field_args->args['dependency']['value']?>')
						{
							elm.show();
						}
						else
						{
							elm.hide();
						}
					});
				<?php endif;?>
			}); 
			</script>
			
			<div id="<?php echo $field_type_object->_id( '_wrapper' )?>" class="">
				
			<?php
				
			$meta_value = $value;
			$id = $field_type_object->_id();
			$name = $field_type_object->_name();
						
			echo $field_type_object->input( array(
				'type'  => 'text',
				'id'=>$id,
				'name'=>$name,
				'value' => $meta_value,
				'class' => 'regular-text',
				'desc'  => '',
			) );
			?>
			
				<?php
					
				echo $field_type_object->_desc( true );
				?>
				
			</div>
			<?php
		}
		
		
		function add_field_video_still($field_args, $value, $object_id, $object_type, $field_type_object)
		{
			?>
			<script type="text/javascript">
			jQuery(document).ready(function($) 
			{
				<?php if(isset($field_args->args['dependency']) && $field_args->args['dependency']):?>
					var elm = $('#<?php echo $field_type_object->_id( '_wrapper' )?>').closest('.cmb-row');
					elm.hide();
					
					
					var dependency = $('#<?php echo $field_args->args['dependency']['field']?>');
					if(dependency.val() == 'youtube' || dependency.val() == 'hosted' || dependency.val() == 'library')
					{
						elm.show();
					}
					
					dependency.change(function ()
					{
						if($(this).val() == 'youtube' || $(this).val() == 'hosted' || $(this).val() == 'library')
						{
							elm.show();
						}
						else
						{
							elm.hide();
						}
					});
				<?php endif;?>
			}); 
			</script>
			
			<div id="<?php echo $field_type_object->_id( '_wrapper' )?>" class="">
				
			<?php
				
			$meta_value = $value;
			$id = $field_type_object->_id();
			$name = $field_type_object->_name();
			
				
						echo $field_type_object->input( array(
							'type'  => 'text',
							'id'=>$id,
							'name'=>$name,
							'value' => $meta_value,
							'class' => 'cmb2-upload-file regular-text',
							'size'  => 45,
							'desc'  => '',
							'data-previewsize' => 350,
						) );
				
						printf( '<input class="cmb2-upload-button button" type="button" value="%s" />', __( 'Add or Upload Image', 'cbt' ));
							
							
						$cached_id = $id;
						
						// Reset field args for attachment ID
						$args = $field_type_object->field->args();
						$args['id'] = $cached_id . '_id';
						$args['name'] = $name;
						unset( $args['_id'], $args['_name'] );
				
						// And get new field object
						$field_type_object->field = new CMB2_Field( array(
							'field_args'  => $args,
							'group_field' => $field_type_object->field->group,
							'object_type' => $field_type_object->field->object_type,
							'object_id'   => $field_type_object->field->object_id,
						) );
				
						// Get ID value
						$_id_value = $field_type_object->field->escaped_value( 'absint' );
				
						// If there is no ID saved yet, try to get it from the url
						if ( $meta_value && ! $_id_value ) {
							$_id_value = cmb2_utils()->image_id_from_url( esc_url_raw( $meta_value ) );
						}
				
						echo $field_type_object->input( array(
							'type'  => 'hidden',
							'class' => 'cmb2-upload-file-id',
							'value' => $_id_value,
							'desc'  => '',
						) ),
						'<div id="', $field_type_object->_id( '-status' ), '" class="cmb2-media-status">';
							if ( ! empty( $meta_value ) ) {
				
								if ( $field_type_object->is_valid_img_ext( $meta_value ) ) 
								{
				
									$size = 350;
									$image = '<img style="max-width: ' . absint( $size ) . 'px; width: 100%; height: auto;" src="' . $meta_value . '" alt="" />';
				
									$field_type_object->img_status_output( array(
										'image'     => $image,
										'tag'       => 'div',
										'cached_id' => $cached_id,
									) );
				
								}
							}
						echo '</div>';
						?>
			
				<?php
					
				echo $field_type_object->_desc( true );
				?>
				
			</div>
			<?php
		}
		
		
		function add_field_background($field_args, $value, $object_id, $object_type, $field_type_object)
		{
			
			$patterns = cbt::scandir(get_stylesheet_directory() . '/library/images/patterns', array('png', 'gif', 'jpg'));
			foreach($patterns as $pattern=>$pattern_path)
			{
				$img = get_stylesheet_directory_uri() . '/library/images/patterns/'.$pattern;
				$patterns_out[] = $img;
			}
			
			$patterns_out[] = $upload_img = get_stylesheet_directory_uri() . '/library/admin/assets/images/upload.png';
			
			$patterns = $patterns_out;
			
			
			$repeat = array(
                        'no-repeat' => 'No Repeat',
                        'repeat'    => 'Repeat All',
                        'repeat-x'  => 'Repeat Horizontally',
                        'repeat-y'  => 'Repeat Vertically',
                        //'inherit'   => 'Inherit',
		            );
		            
			$position = array(
                        'left top'      => 'Left Top',
                        'left center'   => 'Left center',
                        'left bottom'   => 'Left Bottom',
                        'center top'    => 'Center Top',
                        'center center' => 'Center Center',
                        'center bottom' => 'Center Bottom',
                        'right top'     => 'Right Top',
                        'right center'  => 'Right center',
                        'right bottom'  => 'Right Bottom',
		            );
		            
			$size = array(
						'inherit'  => 'Normal (Inherit)',
                        'cover' => 'Cover',
                        'contain'    => 'Contain',
		            );
		            
			$attachment = array(
                        'fixed'   => 'Fixed',
                        'scroll'  => 'Scroll',
		            );
		          
		    // ------------------------------------------------------
		    //  
		    // ------------------------------------------------------  
			$options = '';
			foreach ( $repeat as $abrev => $state ) 
			{
				$options .= '<option value="'. $abrev .'" '. selected( $value['background-repeat'], $abrev, false ) .'>'. $state .'</option>';
			}
			
			$repeat_field = $field_type_object->select( array(
				            'name'    => $field_type_object->_name( '[background-repeat]' ),
				            'id'      => $field_type_object->_id( 'background-repeat' ),
				            'desc'    => '',
				            'options' => $options,
				        ) );
			
			
			// ------------------------------------------------------
			//  
			// ------------------------------------------------------
			$options = '';
			foreach ( $position as $abrev => $state ) 
			{
				$options .= '<option value="'. $abrev .'" '. selected( $value['background-position'], $abrev, false ) .'>'. $state .'</option>';
			}
			
			$position_field = $field_type_object->select( array(
				            'name'    => $field_type_object->_name( '[background-position]' ),
				            'id'      => $field_type_object->_id( 'background-position' ),
				            'desc'    => '',
				            'options' => $options,
				        ) );
			
			
			// ------------------------------------------------------
			//  
			// ------------------------------------------------------
			$options = '';
			foreach ( $size as $abrev => $state ) 
			{
				$options .= '<option value="'. $abrev .'" '. selected( $value['background-size'], $abrev, false ) .'>'. $state .'</option>';
			}
			
			$size_field = $field_type_object->select( array(
				            'name'    => $field_type_object->_name( '[background-size]' ),
				            'id'      => $field_type_object->_id( 'background-size' ),
				            'desc'    => '',
				            'options' => $options,
				        ) );
			
			
			// ------------------------------------------------------
			//  
			// ------------------------------------------------------
			$options = '';
			foreach ( $attachment as $abrev => $state ) 
			{
				$options .= '<option value="'. $abrev .'" '. selected( $value['background-attachment'], $abrev, false ) .'>'. $state .'</option>';
			}
			
			$attachment_field = $field_type_object->select( array(
				            'name'    => $field_type_object->_name( '[background-attachment]' ),
				            'id'      => $field_type_object->_id( 'background-attachment' ),
				            'desc'    => '',
				            'options' => $options,
				        ) );
			
			
			// ------------------------------------------------------
			//  
			// ------------------------------------------------------
			$meta_value = $value['background-color'];
			$id = $field_type_object->_id('color');
			$name = $field_type_object->_name( '[background-color]' );
			
			$hex_color = '(([a-fA-F0-9]){3}){1,2}$';
			if ( preg_match( '/^' . $hex_color . '/i', $meta_value ) ) {
				// Value is just 123abc, so prepend #
				$meta_value = '#' . $meta_value;
			} elseif ( ! preg_match( '/^#' . $hex_color . '/i', $meta_value ) ) {
				// Value doesn't match #123abc, so sanitize to just #
				$meta_value = '#';
			}
	
			$color_field = $field_type_object->input( array( 'class' => 'cmb2-colorpicker cmb2-text-small', 'value' => $meta_value, 'name'=>$name, 'id'=>$id ) );	
						
			
			
			global $cbt_options; 
			?>
			<script type="text/javascript">
			jQuery(document).ready(function($) 
			{
				<?php if(isset($field_args->args['dependency']) && $field_args->args['dependency']):?>
					var default_boxed = <?php echo ($cbt_options['boxed_layout'] == '1')?'true':'false'?>;
					
					var elm = $('#<?php echo $field_type_object->_id( '_wrapper' )?>').closest('.cmb-row');
					elm.hide();
					
					var dependency = $('#<?php echo $field_args->args['dependency']['field']?>');
					if(dependency.val() == '<?php echo $field_args->args['dependency']['value']?>')
					{
						elm.show();
					}
					
					dependency.change(function ()
					{
						if($(this).val()=='<?php echo $field_args->args['dependency']['value']?>')
						{
							elm.show();
						}
						else
						{
							elm.hide();
						}
					});
				<?php endif;?>
				
				$('.cbt-metabox-background-upload', elm).hide();
				
				if($('.cbt-metabox-background-field-patterns input[type="radio"]:checked', elm).val() == '<?php echo $upload_img?>')
				{
					$('.cbt-metabox-background-upload', elm).show();
				}
				
				$('.cbt-metabox-background-field-patterns input[type="radio"]', elm).click(function ()
				{
					$('.cbt-metabox-background-field-patterns input[type="radio"]', elm).closest('li').removeClass('cbt-metabox-background-field-pattern-selected');
					
					if($(this).val() == '<?php echo $upload_img?>')
					{
						$('.cbt-metabox-background-upload', elm).show();
					}
					else
					{
						$('.cbt-metabox-background-upload', elm).hide();
					}
					
					$(this).closest('li').addClass('cbt-metabox-background-field-pattern-selected');
				});
				
				
			}); 
			</script>
			
			<div id="<?php echo $field_type_object->_id( '_wrapper' )?>" class="">
				<div class="alignleft">
					<ul class="cbt-metabox-background-field-patterns">
						
						<?php $i=0; foreach($patterns as $pattern): $i++;?>
						<li class="<?php echo ($value['background-pattern-url']==$pattern)?'cbt-metabox-background-field-pattern-selected':'';?>">
							<label class="" for="<?php echo $field_type_object->_id( 'background-pattern-url-'.$i )?>">
								<input <?php echo ($value['background-pattern-url']==$pattern)?'checked="checked"':'';?> type="radio" class="" id="<?php echo $field_type_object->_id( 'background-pattern-url-'.$i )?>" name="<?php echo $field_type_object->_name( '[background-pattern-url]' )?>" value="<?php echo $pattern?>">
								<span style="background-image: url(<?php echo $pattern?>);"></span>
							</label>
						</li>
						<?php endforeach;?>
						
					</ul>
				</div>
				
				<div class="cbt-metabox-background-upload">    
				    <div class="">
						<?php
							
						$meta_value = $value['background-url'];
						$id = $field_type_object->_id('url');
						$name = $field_type_object->_name( '[background-url]' );
				
						echo $field_type_object->input( array(
							'type'  => 'text',
							'id'=>$id,
							'name'=>$name,
							'value' => $meta_value,
							'class' => 'cmb2-upload-file regular-text',
							'size'  => 45,
							'desc'  => '',
							'data-previewsize' => 350,
						) );
				
						printf( '<input class="cmb2-upload-button button" type="button" value="%s" />', __( 'Add or Upload Image', 'cbt' ));
							
							
						$cached_id = $id;
						
						// Reset field args for attachment ID
						$args = $field_type_object->field->args();
						$args['id'] = $cached_id . '_id';
						$args['name'] = $name;
						unset( $args['_id'], $args['_name'] );
				
						// And get new field object
						$field_type_object->field = new CMB2_Field( array(
							'field_args'  => $args,
							'group_field' => $field_type_object->field->group,
							'object_type' => $field_type_object->field->object_type,
							'object_id'   => $field_type_object->field->object_id,
						) );
				
						// Get ID value
						$_id_value = $field_type_object->field->escaped_value( 'absint' );
				
						// If there is no ID saved yet, try to get it from the url
						if ( $meta_value && ! $_id_value ) {
							$_id_value = cmb2_utils()->image_id_from_url( esc_url_raw( $meta_value ) );
						}
				
						echo $field_type_object->input( array(
							'type'  => 'hidden',
							'class' => 'cmb2-upload-file-id',
							'value' => $_id_value,
							'desc'  => '',
						) ),
						'<div id="', $field_type_object->_id( '-status' ), '" class="cmb2-media-status">';
							if ( ! empty( $meta_value ) ) {
				
								if ( $field_type_object->is_valid_img_ext( $meta_value ) ) 
								{
				
									$size = 350;
									$image = '<img style="max-width: ' . absint( $size ) . 'px; width: 100%; height: auto;" src="' . $meta_value . '" alt="" />';
				
									$field_type_object->img_status_output( array(
										'image'     => $image,
										'tag'       => 'div',
										'cached_id' => $cached_id,
									) );
				
								}
							}
						echo '</div>';
						?>
					</div>
				
				
				
				    <div class="alignleft" style="margin: 10px 0 0px;">
					    <div class="cbt-metabox-background-option-selector">
				        Repeat:<br /><?php echo $repeat_field; ?>
				        </div>
				        
				        <div class="cbt-metabox-background-option-selector">
				        Position:<br /><?php echo $position_field; ?>
				        </div>
				        
				        <div class="cbt-metabox-background-option-selector">
				        Size:<br /><?php echo $size_field; ?>
				        </div>
				        
				        <div class="cbt-metabox-background-option-selector">
				        Attachment:<br /><?php echo $attachment_field; ?>
				        </div>
				    </div>

				
				</div>
				
			    <div class="alignleft" style="margin: 10px 0 0px;width: 100%;">
				
					Background color:<br /><?php echo $color_field; ?>
				
				</div>
				
				<?php
					
				echo $field_type_object->_desc( true );
				?>
				
			</div>
			<?php
		}
	
		
	}
	
	// ------------------------------------------------------
	//  initialize the class
	// ------------------------------------------------------
	new Cbt_metaboxes();
}