<?php
	
	
class cbt_pro
{
	public $is_pro = false;
	public $is_unbranded = false;
	public $is_options_panel_unlocked = false;

	function __construct()
	{
		add_action('init', array( $this, 'init' ), 10);
	}
	
	function init()
	{
		$this->is_pro = (get_option('cbt_pro_upgrade')=='yes')? true : false ;
		
		if($this->is_pro == false)
		{
			return false;
		}
		
		$this->unbranded();
	}
	
	function unbranded()
	{
		global $cbt_options;
		
		$this->is_unbranded = ($cbt_options['unbranded-mode']=='1') ? true : false ;
		if($this->is_unbranded == false) return false;
		
		$this->is_options_panel_unlocked = ($cbt_options['lock-options-panel']=='1') ? false : true ;
		
		if (!session_id()) {
		    session_start();
		}
	
		if(isset($_SESSION) && isset($_SESSION['options-panel-password'])
			&& $_SESSION['options-panel-password']==$cbt_options['options-panel-password'] )
		{
			$this->is_options_panel_unlocked = true;
		}
		
		add_filter( 'admin_body_class', array($this, 'add_admin_body_class') );
		add_action('wp_before_admin_bar_render', array($this, 'unbrand_admin_bar'), 0);
		add_action('wp_logout', array($this, 'unbranded_session_remove'));
	}
	
	
	function add_admin_body_class( $classes )
	{
		$class = 'cbt-unbranded';
		if($this->is_options_panel_unlocked==false) $class .= ' cbt-panel-locked';
		
		return "$classes $class";
	}
	
	
	function unbrand_admin_bar()
	{
		global $wp_admin_bar;
		
		$wp_admin_bar->remove_menu('cbt_options');
	}
	
	
	// ------------------------------------------------------
	//  Pro upgrade unbranded session remover
	// ------------------------------------------------------
	function unbranded_session_remove()
	{
		if (!session_id()) {
		    session_start();
		}
	
		if(isset($_SESSION) && isset($_SESSION['options-panel-password']))
		{
			unset( $_SESSION['options-panel-password'] );
		}
	}


	
}

global $cbt_pro;
$cbt_pro = new cbt_pro();