<?php

class Cbx_compilers
{

	public $less_dir;

	function __construct()
	{
		$this->less_dir = get_template_directory().'/library/less';
	
		add_filter('redux/options/cbt_options/compiler', array( $this, 'generate_css' ), 10, 3);
		
		if(get_option('cbt_do_auto_redux_compiler')=='yes' 
			OR (isset($_GET['cbt_action']) && $_GET['cbt_action']=='force_regenerate_css' ) ) 
		{
			add_action('init', array( $this, 'generate_css' ), 1);
			update_option('cbt_do_auto_redux_compiler', 'no');
		}
	}
	
	
	function generate_css($options='', $css='', $changed_values='')
	{

		if(! $options)
		{
			global $cbt_options;
			$options = $cbt_options;
		}

		if( cbt::increase_memory() === false )
		{
			echo '<h2 class="cbt-fatal-error">Stylesheet not generated. Please increase your server\'s memory limit to atleast 256M.<br /><br />If you don\'t know how to do that then please contact your hosting provider.</h2>';
			return false;;
		}


		require_once dirname( __FILE__ ) . '/less.php/Less.php';


	    $parser = new Less_Parser(array( 'compress'=>true ));
	    
	    $parse_prepend = '';
	    $parse = '';
	    
	    $library_url = get_template_directory_uri().'/library/';
	    
	    $vars = array(
		    'library-url' => $library_url,
	    	'mode-file'=> 'default-mode-variables',
	    	
	    	'logo-text-color'=>'#fff',
	    	'logo-max-height' => '80',
	    	
	    	'default-font-size' => '16.5',
	    	
	    	'content-bg' => '#fff',
	    	'content-bg-opacity' => '100',
	    	'content-bg-contrast' => 'darken(@gray-lighter, 10%)',
	    	
			'color1' => '#10131C',
			'color2' => '#FF8A00',
			'footer_bg' => '#1A1F2F',
			'page-heading-color'=> '#fff',
			'info-box-bg' => '#121620',
			'info-box-text-color' => '#fff',
			'top-nav-color'=>'@color1',
			'top-nav-text-color'=>'#d9d9d9',
			'sub-floor-color'=>'@color1',
			
			
			'brand-primary' =>         '@color2',
			
			
			'text-color' =>            '#626B75',
			'text-color_dark_areas' =>            '#d9d9d9',
			'nav-text-color'=> '#fff',
			'nav-hover-color'=>'@color2',
			
			'btn-default-color' =>              '#fff',
			'btn-default-bg' =>                 '#CCCCCC',
			'btn-default-border' =>             'darken(@btn-default-bg, 10%)',
			
			'btn-primary-color' =>              '#fff',
			'btn-primary-bg' =>                 '@color2',
			'btn-primary-border' =>             'darken(@color2, 5%)',
			
			'header-color' => '#fff',
			'header-repeat' => 'no-repeat',
			
			'nav-color' => '#dcdcdc',
			'nav-mobile-color-v2' => '@color1',
			'nav-mobile-text-color-v2'=> '#fff',
			'nav-mobile-btn-color'=> '@color2',
			'nav-opacity' => '20',
			'nav-pattern-opacity' => '100',
			
			'info-box-pattern-opacity' => '100',

			'footer-pattern-opacity' => '100',
			
			'header2-text-color' => '#fff',
			'header2-bg' => '#121620',
			'header2-pattern-opacity' => '100',
			
			'header4-text-color' => '#A8A8A9',
			'header4-bg' => '#fff',
			'header4-no-bg-text-color' => '#fff',
	    );
	    
	    $patterns = array(
			"nav-pattern-url" => $library_url."images/patterns/pattern.png",
			"footer-pattern-url" => $library_url."images/patterns/cross.png",
			"info-box-pattern-url" => $library_url."images/patterns/cross.png",
			"header2-pattern-url" => $library_url."images/patterns/cross.png",
	    );

	    $vars = array_merge($vars, $patterns);
	    
	    if($options['dark-mode'] == '1') $vars['mode-file'] = 'dark-mode-variables';
	    

	    
		//boxed css
		//if(!empty($options['boxed_layout']) && $options['boxed_layout'] == '1')  
		//{
			$attachment = 'fixed';
			$position = 'top left';
			$repeat = 'repeat';
			$size = 'inherit';
			$background_color = $options["background-color"];		
			$options["background_image"] = $options["background-pattern-url"];
			
	    	if(preg_match('/upload\.png/i', $options["background_image"])) 
	    	{
	    		$options["background_image"] = $options["custom-background"]['background-image'];
				$attachment = $options["custom-background"]['background-attachment'];
				$position = $options["custom-background"]['background-position'];
				$repeat = $options["custom-background"]['background-repeat'];
				$size = $options["custom-background"]['background-size'];
	    	}
	    	
		    $parse .= '
			body.boxed_layout
			{
			 	background-image: url("'.$options["background_image"].'");
				background-position: '.$position.';
				background-repeat: '.$repeat.';
				background-color: '.$background_color.'!important;
				background-attachment: '.$attachment.';
				
				background-size: '.$size.';
				-moz-background-size: '.$size.';
				-webkit-background-size: '.$size.';
				-o-background-size: '.$size.';
			}
		    ';
	    //}
	    
	    if(!empty($options["header-cover"])) $parse .= '
			#slider_area.no_slide .nav_bg
			{
				background-size: cover !important;
				-moz-background-size: cover !important;
				-webkit-background-size: cover !important;
				-o-background-size: cover !important;
			}
	    ';

	    
	    if(!empty($options["custom-css"])) $parse .= strip_tags($options["custom-css"]);


	    foreach($vars as $key=>$val)
	    {
		    if(isset($options[$key]) && (is_numeric($options[$key]) OR is_bool($options[$key]) OR trim($options[$key]))) 
		    	$vars[$key] = $options[$key];
		    else
		    	$vars[$key] = $val;
		    
		    // Strings e.g urls need to be enclosed in quotes
		    if(preg_match('/\-url/', $key)) 
		    {
		    	// remove http for ssl
			    $vars[$key] = str_ireplace('http://', '//', $vars[$key]);
			    $vars[$key] = "'".$vars[$key]."'";
			 }
	    }

	    if(! $vars['nav-opacity']) $vars['nav-opacity'] = 20;
	    
	    
	    
	    
	    // ------------------------------------------------------
	    //  Creates a background mixin if its a gradient or uploaded image. 
	    //  Incase of uploaded image, full css is generated using its alt field
	    // ------------------------------------------------------
	    foreach($patterns as $pattern=>$pattern_default_img)
	    {
		    
		    
	    	if(preg_match('/upload\.png/i', $vars[$pattern])) 
	    	{
		    	$vars[$pattern] = '"'.get_stylesheet_directory_uri() . '/library/images/patterns/blank.gif"';
		    	

		    	$alt = $pattern.'-alt';
		    	$alt = $options[$alt];
		    	if($alt['background-image'])
		    	{
			    	if($alt['background-size']=='inherit') $alt['background-size'] = '';
			    	if($alt['background-attachment']=='inherit') $alt['background-attachment'] = '';
			    	if($alt['background-repeat']=='inherit') $alt['background-repeat'] = '';
			    	if($alt['background-position']=='inherit') $alt['background-position'] = '';
			    	
				    $parse_prepend .= '.'.$pattern.'-size(){';
				    
				    	$parse_prepend .= 'background: url("'.$alt['background-image'].'") '.$alt['background-repeat'].' '.$alt['background-attachment'].' '.$alt['background-position'].' !important;';
				    
				    	$parse_prepend .= '
							background-size: '.$alt['background-size'].' !important;
							-moz-background-size: '.$alt['background-size'].' !important;
							-webkit-background-size: '.$alt['background-size'].' !important;
							-o-background-size: '.$alt['background-size'].' !important;
						';
						
				    $parse_prepend .= '}';
				    		    	
		    		continue;
		    	}
	    	}
	    
		    if(preg_match('/gradient/i', $vars[$pattern])) 
		    	$parse_prepend .= '.'.$pattern.'-size()
				{
					background-size: contain !important;
					-moz-background-size: contain !important;
					-webkit-background-size: contain !important;
					-o-background-size: contain !important;
				}
		    	';
		    else
		    	$parse_prepend .= '.'.$pattern.'-size() {  }';
	    }

		try
		{
		    $parser->ModifyVars($vars);
		    $parser->parse($parse_prepend);
		    $parser->parseFile($this->less_dir.'/style.less', get_template_directory_uri().'/library');
		    $parser->parse($parse);
	
		    $css = $parser->getCss();
		    
		    $save_to_dir = get_template_directory().'/library/css/';
		    
		    $save_to = $save_to_dir.'style.css';
		    if(is_multisite())
		    {
			    $save_to = $save_to_dir.'style-blog-'.get_current_blog_id().'.css';
		    }
		    
		    // first try normally saving
		    if(file_put_contents($save_to, $css)===false)
		    {
			    global $wp_filesystem;
			    
			    // else check if wp file system is available
			    if($wp_filesystem && method_exists($wp_filesystem, 'put_contents'))
			    {
				    // try using wp filesystem to save
				    if(! $wp_filesystem->put_contents($save_to, $css))
				    {
					    // if failed then show message
						if (!is_dir($save_to_dir) or !is_writable($save_to_dir)) 
						{
						    echo '<h1 class="cbt-fatal-error">CSS Failed. Please change the permission of the following folder to writable (755)<p>'.$save_to_dir.'</p></h1>';
						    return false;
						    
						} elseif (is_file($save_to) and !is_writable($save_to)) {
							
						    // Error if the file exists and isn't writable.
						    echo '<h1 class="cbt-fatal-error">CSS Failed. Please change the permission of the following file to writable (755)<p>'.$save_to.'</p></h1>';
						    return false;
						}
				    }
			    }
			    else // if no wp filesystem is available then show message
			    {
					if (!is_dir($save_to_dir) or !is_writable($save_to_dir)) 
					{
					    echo '<h1 class="cbt-fatal-error">CSS Failed. Please change the permission of the following folder to writable (755)<p>'.$save_to_dir.'</p></h1>';
					    return false;
					    
					} elseif (is_file($save_to) and !is_writable($save_to)) {
						
					    // Error if the file exists and isn't writable.
					    echo '<h1 class="cbt-fatal-error">CSS Failed. Please change the permission of the following file to writable (755)<p>'.$save_to.'</p></h1>';
					    return false;
					}
				}
			}
		} 
		catch (Exception $e) 
		{
			update_option('cbt_do_auto_redux_compiler', 'no');
			
			echo '<h1 class="cbt-fatal-error">CSS Failed. Please make sure to enter valid CSS values and properties.</h1>';
			echo $e->getMessage();
			return false;
		}
		
		update_option('cbt_cache_string', time());
	    
	    $this->change_content_colors($changed_values);
	    
	    if(isset($_GET['cbt_action']) && $_GET['cbt_action']=='force_regenerate_css')
	    {
		    @header('location: '.admin_url().'admin.php?page=cbt_options&tab=0&cbt_success='.urlencode('Stylesheet regenerated successfully !'));
		    
		    echo '<h1 class="cbt-success">Stylesheet regenerated successfully !</h1>';
	    }
	    
	}
	
	
	function change_content_colors($changed_values)
	{
		if(! $changed_values OR ! is_array($changed_values)) return;
		
		global $cbt_options;
		
		$process_content = false;
		
		$colors_vars = array('color1', 'color2');
		
		$colors_to_change = array();
		
		foreach($changed_values as $key=>$val)
		{
			if(in_array($key, $colors_vars) && isset($cbt_options[ $key ]))
			{
				$val = strtolower($val);
				if($val=='#fff' OR $val=='#ffffff' OR $val=='#000' OR $val=='#000000')
				{
					continue;
				}
				
				$process_content = true;
				$colors_to_change[ $val ] = strtolower($cbt_options[ $key ]);
			}
		}
		
		if($process_content==false) return false;
		

		$pages = get_posts(array(
			'posts_per_page' => -1,
			'post_type'        => 'page',
		));
		
		if(! $pages) return;
				
		foreach($pages as $post)
		{
			$content = $post->post_content;
			if(! trim($content)) continue;
			
			$new_content = $content;

			foreach($colors_to_change as $change_from=>$change_to)
			{
				$new_content = preg_replace('/'.$change_from.'/i', $change_to, $new_content);
			}
			
			
			$builder_content = get_post_meta( $post->ID, '_wr_page_builder_content', true );
			if(trim($builder_content))
			{
				$new_builder_content = $builder_content;
				foreach($colors_to_change as $change_from=>$change_to)
				{
					$new_builder_content = preg_replace('/'.$change_from.'/i', $change_to, $new_builder_content);
				}
				
				if($new_builder_content != $builder_content)
				{
					update_post_meta( $post->ID, '_wr_page_builder_content', $new_builder_content);
				}
				
			}
			
			
			if($new_content == $content) continue;
			
			$update = wp_update_post(array(
				'ID' => $post->ID,
				'post_content' => $new_content,
			), true);
		}
		
		
		
	}
	
	

}

new Cbx_compilers;

