<?php
/**
 * @To-do:
 * - RevSlider (selected sliders)
 * - Widgets export
 * - Config file (set homepage, nav etc)
 * - Zip
 */

require_once dirname( __FILE__ ) . '/helpers.php';

class cbt_export
{
    public function __construct()
    {
        add_action('wp_ajax_cbt_export_template', array($this, 'STEP_1'));
        add_action('wp_ajax_cbt_export_template_step2', array($this, 'STEP_2'));

        if(isset($_GET['download_template']) && $_GET['download_template'])
        {
            $this->STEP_3();
        }

        // $_POST['sliders'] = array('1');
        // add_action('in_admin_header', array($this, 'STEP_2'));
        // add_action('admin_init', array($this, 'admin_init'));
    }

    public function admin_init()
    {
        if (isset($_GET['cbt_export_template']) && $_GET['cbt_export_template'] == '1') {
            // add_action('in_admin_header', array($this, 'STEP_1'));
            // add_action('in_admin_header', array($this, 'STEP_2'));

        }
    }

    /**
     * INIT STEP 1 - show selection interface
     * @return null
     */
    public function STEP_1()
    {
        ?>
        <fieldset>
            <legend>Template name:</legend>
            <input type="text" id="cbt_template_name" />
        </fieldset>
        <br />
		<fieldset>
			<legend>Include in Template (posts, pages, media etc are always included):</legend>
			<div id="cbt_tree_includes"></div>
            <div id="cbt_tree_options"></div>
            <div id="cbt_tree_sliders"></div>
		</fieldset>

    	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.2.1/themes/default/style.min.css" />

    	<p>
    		<button class="button-primary" id="cbt-btn-template-export-step2">Export</button>
    	</p>

    	<script>
			jQuery(document).ready(function(){
				var $ = jQuery;
				$('#cbt_tree_includes').jstree({
					'core' : {
				    	'data' : [
				    		// { id: 'pages', text: 'Pages', state: { selected: true } },
				    		// { id: 'posts', text: 'Posts', state: { selected: true } },
				    		
				    		{ id: 'widgets', text: 'Widgets', state: { selected: true } },
				    	]
					},
					"plugins" : [ "wholerow", "checkbox" ]
				}).bind("ready.jstree", function (event, data) {
			    	$('#cbt_tree_includes').jstree(true).close_all();
			    });

				$('#cbt_tree_options').jstree({
                    'core' : {
                        'data' : [
                            { 
                                id: 'theme_options', 
                                text: 'Theme Options', 
                                state: { selected: true }, 
                                children: <?php echo json_encode($this->tree_getReduxOptions()); ?> 
                            },
                        ]
                    },
					"plugins" : [ "wholerow", "checkbox" ]
				}).bind("ready.jstree", function (event, data) {
			    	$('#cbt_tree_options').jstree(true).close_all();
			    });

				$('#cbt_tree_sliders').jstree({
                    'core' : {
                        'data' : [
                            { 
                                id: 'revslider', 
                                text: 'RevolutionSlider Sliders', 
                                state: { selected: false }, 
                                children: <?php echo json_encode($this->tree_getRevSliders()); ?> 
                            },
                        ]
                    },
					"plugins" : [ "wholerow", "checkbox" ]
				}).bind("ready.jstree", function (event, data) {
			    	$('#cbt_tree_sliders').jstree(true).close_all();
			    });

			    $('#cbt-btn-template-export-step2').click(function () {

                    var template_name = $('input#cbt_template_name').val();
					var include = $('#cbt_tree_includes').jstree('get_selected');
					var options = $('#cbt_tree_options').jstree('get_selected');
					var sliders = $('#cbt_tree_sliders').jstree('get_selected');

					cbt_dialog('loader');

					jQuery.ajax(
					{
						url: ajaxurl,
						type: 'post',
						data: {
							action: 'cbt_export_template_step2',
                            template_name: template_name,
							include: include,
							sliders: sliders,
							options: options
						},
						success: function(data)
						{
							cbt_dialog(data);
						}
					});
			    	return false;
			    });
			});
    	</script>

    	<?php

        die();
    }


    /**
     * INIT STEP 2 - Make final template package
     * with the options selected in step1
     * @return Download button to Zip file
     */
    public function STEP_2()
    {
        global $wp_filesystem;

        $this->template_name = (isset($_POST['template_name']) && trim($_POST['template_name'])) ? $_POST['template_name'] : 'template_export-'.time();
        $this->template_foldername = sanitize_title( $this->template_name );
        $upload_dir = wp_upload_dir();
        $this->save_dir = $upload_dir['path'].'/'.$this->template_foldername.'/'.$this->template_foldername;
        wp_mkdir_p($this->save_dir);

        $this->wpExport();
        $this->attachments();
        $this->config();
        $this->revSlider();
        $this->widgets();
        $this->reduxOptions();
        if($this->zip() === false)
        {
            echo 'ZIP Failed';
            die();
        }

        // delete folder
        $wp_filesystem->rmdir( dirname($this->save_dir), true );

        header('Content-Description: File Transfer');
        header('Content-Type: text/html; charset=UTF-8');
        header("Content-Disposition: inline");
        ?>
        <p style="text-align: center;">
            <a class="button-primary" href="<?php echo admin_url('?download_template='.$this->template_foldername.'.zip'); ?>" >Download Template</a>
        </p>
        <?php
        die();
    }


    /**
     * INIT STEP 3 - Deliver download file
     * @return none
     */
    function STEP_3()
    {
        $template = (isset($_GET['download_template']) && $_GET['download_template']) ? $_GET['download_template'] : '';
        if(! $template)
        {
            echo 'Download file not specified';
            die();
        }

        $upload_dir = wp_upload_dir();
        $this->save_dir = $upload_dir['path'].'/'.$template;


        if($this->download($this->save_dir, true) === false)
        {
            echo 'ZIP Download Failed';
            die();
        }

        die();
    }


    /**
     * Makes nested array of revslider sliders for JSTree
     * @return array
     */
    public function tree_getRevSliders()
    {
        global $wpdb;

        if(! class_exists('RevSlider')) return array();

        $rs = $wpdb->get_results(
            "
SELECT id, title, alias
FROM " . $wpdb->prefix . "revslider_sliders
ORDER BY id ASC LIMIT 999
"
        );

        if(! $rs)
        {
        	return array();
        }

        $revsliders = array();


        foreach ($rs as $slider) {
            $revsliders[] = array(
             	'id'    => $slider->id,
                'text'  => $slider->title . ' (<i>'.$slider->alias.'</i>)',
                'icon'  => 'fa fa-file-text-o',
                'state' => array(
                    'selected' => false,
                    'opened'   => false,
                ),
            );
        }


        if(! $revsliders)
        {
        	return array();
        }


        return $revsliders;
    }

    /**
     * Makes nested array of options for JSTree
     * @return array
     */
    public function tree_getReduxOptions()
    {
        global $cbt_redux, $cbt_options;

        foreach ($cbt_redux->sections as $key => $val) {
            $this->eachOptionField($this->optionsFields, $key, $val);
        }

        $this->optionsFields = array_values($this->optionsFields);
        return $this->optionsFields;
    }


    /**
     * Recursively make JSTree object for each option
     * @param  array &$parent Referenced instance of the parent
     * @param  string $id      option id
     * @param  mixed $val     children array or value
     * @return none          modifies the referenced parent
     */
    public function eachOptionField(&$parent, $id, $val)
    {
        static $i;
        if (!$i) {
            $i = 0;
        }

        if (isset($val['id'])
            && isset($val['type'])
            && isset($val['id'])
            && $val['id']
            && $val['type']
            && $val['type'] != 'raw'
            && $val['type'] != 'section') {
            // param
            $text       = (isset($val['title'])) ? $val['title'] : '';
            $parent[$i] = array(
                'id'    => $val['id'],
                //'text' => $text,
                'text'  => $text . ' (<i>' . $val['id'] . '</i>)',
                'icon'  => 'fa fa-file-text-o',
                'state' => array(
                    'selected' => true,
                    'opened'   => false,
                ),
            );
        } elseif (is_array($val) && !isset($val['type'])) {
            // section

            $i = 0;
            if (isset($val['title'])) {

                $parent[$id]['text'] = $val['title'];
                $parent[$id]['icon'] = 'fa fa-archive';

            }
            foreach ($val as $xid => $xval) {
                if (isset($val['title'])) {
                    $this->eachOptionField($parent[$id]['children'], $xid, $xval);
                } else {
                    $this->eachOptionField($parent, $xid, $xval);
                }
            }

            $parent[$id]['children'] = array_values($parent[$id]['children']);

            if (empty($parent[$id]['children'])) {
                unset($parent[$id]);
            }
        }

        $i++;
    }




    public function widgets()
    {
        $save_to = $this->save_dir . '/widgets.json';

        $selectedInclude = (isset($_POST['include'])) ? $_POST['include'] : array();

        if(! in_array('widgets', $selectedInclude))
        {
            return false;
        }

        require_once dirname( __FILE__ ) . '/widget-importer-exporter.php';
        $export_data = wie_generate_export_data();
        file_put_contents($save_to, $export_data);
        return true;
    }



    public function revSlider()
    {
        $save_folder = $this->save_dir . '/revslider';
        if(! class_exists('RevSlider')) return false;

        $selectedSliders = (isset($_POST['sliders'])) ? $_POST['sliders'] : array();

        if(empty($selectedSliders))
            return false;

        $slider = new RevSlider();
        foreach($selectedSliders as $sliderID)
        {
            // ignore JSTree Group ID
            if($sliderID == 'revslider') continue;

            // echo '<pre>'.print_r($sliderID, TRUE).'</pre>';
            $slider->initByID($sliderID);
            ob_start();
            $slider->exportSlider(false);
            $export_data = ob_get_clean();
            if(! $export_data)
                continue;

            wp_mkdir_p($save_folder);
            file_put_contents($save_folder . '/' . $sliderID . '.zip', $export_data);
        }
        return true;
    }

    public function config($save=true, $include = array('nav_menu_locations', 'page_on_front', 'show_on_front', 'page_for_posts'))
    {
        $save_to = $this->save_dir . '/config.json';

        $config = array();

        if(in_array('page_on_front', $include))
            $config['page_on_front'] = get_the_guid( get_option('page_on_front') );

        if(in_array('show_on_front', $include))
            $config['show_on_front'] = get_option('show_on_front');

        if(in_array('page_for_posts', $include))
            $config['page_for_posts'] = get_the_guid( get_option('page_for_posts') );

        if(in_array('nav_menu_locations', $include))
        {
            $nav_menu_locations = get_theme_mod('nav_menu_locations');
            $nav_menu_locations_to_include = array();
            foreach($nav_menu_locations as $key=>$val)
            {
                $term = get_term_by( 'term_id', $val, 'nav_menu' );
                if($term)
                {
                    // echo '<pre>'.print_r($term, TRUE).'</pre>';
                    $nav_menu_locations_to_include[ $key ] = $term->name;
                }
            }

            if(! empty($nav_menu_locations_to_include))
                $config['nav_menu_locations'] = $nav_menu_locations_to_include;
        }

        // echo '<pre>'.print_r($config, TRUE).'</pre>';die();

        if(! is_array($config) OR empty($config))
        {
            return false;
        }

        if(! $save)
        {
            return $config;
        }

        $export_data = json_encode( $config );
        file_put_contents($save_to, $export_data);
        return true;
    }


    public function attachments()
    {
        $save_folder = $this->save_dir . '/attachments/';

        $args = array(
            'post_type'      => 'attachment',
            'numberposts'    => -1,
            'post_status'    => null,
            'post_parent'    => null, // any parent
            'post_mime_type' => 'image',
        );
        $attachments = get_posts($args);
        if ($attachments) {
            foreach ($attachments as $post) {
                //setup_postdata($post);
                //the_title();
                //the_attachment_link($post->ID, false);
                //the_excerpt();

                //echo '<pre>'.print_r(wp_get_attachment_metadata($post->ID), TRUE).'</pre>';
                //echo '<pre>'.print_r(get_attached_file($post->ID), TRUE).'</pre>';
                //echo '<pre>'.print_r($post->guid, TRUE).'</pre>';

                $data = wp_get_attachment_metadata($post->ID);
                if (!$data or !isset($data['file'])) {
                    continue;
                }

                $full_path = get_attached_file($post->ID);
                if (!$full_path) {
                    continue;
                }

                //$folders = explode(DIRECTORY_SEPARATOR, $data['file']);
                $folder  = dirname($data['file']);
                $file    = basename($data['file']);
                $save_to = $save_folder . $folder;

                // echo '<pre>' . print_r($folder, true) . '</pre>';
                // echo '<pre>' . print_r($file, true) . '</pre>';
                // echo '<pre>From: ' . print_r($full_path, true) . '</pre>';
                // echo '<pre>To: ' . print_r($save_to . '/' . $file, true) . '</pre>';

                wp_mkdir_p($save_to);
                copy($full_path, $save_to . '/' . $file);
            }
        }

    }

    public function wpExport()
    {
        $save_to = $this->save_dir . '/content.xml';

        ob_start();
        require_once ABSPATH . 'wp-admin/includes/export.php';
        export_wp();
        $export_data = ob_get_clean();

        if(! $export_data)
            return false;

        file_put_contents( $save_to, $export_data);

        return true;
    }

    /**
     * Filter out options which were not included in selectedOptions
     * @return array filtered options
     */
    public function reduxOptions()
    {
        $save_to = $this->save_dir . '/theme-options.json';
        $selectedOptions = (isset($_POST['options'])) ? $_POST['options'] : array();

        global $cbt_redux, $cbt_options;
        $new_cbt_options = $cbt_options;

        foreach ($cbt_options as $key => $val) {
            if ($key && !in_array($key, $selectedOptions)) {
                unset($new_cbt_options[$key]);
            }
        }

        if (!$new_cbt_options) {
            return false;
        }

        // $new_cbt_options['redux-backup'] = 1;
        file_put_contents( $save_to, json_encode($new_cbt_options) );

        return true;
    }

    public function zip()
    {
        $location = dirname($this->save_dir);
        $zip = st_zip( 
            trailingslashit($location), 
            trailingslashit( dirname($location) ).$this->template_foldername.'.zip' 
        );

        if($zip !== false)
        {
            return $zip;
        }

        return false;
    }

    /**
     * Send the download headers to the browser
     * @param bool $delete
     */
    function download( $file, $delete = true ) {

        if(! file_exists($file))
        {
            return false;
        }
        
        header( 'Content-type: application/zip' );
        header( sprintf( 'Content-Disposition: attachment; filename="%s"', basename($file) ) );
        readfile( $file );

        // remove file if true
        if ( $delete )
            unlink( $file );

        die();
    }


}

global $cbt_export;
$cbt_export = new cbt_export;
