<?php

// function st_array_merge_deep() {
// 	$args = func_get_args();
// 	return st_array_merge_deep_array($args);
// }

// function st_array_merge_deep_array($arrays) {
// 	$result = array();

// 	foreach ($arrays as $array) {
// 		foreach ($array as $key => $value) {
// 			// Renumber integer keys as array_merge_recursive() does. Note that PHP
// 			// automatically converts array keys that are integer strings (e.g., '1')
// 			// to integers.
// 			if (is_integer($key)) {
// 				$result[] = $value;
// 			}
// 			// Recurse when both values are arrays.
// 			elseif (isset($result[$key]) && is_array($result[$key]) && is_array($value)) {
// 				$result[$key] = drupal_array_merge_deep_array(array($result[$key], $value));
// 			}
// 			// Otherwise, use the latter value, overriding any previous value.
// 			else {
// 				$result[$key] = $value;
// 			}
// 		}
// 	}

// 	return $result;
// }

function st_get_id_from_GUID( $guid ){
    global $wpdb;
    return $wpdb->get_var( $wpdb->prepare( "SELECT ID FROM $wpdb->posts WHERE guid=%s LIMIT 1", $guid ) );

}

function st_zip($source, $destination) {
	if (!extension_loaded('zip') || !file_exists($source)) {
		return false;
	}

	$zip = new ZipArchive();
	if (!$zip->open($destination, ZIPARCHIVE::CREATE)) {
		return false;
	}

	$source = str_replace('\\', '/', realpath($source));

	if (is_dir($source) === true) {
		$files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);

		foreach ($files as $file) {
			$file = str_replace('\\', '/', $file);

			// Ignore "." and ".." folders
			if (in_array(substr($file, strrpos($file, '/') + 1), array('.', '..'))) {
				continue;
			}

			$file = realpath($file);

			if (is_dir($file) === true) {
				$zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
			} else if (is_file($file) === true) {
				$zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
			}
		}
	} else if (is_file($source) === true) {
		$zip->addFromString(basename($source), file_get_contents($source));
	}

	return $zip->close();
}
