<?php
class cbt_text_shortcodes
{
	public $shortcodes = array();

	function __construct()
	{
		add_filter('the_content', array($this, 'replace'), 99999999);
		add_filter('st_shortcode_preview_html', array($this, 'replace'), 9999999);
		
		add_filter('st_available_short_tags', array($this, 'available_short_tags'));
		//add_filter('widget_display_callback', array($this, 'replace_array'), 9999999);
		
		//add_filter('st_shortcode_preview_params', array($this, 'replace'));
		//add_filter('st_shortcode_attrs', array($this, 'replace'));
		//add_filter('st_shortcode_content', array($this, 'replace'));
		//
		
		// make shorttags available to tinymce
		add_action('admin_head', array($this, 'shorttags_tinymce'));
	}
	
	
	function get_shortcodes()
	{
		global $cbt_options;
		
		if(! empty($this->shortcodes)) return $this->shortcodes;
		
		if(isset($cbt_options['logo']) && $cbt_options['logo']['url'])
		{
			$logo_url = $cbt_options['logo']['url'];
			$logo = '<a href="'.get_bloginfo( 'url' ).'" title="'.get_bloginfo( 'name' ).'" rel="homepage">
				<img src="'.$cbt_options['logo']['url'].'" />
			</a>';
		} else {
			$logo_url = '';
			$logo = '<a href="'.get_bloginfo( 'url' ).'" title="'.get_bloginfo( 'name' ).'" rel="homepage">'.get_bloginfo( 'name' ).'</a>';
		}
		
		
        if(!empty($cbt_options['footer-copyright-text']))
        {
            $cbt_options['footer-copyright-text'] = preg_replace('/{YEAR}/i',  date('Y'), $cbt_options['footer-copyright-text']);
        }
        

		if(!empty($cbt_options['disable-auto-copyright']) && $cbt_options['disable-auto-copyright'] == 1) { 
			if(!empty($cbt_options['footer-copyright-text'])) $copyright = $cbt_options['footer-copyright-text'];  	
		} else { 
			$copyright = '&copy; '.date('Y') . ' ' . get_bloginfo('name') . ((!empty($cbt_options['footer-copyright-text']))) ? $cbt_options['footer-copyright-text'] : '';  
		} 
		$copyright = '&copy; '.date('Y') . ' ' . get_bloginfo('name') . ((!empty($cbt_options['footer-copyright-text'])) ? $cbt_options['footer-copyright-text'] : ''); 
		
		
		
		
		
		$this->shortcodes = array(
			'site_logo' => $logo,
			'site_logo_url' => $logo_url,
			'phone' => $cbt_options['social-phone'],
			'email' => $cbt_options['social-email'],
/*
			'facebook' => $cbt_options['social-facebook'],
			'twitter' => $cbt_options['social-twitter'],
			'linkedin' => $cbt_options['social-linkedin'],
			'google\+' => $cbt_options['social-google'],
			'google' => $cbt_options['social-google'],
*/
			'rss' => get_bloginfo('rss2_url'),
			
			'phone tag' => '<a href="tel:'.$cbt_options['social-phone'].'"><i class="fa fa-phone"></i>  '.$cbt_options['social-phone'].'</a>',
			'email tag' => '<a target="_blank" href="mailto:'.$cbt_options['social-email'].'"><i class="fa fa-envelope"></i> '.$cbt_options['social-email'].'</a>',
			
/*
			'facebook tag' => '<a target="_blank" href="'.$cbt_options['social-facebook'].'"><i class="fa fa-facebook"></i></a>',
			'twitter tag' => '<a target="_blank" href="'.$cbt_options['social-twitter'].'"><i class="fa fa-twitter"></i></a>',
			'linkedin tag' => '<a target="_blank" href="'.$cbt_options['social-linkedin'].'"><i class="fa fa-linkedin"></i></a>',
			'google\+ tag' => '<a target="_blank" href="'.$cbt_options['social-google'].'"><i class="fa fa-google-plus"></i></a>',
			'google tag' => '<a target="_blank" href="'.$cbt_options['social-google'].'"><i class="fa fa-google-plus"></i></a>',
*/

			'rss tag' => '<a href="'.get_bloginfo('rss2_url').'"><i class="fa fa-rss"></i></a>',
			
			'copyright' => $copyright,
			'map-latitude' => $cbt_options['center-lat'],
			'map-longitude' => $cbt_options['center-lng'],
		);
		
		$this->shortcodes['social icons'] = '';
		
		foreach ($cbt_options['social-icons'] as $idx => $arr) 
		{
		    if (! $arr['enabled']) continue;

			$this->shortcodes[ strtolower($arr['name']) ] = $arr['url'];
			
			$this->shortcodes[ strtolower($arr['name']).' tag' ] = '<a title="'.$arr['name'].'" target="_blank" href="'.$arr['url'].'"><i class="fa '.$arr['icon'].'"></i></a>';
			
			$this->shortcodes['social icons'] .= $this->shortcodes[ strtolower($arr['name']).' tag' ].' &nbsp;';
		}	
		
		
		
		
		return $this->shortcodes;
	}
	
	
	function replace($content)
	{
		$shortcodes = $this->get_shortcodes();
		
		//if()
		
		foreach($shortcodes as $key=>$val)
		{
			//$content = preg_replace("/\{$key\}/i", $val, $content);
			$content = str_replace('{'.$key.'}', $val, $content);
		}
		
		return $content;
	}
	
	
	function replace_array($array)
	{
		if(! is_array($array) OR empty($array)) return $array;
		
		$new_array = array();
		
		foreach($array as $key=>$val)
		{
			if(! is_string($val)) continue;
			
			$new_array[ $key ] = $this->replace($val);
		}

		
		return $new_array;
	}
	
	
	function available_short_tags($short_tags=array())
	{
		$tags = array(
			'site_logo',
			'site_logo_url',
			'phone',
			'email',
			'social icons',
/*
			'facebook',
			'twitter',
			'linkedin',
			'google',
*/
			'rss',
			'phone tag',
			'email tag',
/*
			'facebook tag',
			'twitter tag',
			'linkedin tag',
			'google tag',
*/
			'rss tag',	
			'copyright',
			'map-latitude',
			'map-longitude',
		);
		
		global $cbt_options;
		
		foreach ($cbt_options['social-icons'] as $idx => $arr) 
		{
		    if (! $arr['enabled']) continue;

			$tags[] = strtolower($arr['name']);
			$tags[] = strtolower($arr['name']).' tag';
		}	
		
		//echo '<pre>'.print_r($tags, TRUE).'</pre>';
		
		return $tags;
	}


	public function shorttags_tinymce()
	{
		$short_tags = apply_filters('st_available_short_tags', array());

		$list = '';
		if( is_array($short_tags) && ! empty($short_tags) )
		{
			$first = true;
			foreach($short_tags as $short_tag)
			{
				if( ! $first) $list .= ',';
				
				$list .= "'{".$short_tag."}'";
				$first = false;
			}
		}
		?>
		<script type="text/javascript">
			var st_shorttags = [<?php echo $list; ?>];
		</script>
		<?php
	}


}


global $cbt_text_shortcodes;
$cbt_text_shortcodes = new cbt_text_shortcodes();

function cbt_text_shortcodes_process($content)
{
	global $cbt_text_shortcodes;
	
	if(! $content) return $content;

	if(is_array($content))
	{
		return $cbt_text_shortcodes->replace_array($content);
	}
	elseif(! is_string($content)) return $content;
	else
	{
		return $cbt_text_shortcodes->replace($content);
	}
}
				
				
				
				
