<?php
	
class Cbt_update 
{
	function __construct()
	{
		$theme = wp_get_theme();
		$new = $theme->display('Version');
		$old = get_option('cbt_theme_version');

		$new = intval(str_replace('.', '', $new));
		$old = intval(str_replace('.', '', $old));
		
		if($new == $old) return;
		
		update_option('cbt_do_auto_redux_compiler', 'yes');
		update_option('cbt_theme_version', $new );
		
		$this->do_update($new, $old);
	}
	
	
	function do_update($new, $old)
	{
		global $cbt_redux, $cbt_options;
		
		if($old < 206)
		{
			if(! isset($cbt_options['nav-mobile-color']) OR ! $cbt_options['nav-mobile-color'])
			{
				$cbt_redux->ReduxFramework->set('nav-mobile-color', $cbt_options['color1']);
				$cbt_redux->ReduxFramework->set('nav-mobile-text-color', '#fff');
				$cbt_redux->ReduxFramework->set('nav-mobile-btn-color', $cbt_options['color2']);
				$cbt_redux->ReduxFramework->set('text-color', '#626B75');
			}
		}
		
		if($old < 211)
		{
			$new_icons = array();
			foreach($cbt_options['social-icons'] as $key=>$val)
			{
				if($cbt_options['social-facebook'] && $val['id']=='facebook')
				{
					$val['enabled'] = true;
					$val['url'] = $cbt_options['social-facebook'];
				}
				
				if($cbt_options['social-twitter'] && $val['id']=='twitter')
				{
					$val['enabled'] = true;
					$val['url'] = $cbt_options['social-twitter'];
				}
				
				if($cbt_options['social-google'] && $val['id']=='google')
				{
					$val['enabled'] = true;
					$val['url'] = $cbt_options['social-google'];
				}
				
				if($cbt_options['social-linkedin'] && $val['id']=='linkedin')
				{
					$val['enabled'] = true;
					$val['url'] = $cbt_options['social-linkedin'];
				}
				
				$new_icons[ $key ] = $val;
			}
				
			$cbt_redux->ReduxFramework->set('social-icons', $new_icons);
		}
		
		if(! empty($old) && $old < 310)
		{
			// recheck for license key
			update_option('cbt_c_l_t', 0);
		}


		if(! empty($old) && $old < 399)
		{
			update_option( 'st_pagebuilder_upgrade', 'yes' );

			$this->builder_settings_to_redux();

			//disable old proslyler builder
		    $plugins = array(
		        'wpglow-builder/wpglow-builder.php',
		    );
		    require_once(ABSPATH . 'wp-admin/includes/plugin.php');
			deactivate_plugins($plugins);
		}
		
	}


	/**
	 * Converts old builder settings to redux
	 * @return [type] [description]
	 */
	public function builder_settings_to_redux()
	{
		global $cbt_redux, $cbt_options;

		// get old builder settings
		$settings = $this->get_builder_old_settings();
		//echo '<pre>'.print_r($settings, TRUE).'</pre>';
		if(! $settings) return false;

		$settings = wp_parse_args( $settings, array(
			'st_pb_settings_enable_for' => '',
			'st_pb_settings_cache' => '',
			'st_pb_settings_help_tab' => '',
		) );

		// builder_disabled_for
		$builder_disabled_for = $this->convert_legacy_builder_defaults_for_disabled( $settings['st_pb_settings_enable_for'] );

		// builder_cache
		if ( $settings['st_pb_settings_cache'] == 'enable' )
			$builder_cache = 1;
		else
			$builder_cache = 0;

		// builder_disable_help_tab
		if ( $settings['st_pb_settings_help_tab'] == 'enable' )
			$builder_disable_help_tab = 0;
		else
			$builder_disable_help_tab = 1;

		// save to redux
		$cbt_redux->ReduxFramework->set('builder_disabled_for', $builder_disabled_for );
		$cbt_redux->ReduxFramework->set('builder_cache', $builder_cache );
		$cbt_redux->ReduxFramework->set('builder_disable_help_tab', $builder_disable_help_tab );
	}


	/**
	 * Returns old builder "enabled for" settings converted to redux
	 * @param  array|string $st_pb_settings_enable_for 
	 * @return array          disabled post types
	 */
	public function convert_legacy_builder_defaults_for_disabled($st_pb_settings_enable_for)
	{
		// get post types
		$options = cbt::get_post_types();

		$defaults = array();

		if ( 'enable' == $st_pb_settings_enable_for OR ! is_array( $st_pb_settings_enable_for ) )
		{
			return $defaults;
		}

		foreach($options as $key=>$val)
		{
			$defaults[ $key ] = '1';

			if (  ! isset( $st_pb_settings_enable_for[ $key ] ) 
					|| 'enable' == $st_pb_settings_enable_for[ $key ]
				)
			{
				$defaults[ $key ] = '0';
			}
		}


		return $defaults;
	}


	/**
	 * Gets old wr builder settings for conversion
	 * @return array key value pair of settings
	 */
	public function get_builder_old_settings() {

		// Define options
		$options  = array( 'wr_pb_settings_enable_for','wr_pb_settings_help_tab','wr_pb_settings_cache', 'wr_pb_settings_fullmode', 'wr_pb_settings_boostrap_js', 'wr_pb_settings_boostrap_css' );

		// Get saved options value
		$data = array();

		foreach ( $options as $key ) {
			$data[$key] = get_option( $key, ( $key != 'wr_pb_settings_fullmode' ) ? 'enable' : 'disable' );
		}

		return $data;
	}
	
}