<?php
/**
 * Footer Contact Widget Class
 */
class widget_contact extends WP_Widget {
 
 	public $fields = array(
 			'title'=>'Widget Title',
 			'address'=> 'Address',
			'map_lat'=>'Location Latitude',
			'map_lng'=>'Location Longitude',
			'map_zoom'=>'Map Zoom Level',
	);
	
 	public $defaults;
 
    /** constructor -- name this the same as the class above */
    function widget_contact() {
    
    	$this->defaults = array(
 			'title'=>'',
 			'address'=> '',
			'map_lat'=>'',
			'map_lng'=>'',
			'map_zoom'=>'10',
		);
    
        parent::WP_Widget(false, $name = 'Footer Contact Widget');	
    }
 
    /** @see WP_Widget::widget -- do not rename this */
    function widget($args, $instance) {	
        extract( $args );
        
        $instance = cbt_text_shortcodes_process($instance);
        
        global $cbt_options;
        
        wp_enqueue_script("google_maps_api","https://maps.googleapis.com/maps/api/js?key={$cbt_options['googlemaps-api']}&v=3.exp","1.0",array(),false);
        
		foreach($this->fields as $field=>$name)
		{
			$value = esc_attr($instance[$field]);
			if(! $value) $value = $this->defaults[$field];
			
			$data[$field] = $value;
		}
        
        $title 		= apply_filters('widget_title', $data['title']);

		if(! $data['map_zoom'] OR !is_numeric($data['map_zoom'])) $data['map_zoom'] = '10';
        ?>
	          <?php echo $before_widget; ?>
	              <?php echo $before_title . $title . $after_title; ?>
	              
	              <?php if($data['map_lat'] AND $data['map_lng']):?>
				  	<div id="fcw_map" class="fcw_map" data-lat="<?php echo $data['map_lat']; ?>" data-lng="<?php echo $data['map_lng']; ?>" data-zoom="<?php echo $data['map_zoom']; ?>"></div>
				  <?php endif;?>
				  
				  <div class="fcw_info">
					<ul class="fcw_contact">
						<?php if($cbt_options['social-phone']){?>
							<li><i class="fa fa-phone"></i> <p><?php echo __('Phone', 'cbt');?>: <a href="tel:<?php echo $cbt_options['social-phone']?>"><?php echo $cbt_options['social-phone']?></a></p></li>
						<?php } ?>
						<?php if($cbt_options['social-email']){?>
							<li><i class="fa fa-envelope"></i> <p><?php echo __('Email', 'cbt');?>: <a target="_blank" href="mailto:<?php echo $cbt_options['social-email']?>"><?php echo $cbt_options['social-email']?></a></p></li>
						<?php } ?>
						<?php if($data['address']){?>
							<li><i class="fa fa-location-arrow"></i> <p><?php echo __('Address', 'cbt');?>: <?php echo $data['address']?></p></li>
						<?php } ?>
					</ul>
					<div class="clearfix"></div>
					
					<ul class="fcw_social">
						
						<?php
							foreach ($cbt_options['social-icons'] as $idx => $arr) 
							{
							    if (! $arr['enabled']) continue;
			
							    echo '<li><a title="'.$arr['name'].'" target="_blank" href="'.$arr['url'].'"><i class="fa '.$arr['icon'].'"></i></a></li>';
							}	
						?>
			
						<?php if($cbt_options['social-rss']){?>
							<li><a href="<?php bloginfo('rss2_url'); ?>"><i class="fa fa-rss"></i></a></li>
						<?php } ?>
					</ul>
				  </div>
	          <?php echo $after_widget; ?>
        <?php
    }
 
    /** @see WP_Widget::update -- do not rename this */
    function update($new_instance, $old_instance) {		
		$instance = $old_instance;

		foreach($this->fields as $field=>$name)
		{
			$instance[$field] = strip_tags($new_instance[$field]);
		}
		
		//$instance['title'] = strip_tags($new_instance['title']);
		//$instance['message'] = strip_tags($new_instance['message']);
		
        return $instance;
    }
 
    /** @see WP_Widget::form -- do not rename this */
    function form($instance) 
    {	
	    echo '<p>'.__('To convert an address into latitude & longitude please use <a target="_blank" href="http://www.latlong.net/convert-address-to-lat-long.html">this converter.</a>', 'cbt').'</p>';
    
		foreach($this->fields as $field=>$name)
		{
			$value = esc_attr($instance[$field]);
			if(! $value) $value = $this->defaults[$field];
			
	        ?>
			<p>
				<label for="<?php echo $this->get_field_id($field); ?>"><?php echo $name; ?>:</label> 
				<input class="widefat" id="<?php echo $this->get_field_id($field); ?>" name="<?php echo $this->get_field_name($field); ?>" type="text" value="<?php echo $value; ?>" />
			</p>
	        <?php 
		}
		

    }
 
 
} // end class example_widget
add_action('widgets_init', create_function('', 'return register_widget("widget_contact");'));
